/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

public class NmxTimeFormat {
    private static final int LENGTH_OF_DAY = 86400000;
    private static final int LENGTH_OF_HOUR = 3600000;
    private static final int LENGTH_OF_MINUTE = 60000;
    private static final int LENGTH_OF_SECOND = 1000;

    public String format(long milliseconds) {
        StringBuffer buffer = new StringBuffer();
        boolean dateStarted = false;
        long value = milliseconds / 86400000L;
        milliseconds %= 86400000L;
        if (value > 0L) {
            buffer.append(value);
            buffer.append("d ");
        }
        dateStarted = true;
        value = milliseconds / 3600000L;
        milliseconds %= 3600000L;
        if (value > 0L || dateStarted) {
            buffer.append(this.toDigitString(value, 2));
            buffer.append(":");
            dateStarted = true;
        }
        value = milliseconds / 60000L;
        milliseconds %= 60000L;
        if (value > 0L || dateStarted) {
            buffer.append(this.toDigitString(value, 2));
            buffer.append(":");
        }
        value = milliseconds / 1000L;
        milliseconds %= 1000L;
        if (value > 0L || dateStarted) {
            buffer.append(this.toDigitString(value, 2));
            buffer.append(".");
            buffer.append(this.toDigitString(milliseconds, 3));
        }
        return buffer.toString();
    }

    private String toDigitString(long value, int numDigits) {
        StringBuffer buffer = new StringBuffer();
        if (numDigits == 2) {
            buffer.append("0");
        } else if (numDigits == 3) {
            buffer.append("00");
        } else {
            int i = 1;
            while (i < numDigits) {
                buffer.append("0");
                ++i;
            }
        }
        buffer.append(value);
        int size = buffer.length();
        if (size == numDigits) {
            return buffer.toString();
        }
        return buffer.substring(size - numDigits, size);
    }
}

