/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.ErrorLog;
import ca.nanometrics.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class PrintLog
implements ErrorLog {
    static final String PAD_STRING = "................";
    static final int PAD_LENGTH = "................".length();
    private int verbosity = 2;
    private String localSource = "";
    private DateFormat dateFormatter = new SimpleDateFormat(this.getDateFormat());

    public PrintLog() {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    protected String getDateFormat() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    protected void report(String formattedMessage) {
        System.out.println(formattedMessage);
    }

    private String getPaddedName(String name) {
        StringBuffer buff = new StringBuffer();
        buff.append(name);
        buff.append(PAD_STRING);
        buff.setLength(PAD_LENGTH);
        return buff.toString();
    }

    private String getClassName(Object obj) {
        String className = obj.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    public void report(Object obj, int errNum, int severity, String message) {
        if (severity < 0 || severity > 5) {
            throw new IndexOutOfBoundsException("illegal log severity: " + severity);
        }
        if (severity >= this.verbosity) {
            this.buildReport(this.getClassName(obj), errNum, severity, message);
        }
    }

    public void report(String name, int errNum, int severity, String message) {
        if (severity < 0 || severity > 5) {
            throw new IndexOutOfBoundsException("illegal log severity: " + severity);
        }
        if (severity >= this.verbosity) {
            this.buildReport(name, errNum, severity, message);
        }
    }

    public synchronized void report(int severity, long time, String source, String message) {
        if (severity < 0 || severity > 5) {
            severity = 6;
        }
        if (severity >= this.verbosity) {
            this.buildReport(severity, time, source, message);
        }
    }

    public synchronized void report(int severity, int errNum, long time, String source, String message) {
        if (severity < 0 || severity > 5) {
            severity = 6;
        }
        if (severity >= this.verbosity) {
            this.buildReport(severity, errNum, time, source, message);
        }
    }

    private void buildReport(String name, int errNum, int severity, String message) {
        this.buildReport(severity, System.currentTimeMillis(), this.getSource(), String.valueOf(this.getPaddedName(name)) + "(" + errNum + ") " + message);
    }

    private void buildReport(int severity, int errNum, long time, String name, String message) {
        this.buildReport(severity, time, this.getSource(), String.valueOf(this.getPaddedName(name)) + "(" + errNum + ") " + message);
    }

    private void buildReport(int severity, long time, String source, String message) {
        this.report(String.valueOf(Log.severityLabel[severity]) + " " + this.dateFormatter.format(new Date(time)) + " " + source + " " + message);
    }

    public void setSource(String source) {
        this.localSource = source;
    }

    protected String getSource() {
        return this.localSource;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int severity) {
        if (severity < 0 || severity > 5) {
            throw new IndexOutOfBoundsException("Invalid log verbosity setting");
        }
        if (this.verbosity != severity) {
            this.verbosity = severity;
            Log.report(this, 1, 2, "Log verbosity set to " + Log.verbosityName[this.verbosity]);
        }
    }
}

