/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TextTable {
    private static final int DEFAULT_WIDTH = 15;
    private List rows = new ArrayList();
    private List colHeaders;
    private int[] colWidths = new int[0];
    private int defaultColWidth = 15;

    public TextTable() {
    }

    public TextTable(int numCols, int defaultWidth) {
        this();
        this.setDefaultColWidth(defaultWidth);
        this.setNumCols(numCols);
    }

    public void addRow(List cols) {
        this.rows.add(cols);
    }

    public int getNumCols() {
        return this.colWidths.length;
    }

    public void setNumCols(int newLength) {
        int oldLength = this.colWidths.length;
        int[] tempWidths = this.colWidths;
        this.colWidths = new int[newLength];
        int length = Math.min(oldLength, newLength);
        System.arraycopy(tempWidths, 0, this.colWidths, 0, length);
        if (newLength > oldLength) {
            Arrays.fill(this.colWidths, oldLength, newLength, this.defaultColWidth);
        }
    }

    public void setColWidths(int[] widths) {
        this.colWidths = widths;
    }

    public void setColWidth(int col, int width) {
        this.colWidths[col] = width;
    }

    public int getDefaultColWidth() {
        return this.defaultColWidth;
    }

    public void setDefaultColWidth(int i) {
        this.defaultColWidth = i;
    }

    public List getColHeaders() {
        return this.colHeaders;
    }

    public void setColHeaders(List list) {
        this.colHeaders = list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int totalLength = 0;
        int coli = 0;
        while (coli < this.getNumCols()) {
            totalLength += this.colWidths[coli];
            ++coli;
        }
        sb.append("#");
        sb.append(StringHelper.stringRepeatingChar('_', totalLength));
        sb.append("\n");
        Iterator iter = this.colHeaders.iterator();
        while (iter.hasNext()) {
            List headerList = (List)iter.next();
            sb.append("#");
            sb.append(this.getFormattedRow(headerList));
        }
        sb.append("#");
        sb.append(StringHelper.stringRepeatingChar('-', totalLength));
        sb.append("\n");
        iter = this.rows.iterator();
        while (iter.hasNext()) {
            List colList = (List)iter.next();
            sb.append(this.getFormattedRow(colList));
        }
        sb.append("#");
        sb.append(StringHelper.stringRepeatingChar('_', totalLength));
        sb.append("\n");
        return sb.toString();
    }

    private String getFormattedRow(List colObjects) {
        StringBuffer rowSB = new StringBuffer();
        int coli = 0;
        while (coli < this.getNumCols()) {
            Object obj = colObjects.get(coli);
            rowSB.append(this.getFormattedCell(obj, coli));
            ++coli;
        }
        rowSB.append("\n");
        return rowSB.toString();
    }

    private String getFormattedCell(Object obj, int col) {
        String s = StringHelper.toFixedLength(obj.toString(), this.colWidths[col]);
        return s;
    }
}

