/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.util.LittleEndianDataInput;
import ca.nanometrics.yfile.Taggable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DataTag {
    public static final int LENGTH = 16;
    private static final char MSB_FIRST = 'M';
    private static final char LSB_FIRST = 'I';
    private static final byte MAGIC = 31;
    private boolean forward;
    private byte magic;
    private int type;
    private int next;
    private int nextSame;
    private int spare;

    public DataTag(int dataType, int dataLength, int bytesToSame, boolean fwd) {
        this.forward = fwd;
        this.magic = (byte)31;
        this.type = dataType;
        this.next = dataLength;
        this.nextSame = bytesToSame;
        this.spare = 0;
    }

    public DataTag(int dataType, int dataLength, int bytesToSame) {
        this(dataType, dataLength, bytesToSame, true);
    }

    public DataTag(int dataType, int dataLength) {
        this(dataType, dataLength, 0, true);
    }

    public DataTag(DataInput input) throws IOException {
        this.readFrom(input);
    }

    public void readFrom(DataInput input) throws IOException {
        char format = (char)input.readByte();
        if (format != 'M' && format != 'I') {
            throw new IOException("Invalid DataTag format");
        }
        this.forward = format == 'M';
        this.magic = input.readByte();
        if (this.magic != 31) {
            throw new IOException("Invalid DataTag");
        }
        if (!this.isForwardByteOrder()) {
            input = new LittleEndianDataInput(input);
        }
        this.type = input.readShort();
        this.next = input.readInt();
        this.nextSame = input.readInt();
        this.spare = input.readInt();
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeByte(this.getFormat());
        output.writeByte(this.magic);
        output.writeShort(this.type);
        output.writeInt(this.next);
        output.writeInt(this.nextSame);
        output.writeInt(this.spare);
    }

    public static DataTag getTag(DataInput input, int type) throws IOException {
        DataTag tag = new DataTag(0, 0);
        while (true) {
            tag.readFrom(input);
            if (tag.getType() == type) {
                return tag;
            }
            input.skipBytes(tag.getNext());
        }
    }

    public static void writeRecord(DataOutput output, Taggable rec) throws IOException {
        DataTag tag = new DataTag(rec.getTagNumber(), rec.getDataLength());
        tag.writeTo(output);
        rec.writeTo(output);
    }

    public int getType() {
        return this.type;
    }

    public int getNext() {
        return this.next;
    }

    public int getNextSame() {
        return this.nextSame;
    }

    public boolean isForwardByteOrder() {
        return this.forward;
    }

    public void setForwardByteOrder(boolean fwd) {
        this.forward = fwd;
    }

    public char getFormat() {
        return this.forward ? (char)'M' : 'I';
    }

    public String toString() {
        return "Tag " + this.type + " (" + this.getFormat() + "): " + this.next + ", " + this.nextSame + ", " + this.spare;
    }
}

