/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.yfile.YSection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class DatabaseKey
extends YSection {
    public static final int FLAG_LENGTH = 8;
    public static final int KEY_LENGTH = 16;
    public static final int DATA_LENGTH = 32;
    private byte[] updateFlags = new byte[8];
    private double loadDate = 0.0;
    private byte[] recordID = new byte[16];

    protected DatabaseKey(int tagnum) {
        super(tagnum, 32);
    }

    protected DatabaseKey(int tagnum, DataInput input) throws IOException {
        this(tagnum);
        this.readFrom(input);
    }

    public void readFrom(DataInput input) throws IOException {
        input.readFully(this.updateFlags);
        this.loadDate = input.readDouble();
        input.readFully(this.recordID);
    }

    public void writeTo(DataOutput output) throws IOException {
        output.write(this.updateFlags);
        output.writeDouble(this.loadDate);
        output.write(this.recordID);
    }

    public void display(PrintStream out) {
        out.println("  LoadDate = " + this.getLoadDate());
        out.println("  RecordID = " + this.getRecordID());
    }

    public double getLoadDate() {
        return this.loadDate;
    }

    public void setLoadDate(double date) {
        this.loadDate = date;
    }

    public String getRecordID() {
        return this.getStringField(this.recordID);
    }

    public void setRecordID(String id) {
        this.setStringField(this.recordID, id);
    }
}

