/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.yfile.StnId;
import ca.nanometrics.yfile.YSection;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class StnInfo
extends YSection {
    public static final int TAG_NUMBER = 1;
    public static final int FLAG_LENGTH = 8;
    public static final int STNID_LENGTH = 10;
    public static final int NETWORK_LENGTH = 51;
    public static final int SITENAME_LENGTH = 61;
    public static final int COMMENT_LENGTH = 31;
    public static final int SENSOR_LENGTH = 51;
    public static final int FORMAT_LENGTH = 7;
    public static final int DATA_LENGTH = 219;
    private byte[] updateFlags = new byte[8];
    private StnId stnid = new StnId();
    private byte[] networkID = new byte[51];
    private byte[] siteName = new byte[61];
    private byte[] comment = new byte[31];
    private byte[] sensorType = new byte[51];
    private byte[] dataFormat = new byte[7];

    public StnInfo() {
        super(1, 219);
        this.setDataFormat("X");
    }

    public StnInfo(DataInput input) throws IOException {
        this();
        this.readFrom(input);
    }

    public void readFrom(DataInput input) throws IOException {
        input.readFully(this.updateFlags);
        this.stnid.readFrom(input);
        input.readFully(this.networkID);
        input.readFully(this.siteName);
        input.readFully(this.comment);
        input.readFully(this.sensorType);
        input.readFully(this.dataFormat);
    }

    public void writeTo(DataOutput output) throws IOException {
        output.write(this.updateFlags);
        this.stnid.writeTo(output);
        output.write(this.networkID);
        output.write(this.siteName);
        output.write(this.comment);
        output.write(this.sensorType);
        output.write(this.dataFormat);
    }

    public void display(PrintStream out) {
        out.println("Station Info:");
        out.println("  STNID      = " + this.getStnid());
        out.println("  NetworkID  = " + this.getNetworkID());
        out.println("  SiteName   = " + this.getSiteName());
        out.println("  Comment    = " + this.getComment());
        out.println("  SensorType = " + this.getSensorType());
        out.println("  DataFormat = " + this.getDataFormat());
    }

    public StnId getStnid() {
        return this.stnid;
    }

    public String getStationName() {
        return this.stnid.getStationName();
    }

    public String getLocationName() {
        return this.stnid.getLocationName();
    }

    public String getChannelName() {
        return this.stnid.getChannelName();
    }

    public String getNetworkID() {
        return this.getStringField(this.networkID);
    }

    public String getSiteName() {
        return this.getStringField(this.siteName);
    }

    public String getComment() {
        return this.getStringField(this.comment);
    }

    public String getSensorType() {
        return this.getStringField(this.sensorType);
    }

    public String getDataFormat() {
        return this.getStringField(this.dataFormat);
    }

    public void setStationName(String name) {
        this.stnid.setStationName(name);
    }

    public void setLocationName(String name) {
        this.stnid.setLocationName(name);
    }

    public void setChannelName(String name) {
        this.stnid.setChannelName(name);
    }

    public void setNetworkID(String name) {
        this.setStringField(this.networkID, name);
    }

    public void setSiteName(String name) {
        this.setStringField(this.siteName, name);
    }

    public void setComment(String text) {
        this.setStringField(this.comment, text);
    }

    public void setSensorType(String type) {
        this.setStringField(this.sensorType, type);
    }

    public void setDataFormat(String format) {
        this.setStringField(this.dataFormat, format);
    }
}

