/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.yfile;

import ca.nanometrics.yfile.Taggable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;

public class YData
implements Taggable {
    static final int TAG_NUMBER = 7;
    private int[] data;

    public YData() {
        this.data = new int[0];
    }

    public YData(int[] vals) {
        this.setData(vals);
    }

    public YData(double[] vals) {
        this.setData(vals);
    }

    public void setData(int[] vals) {
        this.data = vals != null ? vals : new int[0];
    }

    public void setData(double[] vals) {
        if (vals != null) {
            int numvals = vals.length;
            this.data = new int[numvals];
            int ix = 0;
            while (ix < numvals) {
                this.data[ix] = (int)Math.round(vals[ix]);
                ++ix;
            }
        } else {
            this.data = new int[0];
        }
    }

    public int[] getData() {
        return (int[])this.data.clone();
    }

    public int getNumSamples() {
        return this.data.length;
    }

    public int getDataLength() {
        return 4 * this.data.length;
    }

    public int getTagNumber() {
        return 7;
    }

    public void readFrom(DataInput input, int length) throws IOException {
        int numvals = length / 4;
        if (numvals < 0) {
            numvals = 0;
        }
        if (numvals != this.data.length) {
            this.data = new int[numvals];
        }
        int ix = 0;
        while (ix < numvals) {
            this.data[ix] = input.readInt();
            ++ix;
        }
    }

    public void writeTo(DataOutput output) throws IOException {
        if (this.data != null) {
            int ix = 0;
            while (ix < this.data.length) {
                output.writeInt(this.data[ix]);
                ++ix;
            }
        }
    }

    public int getMinSample() {
        int minVal = 0;
        int length = this.data.length;
        if (length > 0) {
            minVal = this.data[0];
            int ix = 1;
            while (ix < length) {
                if (minVal > this.data[ix]) {
                    minVal = this.data[ix];
                }
                ++ix;
            }
        }
        return minVal;
    }

    public int getMaxSample() {
        int maxVal = 0;
        int length = this.data.length;
        if (length > 0) {
            maxVal = this.data[0];
            int ix = 1;
            while (ix < length) {
                if (maxVal < this.data[ix]) {
                    maxVal = this.data[ix];
                }
                ++ix;
            }
        }
        return maxVal;
    }

    public double getDcOffset() {
        int length = this.data.length;
        double sum = 0.0;
        int ix = 0;
        while (ix < length) {
            sum += (double)this.data[ix];
            ++ix;
        }
        if (length > 0) {
            sum /= (double)length;
        }
        return sum;
    }

    public void display(PrintStream out) {
        out.println("YData:  " + this.data.length + " values");
        if (this.data.length > 0) {
            int min = this.data[0];
            int max = this.data[0];
            int ix = 0;
            while (ix < this.data.length) {
                if (min > this.data[ix]) {
                    min = this.data[ix];
                }
                if (max < this.data[ix]) {
                    max = this.data[ix];
                }
                ++ix;
            }
            out.println("  min = " + min);
            out.println("  max = " + max);
        }
    }
}

