/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractSohTableRow
extends Observable
implements SohTableRow {
    private int key;
    private String name;
    private String instrument;
    protected int bundleType = 0;
    DateNode dateNode;

    protected AbstractSohTableRow(int ckey, String cname) {
        this.key = ckey;
        this.name = cname;
        int ID = ChannelKey.getIDOf(this.key);
        this.instrument = Instrument.getNameOf(ID);
    }

    public int getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getStationName() {
        if (this.name.indexOf(".") >= 0) {
            return this.name.substring(0, this.name.indexOf("."));
        }
        return this.name;
    }

    public String getChannelName() {
        if (this.name.indexOf(".") >= 0) {
            return this.name.substring(this.name.indexOf(".") + 1);
        }
        return this.name;
    }

    public boolean hasPopup(int col) {
        return false;
    }

    public DoubleNode getDoubleNode(int col) {
        return null;
    }

    protected DateNode getDateNode() {
        if (this.dateNode == null) {
            this.dateNode = new DateNode(this.getStationName(), this.getChannelName(), this.getInstrument(), this.bundleType);
        }
        return this.dateNode;
    }

    public SohViewSettings getViewSettings() {
        return new SohViewSettings();
    }

    public void addThisObserver(Observer o) {
        super.addObserver(o);
    }

    public boolean isActive() {
        return this.getDateNode().getCurrentTime() > 0L;
    }

    public void updateRow(SohTableRow row) {
    }
}

