/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationCommand;
import ca.nanometrics.uitools.table.VectorTableModel;
import ca.nanometrics.util.ErrorDisplay;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;

public class CalibrationAgent
implements SelectionAgent {
    private ViewerController parent;
    private VectorTableModel channels;

    public CalibrationAgent(ViewerController frame, VectorTableModel chanTable) {
        this.parent = frame;
        this.channels = chanTable;
    }

    protected Enumeration elements() {
        return this.channels.elements();
    }

    protected boolean contains(Object item) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (!e.nextElement().equals(item)) continue;
            return true;
        }
        return false;
    }

    public void setSelected(Selectable object, boolean request) {
        if (object instanceof CalibrationChannel && this.contains(object)) {
            if (request) {
                this.select((CalibrationChannel)object);
            } else {
                this.deselect((CalibrationChannel)object);
            }
        }
    }

    private Vector getInstrumentSubset(int ID) {
        Vector<CalibrationChannel> subset = new Vector<CalibrationChannel>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            CalibrationChannel chan;
            Object obj = e.nextElement();
            if (!(obj instanceof CalibrationChannel) || (chan = (CalibrationChannel)obj).getInstrumentID() != ID) continue;
            subset.addElement(chan);
        }
        return subset;
    }

    private Vector getSelectedChannels() {
        Vector<CalibrationChannel> subset = new Vector<CalibrationChannel>();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            CalibrationChannel item;
            Object obj = e.nextElement();
            if (!(obj instanceof CalibrationChannel) || !(item = (CalibrationChannel)obj).isSelected()) continue;
            subset.addElement(item);
        }
        return subset;
    }

    private Vector getSelectedSubset(Vector candidates) {
        Vector<Selectable> subset = new Vector<Selectable>();
        Enumeration e = candidates.elements();
        while (e.hasMoreElements()) {
            Selectable item = (Selectable)e.nextElement();
            if (!item.isSelected()) continue;
            subset.addElement(item);
        }
        return subset;
    }

    private Vector getUnselectedSubset(Vector candidates) {
        Vector<Selectable> subset = new Vector<Selectable>();
        Enumeration e = candidates.elements();
        while (e.hasMoreElements()) {
            Selectable item = (Selectable)e.nextElement();
            if (item.isSelected()) continue;
            subset.addElement(item);
        }
        return subset;
    }

    private void setSelected(Vector set, boolean request) {
        Enumeration e = set.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof Selectable)) continue;
            Selectable chan = (Selectable)obj;
            chan.setSelected(request);
        }
    }

    private int getSelectPermission(CalibrationChannel target, CalibrationChannel dependent) {
        SelectDialog sd = new SelectDialog(this.parent, "Dependent calibration channels", "Selecting channel  " + target.getChannelName(), "also requires selecting channel " + dependent.getChannelName());
        sd.setVisible(true);
        return sd.getResult();
    }

    private int getDeselectPermission(CalibrationChannel target, CalibrationChannel dependent) {
        SelectDialog sd = new SelectDialog(this.parent, "Dependent calibration channels", "Deselecting channel  " + target.getChannelName(), "also requires deselecting channel " + dependent.getChannelName());
        sd.setVisible(true);
        return sd.getResult();
    }

    private Hashtable buildCalSetTable(Vector selectedChannels) {
        Hashtable<Integer, CalibrationSet> calSets = new Hashtable<Integer, CalibrationSet>();
        int inx = 0;
        while (inx < selectedChannels.size()) {
            CalibrationChannel channel = (CalibrationChannel)selectedChannels.elementAt(inx);
            Integer idKey = new Integer(channel.getInstrumentID());
            CalibrationSet set = (CalibrationSet)calSets.get(idKey);
            if (set == null) {
                calSets.put(idKey, new CalibrationSet(channel.getInfo()));
            } else {
                set.addChannel(channel.getInfo());
            }
            ++inx;
        }
        return calSets;
    }

    private int countAmplitudeExceedances(Hashtable calSets, double frequency, double amplitude) {
        int count = 0;
        Enumeration e = calSets.elements();
        while (e.hasMoreElements()) {
            CalibrationSet set = (CalibrationSet)e.nextElement();
            double maxAmp = set.getMaxVelocity(frequency);
            if (!(amplitude > maxAmp)) continue;
            ++count;
        }
        return count;
    }

    private int[] getChannelKeys(Vector selectedChannels) {
        int numChannels = selectedChannels.size();
        int[] channelKeys = new int[numChannels];
        int ix = 0;
        while (ix < numChannels) {
            CalibrationChannel channel = (CalibrationChannel)selectedChannels.elementAt(ix);
            channelKeys[ix] = channel.getKey();
            ++ix;
        }
        return channelKeys;
    }

    public void calibrate(double frequency, double amplitude, double duration) {
        Vector selectedChannels = this.getSelectedChannels();
        if (selectedChannels.size() < 1) {
            ErrorDisplay.display("No channels were selected!", "Calibration");
            return;
        }
        Hashtable calSets = this.buildCalSetTable(selectedChannels);
        int exceedances = this.countAmplitudeExceedances(calSets, frequency, amplitude);
        if (exceedances > 0) {
            WarningDialog wdb = new WarningDialog(this.parent);
            wdb.setTitle("Calibration - Warning");
            wdb.setText("The maximum possible signal amplitude", "has been exceeded on " + exceedances + " instruments", "and will be reset to the maximum level.");
            wdb.setVisible(true);
            if (!wdb.isOk()) {
                return;
            }
        }
        PasswordDialog pwDialog = new PasswordDialog(this.parent);
        pwDialog.setTitle("Enter calibration password");
        pwDialog.setText("An authorized password is required", "to perform remote calibration.");
        pwDialog.setVisible(true);
        if (!pwDialog.isOk()) {
            return;
        }
        String password = pwDialog.getPassword();
        int[] channelKeys = this.getChannelKeys(selectedChannels);
        boolean sent = this.parent.send(new CalibrationCommand(channelKeys, password, frequency, amplitude, duration));
        if (!sent) {
            ErrorDialog edb = new ErrorDialog((JDialog)this.parent, "Calibration send error");
            edb.setText("No connection to the NaqsServer host.", "Cannot send calibration message.", "", "Try again later.");
            edb.setVisible(true);
        }
    }

    private Vector buildSelectList(CalibrationChannel item, Vector candidates) {
        int permission = 0;
        Vector<CalibrationChannel> additions = new Vector<CalibrationChannel>();
        additions.addElement(item);
        int inx = 0;
        while (inx < additions.size()) {
            CalibrationChannel target = (CalibrationChannel)additions.elementAt(inx);
            candidates.removeElement(target);
            Vector<CalibrationChannel> removals = new Vector<CalibrationChannel>();
            Enumeration e = candidates.elements();
            while (e.hasMoreElements()) {
                CalibrationChannel chan = (CalibrationChannel)e.nextElement();
                if (!target.compels(chan)) continue;
                if (permission != 2) {
                    permission = this.getSelectPermission(target, chan);
                }
                if (permission == 0) {
                    return new Vector();
                }
                removals.addElement(chan);
                additions.addElement(chan);
            }
            e = removals.elements();
            while (e.hasMoreElements()) {
                candidates.removeElement(e.nextElement());
            }
            ++inx;
        }
        return additions;
    }

    private boolean areParamsCompatible(Vector additions, Vector allSelected) {
        int ix = 0;
        while (ix < additions.size()) {
            CalibrationChannel target = (CalibrationChannel)additions.elementAt(ix);
            Enumeration e = allSelected.elements();
            while (e.hasMoreElements()) {
                CalibrationChannel chan = (CalibrationChannel)e.nextElement();
                if (target.hasCompatibleParams(chan)) continue;
                String message = "Cannot select calibration channel(s)\nChannel " + target.getChannelName() + "and channel " + chan.getChannelName() + "\n" + "have incompatible calibration parameters.";
                ErrorDisplay.display(message, "Invalid selection");
                return false;
            }
            ++ix;
        }
        return true;
    }

    private Vector addVectors(Vector first, Vector second) {
        Vector combined = (Vector)first.clone();
        int inx = 0;
        while (inx < second.size()) {
            combined.addElement(second.elementAt(inx));
            ++inx;
        }
        return combined;
    }

    private void rescale(Vector allSelected) {
        CalibrationSet set = new CalibrationSet();
        int ix = 0;
        while (ix < allSelected.size()) {
            CalibrationChannel channel = (CalibrationChannel)allSelected.elementAt(ix);
            if (channel.isSelected()) {
                set.addChannel(channel.getInfo());
            }
            ++ix;
        }
        double scale = set.getMaxVelocity(1.0);
        int ix2 = 0;
        while (ix2 < allSelected.size()) {
            Object obj = allSelected.elementAt(ix2);
            if (obj instanceof CalibrationTableRow) {
                CalibrationTableRow row = (CalibrationTableRow)obj;
                row.setScale(scale);
                this.channels.entryUpdated(row);
            }
            ++ix2;
        }
    }

    private void select(CalibrationChannel item) {
        Vector allSelected;
        Vector candidates = this.getInstrumentSubset(item.getInstrumentID());
        Vector preSelected = this.getSelectedSubset(candidates);
        Vector additions = this.buildSelectList(item, candidates = this.getUnselectedSubset(candidates));
        boolean canAdd = this.areParamsCompatible(additions, allSelected = this.addVectors(preSelected, additions));
        if (canAdd) {
            this.setSelected(additions, true);
            this.rescale(allSelected);
        }
    }

    private Vector buildDeselectList(CalibrationChannel item, Vector candidates) {
        int permission = 0;
        Vector<CalibrationChannel> deletions = new Vector<CalibrationChannel>();
        deletions.addElement(item);
        candidates.removeElement(item);
        int inx = 0;
        while (inx < deletions.size()) {
            CalibrationChannel target = (CalibrationChannel)deletions.elementAt(inx);
            candidates.removeElement(target);
            Vector<CalibrationChannel> removals = new Vector<CalibrationChannel>();
            Enumeration e = candidates.elements();
            while (e.hasMoreElements()) {
                CalibrationChannel chan = (CalibrationChannel)e.nextElement();
                if (!chan.compels(target)) continue;
                if (permission != 2) {
                    permission = this.getDeselectPermission(target, chan);
                }
                if (permission == 0) {
                    return new Vector();
                }
                removals.addElement(chan);
                deletions.addElement(chan);
            }
            e = removals.elements();
            while (e.hasMoreElements()) {
                candidates.removeElement(e.nextElement());
            }
            ++inx;
        }
        return deletions;
    }

    private void deselect(CalibrationChannel item) {
        Vector candidates = this.getInstrumentSubset(item.getInstrumentID());
        Vector deletions = this.buildDeselectList(item, candidates = this.getSelectedSubset(candidates));
        if (deletions.size() > 0) {
            this.setSelected(deletions, false);
            this.rescale(deletions);
            this.rescale(candidates);
        }
    }
}

