/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.SimpleTableCellRenderer;
import ca.nanometrics.uitools.table.TableRow;
import javax.swing.table.TableCellRenderer;

public class CalibrationTableRow
extends CalibrationChannel
implements ChannelRow,
TableRow {
    protected static final int CHANNEL_NAME = 0;
    protected static final int SELECTOR = 1;
    protected static final int INSTRUMENT = 2;
    protected static final int SENSOR = 3;
    protected static final int CHANNEL_NUM = 4;
    protected static final int ENABLE = 5;
    protected static final int RELAY = 6;
    protected static final int UNITS = 7;
    protected static final int RESISTANCE = 8;
    protected static final int COIL_CONST = 9;
    protected static final int MAX_VEL = 10;
    protected static final int COLUMN_COUNT = 11;
    private SelectionAgent selector = null;
    private String channelName;
    private Boolean objSelected;
    private String instrument;
    private String sensorName;
    private Integer channelNumber;
    private Integer calEnable;
    private Integer calRelay;
    private String calUnits;
    private Double coilResistance;
    private Double coilConstant;
    private Double maxVelocity;
    private double frequency = 1.0;
    private double scale = 0.0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CalibrationTableRow(CalibrationInfo info, SelectionAgent agent) {
        super(info);
        this.selector = agent;
        this.refresh();
    }

    public CalibrationTableRow(int key, String name) {
        super(new CalibrationInfo(key, name, 0, 1.0, 0, 0, "Volts", 1.0, 1.0, "sensor", 1));
        this.selector = null;
        this.refresh();
    }

    public void refresh() {
        this.channelName = this.getChannelName();
        this.sensorName = this.getSensorName();
        this.instrument = this.getInstrumentName();
        this.channelNumber = new Integer(this.getChannelNumber());
        this.calEnable = new Integer(this.getCalEnable());
        this.calRelay = new Integer(this.getCalRelay());
        this.calUnits = this.getCalUnits() == 0 ? "Amps" : "Volts";
        this.coilResistance = new Double(this.getCoilResistance());
        this.coilConstant = new Double(this.getCoilConstant());
        this.updateMaxVelocity();
        this.objSelected = new Boolean(this.isSelected());
    }

    public void setFrequency(double newFreq) {
        this.frequency = newFreq;
        this.updateMaxVelocity();
    }

    public void setScale(double newScale) {
        this.scale = newScale;
        this.updateMaxVelocity();
    }

    private void updateMaxVelocity() {
        this.maxVelocity = this.frequency == 0.0 ? new Double(0.0) : new Double(this.scale / this.frequency);
    }

    public void setSelected(boolean ifSelected) {
        super.setSelected(ifSelected);
        this.objSelected = new Boolean(this.isSelected());
    }

    public String getName() {
        return this.channelName;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public int getColumnCount() {
        return 11;
    }

    public void setValueAt(Object value, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                if (!this.isSelectable() || !(value instanceof Boolean) || this.selector == null) break;
                this.selector.setSelected(this, (Boolean)value);
            }
        }
    }

    public boolean isCellEditable(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NmxHelp.getFieldName("scal.channelname");
            }
            case 1: {
                return NmxHelp.getFieldName("scal.selected");
            }
            case 2: {
                return NmxHelp.getFieldName("instrument");
            }
            case 3: {
                return NmxHelp.getFieldName("scal.sensor");
            }
            case 4: {
                return NmxHelp.getFieldName("scal.channel");
            }
            case 5: {
                return NmxHelp.getFieldName("scal.enable");
            }
            case 6: {
                return NmxHelp.getFieldName("scal.relay");
            }
            case 7: {
                return NmxHelp.getFieldName("scal.units");
            }
            case 8: {
                return NmxHelp.getFieldName("scal.resistance");
            }
            case 9: {
                return NmxHelp.getFieldName("scal.coilconstant");
            }
            case 10: {
                return NmxHelp.getFieldName("scal.maxamplitude");
            }
        }
        return "";
    }

    public boolean isTaurus() {
        return ChannelKey.getModelOf(this.getKey()) == 11;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 8: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 9: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 10: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new SimpleTableCellRenderer();
            }
            case 1: {
                return null;
            }
            case 2: {
                return new SimpleTableCellRenderer();
            }
            case 3: {
                return new SimpleTableCellRenderer();
            }
            case 4: {
                return new SimpleTableCellRenderer();
            }
            case 5: {
                return new SimpleTableCellRenderer();
            }
            case 6: {
                return new SimpleTableCellRenderer();
            }
            case 7: {
                return new SimpleTableCellRenderer();
            }
            case 8: {
                return new FloatTableCellRenderer(2);
            }
            case 9: {
                return new FloatTableCellRenderer(3);
            }
            case 10: {
                return new FloatTableCellRenderer(2);
            }
        }
        return null;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.channelName;
            }
            case 1: {
                return this.objSelected;
            }
            case 2: {
                return this.instrument;
            }
            case 3: {
                return this.sensorName;
            }
            case 4: {
                return this.channelNumber;
            }
            case 5: {
                return this.calEnable;
            }
            case 6: {
                return this.calRelay;
            }
            case 7: {
                return this.calUnits;
            }
            case 8: {
                return this.coilResistance;
            }
            case 9: {
                return this.coilConstant;
            }
            case 10: {
                return this.maxVelocity;
            }
        }
        return null;
    }

    public int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 80;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 80;
            }
            case 4: {
                return 40;
            }
            case 5: {
                return 40;
            }
            case 6: {
                return 40;
            }
            case 7: {
                return 40;
            }
            case 8: {
                return 60;
            }
            case 9: {
                return 80;
            }
            case 10: {
                return 80;
            }
        }
        return 80;
    }
}

