/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.CalibrationResult;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.RowTable;
import ca.nanometrics.uitools.table.TableSorter;
import ca.nanometrics.uitools.table.VectorTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CalibrationViewer
extends ViewerController {
    RowTable rowTable = new RowTable();
    Vector rows = new Vector();
    VectorTableModel calTable = new VectorTableModel();
    CalibrationAgent calibrator = new CalibrationAgent(this, this.calTable);
    JTable table;
    TableSorter sorter;
    RowSelector selector;
    private RowSelectorSettings rowSettings = new RowSelectorSettings();
    private CalSignalSettings signalSettings = new CalSignalSettings();
    protected JButton settingsButton;
    protected JButton selectorButton;
    protected JButton calibrateButton;
    private JLabel freqLabel;
    private JLabel ampLabel;
    private JLabel durLabel;
    private CalibrationTableRow prototype;

    public CalibrationViewer(Frame frame) {
        super(frame);
        String str = NmxHelp.getFieldName("scal.title");
        if (str == null || str.trim().length() == 0) {
            str = "Sensor Calibration";
        }
        this.setTitle(str);
        this.init();
    }

    protected void init() {
        this.initializeTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel controlPanel = this.createControlPanel();
        JPanel fullPanel = new JPanel();
        fullPanel.setLayout(new BorderLayout());
        fullPanel.add((Component)scrollPane, "Center");
        fullPanel.add((Component)controlPanel, "South");
        this.setContentPane(fullPanel);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.settingsButton.addActionListener(buttonHandler);
        this.selectorButton.addActionListener(buttonHandler);
        this.calibrateButton.addActionListener(buttonHandler);
        this.showSettings();
    }

    private void initializeTable() {
        this.prototype = new CalibrationTableRow(0, "STN");
        this.calTable.setPrototype(this.prototype);
        this.selector = new RowSelector(this.calTable);
        this.selector.selectAllRows();
        this.sorter = new TableSorter(this.selector);
        this.table = new JTable(this.sorter);
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        int numColumns = this.calTable.getColumnCount();
        int col = 0;
        while (col < numColumns) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            int width = this.prototype.getPreferredWidth(col);
            column.setMinWidth(width);
            column.setMaxWidth(width * 2);
            TableCellRenderer tcr = this.prototype.getColumnRenderer(col);
            if (tcr != null) {
                column.setCellRenderer(tcr);
            }
            ++col;
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(900, 120));
    }

    protected JPanel createControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(1, 6));
        this.freqLabel = new JLabel("Frequency: Hz");
        controlPanel.add(this.freqLabel);
        this.ampLabel = new JLabel("Amplitude: 1.0 um/s");
        controlPanel.add(this.ampLabel);
        this.durLabel = new JLabel(" Duration: 1.0 sec");
        controlPanel.add(this.durLabel);
        this.settingsButton = new JButton("Signal Settings");
        this.settingsButton.setMnemonic('T');
        controlPanel.add(this.settingsButton);
        this.selectorButton = new JButton("Select Channels");
        this.selectorButton.setMnemonic('S');
        controlPanel.add(this.selectorButton);
        this.calibrateButton = new JButton("Calibrate");
        this.calibrateButton.setMnemonic('C');
        controlPanel.add(this.calibrateButton);
        return controlPanel;
    }

    private void showSettings() {
        this.freqLabel.setText(" Frequency: " + this.getSignalSettings().getFrequency() + " Hz ");
        this.ampLabel.setText(" Amplitude: " + this.getSignalSettings().getAmplitude() + " um/s ");
        this.durLabel.setText(" Duration: " + this.getSignalSettings().getDuration() + " sec ");
    }

    protected void showSettingsDialog() {
        CalSettingsDialog csd = new CalSettingsDialog(this);
        csd.applySettings(this.getSignalSettings());
        csd.setVisible(true);
        this.updateTableFrequency();
        this.showSettings();
    }

    private void updateTableFrequency() {
        double frequency = this.getSignalSettings().getFrequency();
        Enumeration e = this.rowTable.elements();
        while (e.hasMoreElements()) {
            CalibrationTableRow row = (CalibrationTableRow)e.nextElement();
            row.setFrequency(frequency);
        }
        this.calTable.fireTableDataChanged();
    }

    protected void selectChannels() {
        SubscriptionDialog subd = new SubscriptionDialog(this);
        subd.setTitle("Select Channel(s) to Display");
        subd.setChannels(this.calTable, this.selector);
        subd.setVisible(true);
        if (subd.isOkSelected()) {
            Vector rows = subd.getSelectedChannels();
            this.getRowSettings().setRowLabels(rows);
            this.selector.setSelectedRows(rows);
        }
    }

    protected void calibrateNow() {
        double frequency = this.getSignalSettings().getFrequency();
        double amplitude = this.getSignalSettings().getAmplitude();
        double duration = this.getSignalSettings().getDuration();
        this.calibrator.calibrate(frequency, amplitude, duration);
    }

    public void initCalTable(CalibrationInfoTable infoTable) {
        this.rowTable.clear();
        this.rows.removeAllElements();
        Enumeration e = infoTable.elements();
        while (e.hasMoreElements()) {
            CalibrationInfo info = (CalibrationInfo)e.nextElement();
            int key = info.getKey();
            CalibrationTableRow entry = new CalibrationTableRow(info, this.calibrator);
            if (entry.isTaurus()) continue;
            this.rowTable.put(key, entry);
            this.rows.addElement(entry);
        }
        this.calTable.setRows(this.rows);
        this.updateTableFrequency();
    }

    public void put(Packable pkt) {
        if (pkt instanceof CalibrationInfoTable) {
            this.initCalTable((CalibrationInfoTable)pkt);
        } else if (pkt instanceof CalibrationResult) {
            CalibrationResult result = (CalibrationResult)pkt;
            this.getToolkit().beep();
            JOptionPane.showMessageDialog(this, "Calibration result from NaqsServer:\n\n" + result.getMessage(), "Calibration Result", 1);
        } else {
            super.put(pkt);
        }
    }

    private void applyRowSettings(RowSelectorSettings stgs) {
        if (stgs != null) {
            this.rowSettings = stgs;
        }
        Vector rows = this.getRowSettings().getRowLabels();
        this.selector.setSelectedRows(rows);
    }

    private RowSelectorSettings getRowSettings() {
        return this.rowSettings;
    }

    private void applySignalSettings(CalSignalSettings stgs) {
        if (stgs != null) {
            this.signalSettings = stgs;
        }
        this.showSettings();
        this.updateTableFrequency();
    }

    private CalSignalSettings getSignalSettings() {
        return this.signalSettings;
    }

    public void applySettings(NaqsViewSettings newSettings) {
        CalibrationViewSettings settings = newSettings.getCalibrationSettings();
        this.applyRowSettings(settings.getSelectorSettings());
        this.applySignalSettings(settings.getSignalSettings());
    }

    public void updateSettings(NaqsViewSettings naqsSettings) {
        CalibrationViewSettings calSettings = naqsSettings.getCalibrationSettings();
        RowSelectorSettings rowSelectorSettings = calSettings.getSelectorSettings();
        rowSelectorSettings.setRowLabels(this.selector.getSelectedRows());
        CalSignalSettings signalStgs = calSettings.getSignalSettings();
        signalStgs.setAmplitude(this.getSignalSettings().getAmplitude());
        signalStgs.setFrequency(this.getSignalSettings().getFrequency());
        signalStgs.setDuration(this.getSignalSettings().getDuration());
    }

    public void updateProperties() {
        String str = NmxHelp.getFieldName("scal.title");
        if (str == null || str.trim().length() == 0) {
            str = "Sensor Calibration";
        }
        this.setTitle(str);
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setHeaderValue(this.prototype.getColumnName(i));
            ++i;
        }
        this.repaint();
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == CalibrationViewer.this.settingsButton) {
                CalibrationViewer.this.showSettingsDialog();
            } else if (object == CalibrationViewer.this.selectorButton) {
                CalibrationViewer.this.selectChannels();
            } else if (object == CalibrationViewer.this.calibrateButton) {
                CalibrationViewer.this.calibrateNow();
            }
        }
    }
}

