/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ControlBar
extends JPanel {
    private static final String BLANKS = "        ";
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbc;

    public ControlBar() {
        this.setLayout(this.layout);
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.gbc.anchor = 10;
        this.gbc.fill = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
    }

    public void addControl(JComponent control, boolean canStretch) {
        if (control == null) {
            throw new IllegalArgumentException("null component in ControlBar");
        }
        this.gbc.weightx = canStretch ? 1.0 : 0.0;
        this.layout.setConstraints(control, this.gbc);
        this.add(control);
        ++this.gbc.gridx;
    }

    public void addLabelledControl(String text, JComponent control, boolean canStretch) {
        this.addControl(new LabelledComponent(text, control), canStretch);
    }

    public JLabel addLabel(String text, boolean canStretch) {
        JLabel label = new JLabel(text);
        label.setBorder(new BevelBorder(1));
        this.addControl(label, canStretch);
        return label;
    }

    public JLabel addStretcher() {
        return this.addLabel(BLANKS, true);
    }
}

