/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.util.InvalidInputException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.table.TableCellRenderer;

public class CustomSohTableRow
extends AbstractSohTableRow {
    private SohDataSource dataSource;
    public static final int STATION_NAME = 0;
    public static final int INSTRUMENT = 1;
    public static final int LAST_UPDATE = 2;
    private SohBundle bundle;
    private int[] bundleTypes;
    private ArrayList bundleIndexes;
    private ArrayList columns;
    private GradingThresholdTable gradingThresholds;
    private int port;
    private StationTableColumn stationColumn;
    private SimpleTableColumn instrumentColumn;
    private DateTableColumn dateTableColumn;
    private PortTableColumn portTableColumn;
    private ArrayList numberTableColumns = new ArrayList();
    private ArrayList stringTableColumns = new ArrayList();
    private ArrayList simpleTableColumns = new ArrayList();

    public CustomSohTableRow(int theKey, String theStation, SohBundle bdl, ArrayList colIndexes, int portNum) {
        super(theKey, theStation);
        this.bundle = bdl;
        this.bundleTypes = new int[1];
        this.bundleTypes[0] = this.bundle.getType();
        this.bundleIndexes = colIndexes;
        this.port = portNum;
        this.gradingThresholds = new GradingThresholdTable();
        this.initializeColumns();
    }

    public SohTableRow createTableRow(int key, String name) {
        CustomSohTableRow row = new CustomSohTableRow(key, name, this.getBundle(), this.getSelectedColumns(), this.getPort());
        row.setDataSource(this.getDataSource());
        row.setThresholds(this.getThresholds());
        return row;
    }

    private void setThresholds(GradingThresholdTable gtt) {
        this.gradingThresholds = gtt;
        Enumeration keys = gtt.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            GradingThresholds gt = gtt.get(key);
            int i = 0;
            while (i < this.columns.size()) {
                ViewTableColumn col = (ViewTableColumn)this.columns.get(i);
                DoubleNode node = col.getDoubleNode();
                if (node != null && node.getReadingName().equalsIgnoreCase(key)) {
                    node.setThresholds(gt);
                }
                ++i;
            }
        }
    }

    private GradingThresholdTable getThresholds() {
        return this.gradingThresholds;
    }

    private DateTableColumn getDateColuumn(int currCol) {
        if (this.dateTableColumn == null) {
            this.dateTableColumn = new DateTableColumn(currCol, 120, NmxHelp.getFieldName("lastupdate"), this.getDateNode());
        } else {
            this.dateTableColumn.setColumnIndex(currCol);
        }
        return this.dateTableColumn;
    }

    private PortTableColumn getPortTableColumn(int currCol, int index) {
        if (this.portTableColumn == null) {
            this.portTableColumn = new PortTableColumn(currCol, 30, this.bundle.getReadingHeaderByIndex(index), new Integer(this.bundle.getPort()));
        } else {
            this.portTableColumn.setColumnIndex(currCol);
        }
        return this.portTableColumn;
    }

    private void initializeColumns() {
        ArrayList<SimpleTableColumn> newColumns = new ArrayList<SimpleTableColumn>();
        this.stationColumn = new StationTableColumn(0, 80, NmxHelp.getFieldName("station"), new StationNode(this.getStationName(), this.getChannelName(), this.getInstrument()));
        newColumns.add(this.stationColumn);
        this.instrumentColumn = new SimpleTableColumn(1, 60, NmxHelp.getFieldName("instrument"), this.getInstrument());
        newColumns.add(this.instrumentColumn);
        DateTableColumn dateCol = this.getDateColuumn(2);
        newColumns.add(dateCol);
        int currCol = 3;
        ArrayList<DoubleNode> doubleNodes = new ArrayList<DoubleNode>();
        int i = 0;
        while (i < this.bundleIndexes.size()) {
            int index = (Integer)this.bundleIndexes.get(i);
            String dataType = this.bundle.getDataTypeByIndex(index);
            if (dataType.equals("integer") || dataType.equals("double") || dataType.equals("long")) {
                if (this.bundle.hasPort() && this.bundle.getReadingHeaderByIndex(index).equalsIgnoreCase("Port")) {
                    PortTableColumn portCol = this.getPortTableColumn(currCol, index);
                    ++currCol;
                    newColumns.add(portCol);
                } else {
                    NumberTableColumn numCol = this.getNumberTableColumn(currCol, index, this.bundle.isColorColumn(index));
                    doubleNodes.add(numCol.getDoubleNode());
                    ++currCol;
                    newColumns.add(numCol);
                }
            } else if (dataType.equals("string")) {
                StringTableColumn sCol = this.getStringTableColumn(currCol, index);
                ++currCol;
                newColumns.add(sCol);
            } else if (!dataType.equals("time")) {
                SimpleTableColumn simCol = this.getSimpleTableColumn(currCol, index);
                ++currCol;
                newColumns.add(simCol);
            }
            ++i;
        }
        Iterator iter = doubleNodes.iterator();
        while (iter.hasNext()) {
            DoubleNode node = (DoubleNode)iter.next();
            this.stationColumn.addNode(node);
        }
        this.columns = newColumns;
    }

    private SimpleTableColumn getSimpleTableColumn(int currCol, int index) {
        Iterator iter = this.simpleTableColumns.iterator();
        while (iter.hasNext()) {
            SimpleTableColumn col = (SimpleTableColumn)iter.next();
            if (!col.getColumnName().equalsIgnoreCase(this.bundle.getReadingHeaderByIndex(index))) continue;
            col.setColumnIndex(currCol);
            return col;
        }
        SimpleTableColumn simpleCol = new SimpleTableColumn(currCol, 60, this.bundle.getReadingHeaderByIndex(index), "");
        this.simpleTableColumns.add(simpleCol);
        return simpleCol;
    }

    private NumberTableColumn getNumberTableColumn(int currCol, int index, boolean color) {
        Iterator iter = this.numberTableColumns.iterator();
        while (iter.hasNext()) {
            NumberTableColumn col = (NumberTableColumn)iter.next();
            if (!col.getColumnName().equalsIgnoreCase(this.bundle.getReadingHeaderByIndex(index))) continue;
            col.setColumnIndex(currCol);
            return col;
        }
        DoubleNode node = null;
        if (color) {
            node = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), this.bundle.getReadingHeaderByIndex(index), this.bundle.getType(), this.bundleTypes, "%." + this.bundle.getPrecisionByIndex(index) + "f", this.getDataSource(), this.bundle.getPrecisionByIndex(index));
            GradingThresholds gt = new GradingThresholds(0.0, 10.0, 20.0, 30.0);
            node.setThresholds(gt);
            this.gradingThresholds.add(node.getReadingName(), gt);
        } else {
            node = new DoubleNode(this.getStationName(), this.getChannelName(), this.getInstrument(), this.bundle.getReadingHeaderByIndex(index), this.bundle.getType(), this.bundleTypes, "%." + this.bundle.getPrecisionByIndex(index) + "f", this.getDataSource(), this.bundle.getPrecisionByIndex(index));
        }
        NumberTableColumn numCol = new NumberTableColumn(currCol, 60, this.bundle.getReadingHeaderByIndex(index), node);
        this.numberTableColumns.add(numCol);
        return numCol;
    }

    private StringTableColumn getStringTableColumn(int currCol, int index) {
        Iterator iter = this.stringTableColumns.iterator();
        while (iter.hasNext()) {
            StringTableColumn col = (StringTableColumn)iter.next();
            if (!col.getColumnName().equalsIgnoreCase(this.bundle.getReadingHeaderByIndex(index))) continue;
            col.setColumnIndex(currCol);
            return col;
        }
        StringNode node = new StringNode(this.getStationName(), this.getChannelName(), this.getInstrument(), this.bundle.getType());
        StringTableColumn sCol = new StringTableColumn(currCol, 60, this.bundle.getReadingHeaderByIndex(index), node);
        this.stringTableColumns.add(sCol);
        return sCol;
    }

    private int getPort() {
        return this.port;
    }

    public SohViewSettings getViewSettings() {
        return new CustomViewSettings(this.getBundle().getType(), this.getSelectedColumns(), this.getPort());
    }

    public SohBundle getBundle() {
        return this.bundle;
    }

    public ArrayList getSelectedColumns() {
        return this.bundleIndexes;
    }

    private void setColumnIndexes(ArrayList newIndexes) {
        this.bundleIndexes = newIndexes;
    }

    private ViewTableColumn getColumn(int col) {
        if (col < this.columns.size()) {
            return (ViewTableColumn)this.columns.get(col);
        }
        return new SimpleTableColumn(-1, -1, "", "");
    }

    public void applyThresholds(GradingThresholdTable gtt) {
        Enumeration keys = gtt.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            GradingThresholds gt = gtt.get(key);
            int i = 0;
            while (i < this.columns.size()) {
                ViewTableColumn col = (ViewTableColumn)this.columns.get(i);
                DoubleNode node = col.getDoubleNode();
                if (node != null && node.getReadingName().equalsIgnoreCase(key)) {
                    node.getThresholds().setThresholds(gt);
                }
                ++i;
            }
        }
    }

    public String getTableName() {
        if (this.bundle.hasPort() && this.getPort() >= 0) {
            return String.valueOf(this.bundle.getName()) + "_Port" + this.getPort();
        }
        return this.bundle.getName();
    }

    public boolean acceptKey(int key) {
        return ChannelKey.getTypeOf(key) == 2;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int columnIndex) {
        return this.getColumn(columnIndex).getColumnName();
    }

    public Class getColumnClass(int columnIndex) {
        return this.getColumn(columnIndex).getColumnClass();
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return this.getColumn(columnIndex).getColumnRenderer();
    }

    public Object getValueAt(int columnIndex) {
        if (columnIndex < 0) {
            return "";
        }
        ViewTableColumn col = this.getColumn(columnIndex);
        Object obj = col.getValueAt();
        return obj;
    }

    public int getPreferredWidth(int columnIndex) {
        return this.getColumn(columnIndex).getColumnWidth();
    }

    public void setValueAt(Object aValue, int columnIndex) {
    }

    public boolean isCellEditable(int columnIndex) {
        return false;
    }

    public void setDataSource(SohDataSource source) {
        this.dataSource = source;
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            ViewTableColumn tableColumn = (ViewTableColumn)iter.next();
            tableColumn.updateDataSource(this.dataSource);
        }
    }

    public SohDataSource getDataSource() {
        return this.dataSource;
    }

    public void process(SohBundle inBundle) throws InvalidInputException {
        if (inBundle.getType() == this.bundle.getType()) {
            SohBundle newBdl = SohBundleFactory.createBundle(inBundle.getBytes(), 0);
            newBdl.setPort(this.getPort());
            if (this.getPort() >= 0 && newBdl.getPort() == this.getPort() || !newBdl.hasPort()) {
                int i = 0;
                while (i < this.columns.size()) {
                    ViewTableColumn col = this.getColumn(i);
                    col.updateValues(newBdl);
                    ++i;
                }
                this.setChanged();
                this.notifyObservers();
            }
        }
    }

    public boolean hasPopup(int col) {
        if (col < 0) {
            return false;
        }
        return this.getColumn(col).hasPopup();
    }

    public void resetNode(int col) {
        this.getColumn(col).resetNode();
    }

    public void resetAll() {
        int i = 0;
        while (i < this.columns.size()) {
            this.resetNode(i);
            ++i;
        }
    }

    public DoubleNode getDoubleNode(int col) {
        return this.getColumn(col).getDoubleNode();
    }

    private boolean columnIndexesEqual(SohTableRow r) {
        if (!(r instanceof CustomSohTableRow)) {
            return false;
        }
        CustomSohTableRow row = (CustomSohTableRow)r;
        ArrayList otherIndexes = row.getSelectedColumns();
        if (otherIndexes.size() != this.getSelectedColumns().size()) {
            return false;
        }
        int i = 0;
        while (i < otherIndexes.size()) {
            Integer otherIndex = (Integer)otherIndexes.get(i);
            Integer thisIndex = (Integer)this.getSelectedColumns().get(i);
            if (otherIndex.intValue() != thisIndex.intValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void resetParameters(SohTableRow row) {
        if (!(row instanceof CustomSohTableRow)) {
            return;
        }
        CustomSohTableRow other = (CustomSohTableRow)row;
        if (this.columnIndexesEqual(other)) {
            return;
        }
        this.bundleIndexes = other.getSelectedColumns();
        this.initializeColumns();
    }

    public boolean equalsExceptSelectedColumns(SohTableRow row) {
        return this.commonEqualsTests(row);
    }

    private boolean commonEqualsTests(SohTableRow row) {
        if (!(row instanceof CustomSohTableRow)) {
            return false;
        }
        CustomSohTableRow cRow = (CustomSohTableRow)row;
        if (this.getBundle().getType() != cRow.getBundle().getType()) {
            return false;
        }
        return this.getPort() == cRow.getPort();
    }

    public boolean equals(SohTableRow row) {
        if (!this.commonEqualsTests(row)) {
            return false;
        }
        return this.columnIndexesEqual(row);
    }

    private void updateStationColumn(ArrayList doubleNodes) {
        this.stationColumn.clearNodes();
        Iterator iter = doubleNodes.iterator();
        while (iter.hasNext()) {
            DoubleNode node = (DoubleNode)iter.next();
            this.stationColumn.addNode(node);
        }
    }

    public boolean selectedColumnsEqual(CustomSohTableRow row) {
        if (this.getColumnCount() != row.getColumnCount()) {
            return false;
        }
        return this.columnIndexesEqual(row);
    }

    private ArrayList createNewColumns(ArrayList newIndexes) {
        ArrayList<SimpleTableColumn> newColumns = new ArrayList<SimpleTableColumn>();
        int currCol = 3;
        ArrayList<DoubleNode> doubleNodes = new ArrayList<DoubleNode>();
        int i = 0;
        while (i < newIndexes.size()) {
            int index = (Integer)newIndexes.get(i);
            String dataType = this.bundle.getDataTypeByIndex(index);
            if (dataType.equals("formattedTime")) {
                DateTableColumn dateCol = this.getDateColuumn(currCol);
                ++currCol;
                this.getDateNode().setBundleType(this.bundle.getType());
                newColumns.add(dateCol);
            } else if (dataType.equals("integer") || dataType.equals("double") || dataType.equals("long")) {
                if (this.bundle.hasPort() && this.bundle.getReadingHeaderByIndex(index).equalsIgnoreCase("Port")) {
                    PortTableColumn portCol = this.getPortTableColumn(currCol, index);
                    ++currCol;
                    newColumns.add(portCol);
                } else {
                    NumberTableColumn numCol = this.getNumberTableColumn(currCol, index, this.bundle.isColorColumn(index));
                    doubleNodes.add(numCol.getDoubleNode());
                    ++currCol;
                    newColumns.add(numCol);
                }
            } else if (!dataType.equals("time")) {
                SimpleTableColumn simCol = this.getSimpleTableColumn(currCol, index);
                newColumns.add(simCol);
            }
            ++i;
        }
        this.updateStationColumn(doubleNodes);
        return newColumns;
    }

    private ArrayList createUpdatedColumns(ArrayList newColumns) {
        Object obj;
        ArrayList updatedColumns = new ArrayList();
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (obj != this.stationColumn && obj != this.instrumentColumn && obj != this.dateTableColumn && !newColumns.contains(obj)) continue;
            updatedColumns.add(obj);
        }
        iter = newColumns.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            if (updatedColumns.contains(obj)) continue;
            updatedColumns.add(obj);
        }
        ArrayList sortedCols = this.sortColumnsByBundleIndex(updatedColumns);
        iter = sortedCols.iterator();
        StationTableColumn staCol = null;
        ArrayList<DoubleNode> nodeList = new ArrayList<DoubleNode>();
        while (iter.hasNext()) {
            Object obj2 = iter.next();
            if (obj2 instanceof StationTableColumn) {
                staCol = (StationTableColumn)obj2;
                continue;
            }
            ViewTableColumn tableCol = (ViewTableColumn)obj2;
            DoubleNode node = tableCol.getDoubleNode();
            if (node == null) continue;
            nodeList.add(node);
        }
        staCol.clearNodes();
        iter = nodeList.iterator();
        if (staCol != null) {
            while (iter.hasNext()) {
                staCol.addNode((DoubleNode)iter.next());
            }
        }
        return sortedCols;
    }

    private ArrayList sortColumnsByBundleIndex(ArrayList cols) {
        SimpleTableColumn[] retCols = new SimpleTableColumn[cols.size()];
        Iterator iter = cols.iterator();
        while (iter.hasNext()) {
            SimpleTableColumn col;
            retCols[col.getColumnIndex()] = col = (SimpleTableColumn)iter.next();
        }
        ArrayList<SimpleTableColumn> sortedCols = new ArrayList<SimpleTableColumn>();
        int i = 0;
        while (i < retCols.length) {
            sortedCols.add(retCols[i]);
            ++i;
        }
        return sortedCols;
    }

    public void updateRow(SohTableRow row) {
        ArrayList updatedColumns;
        if (this.equals(row)) {
            return;
        }
        if (!(row instanceof CustomSohTableRow)) {
            return;
        }
        CustomSohTableRow cRow = (CustomSohTableRow)row;
        ArrayList newIndexes = cRow.getSelectedColumns();
        ArrayList newColumns = this.createNewColumns(newIndexes);
        this.columns = updatedColumns = this.createUpdatedColumns(newColumns);
        this.setColumnIndexes(newIndexes);
    }
}

