/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.KeyedChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class CustomViewSettings
extends SohViewSettings {
    private int bundleType;
    private ArrayList selectedColumns;
    private int port;

    public CustomViewSettings(int type, ArrayList selectedCols, int portNum) {
        this.bundleType = type;
        this.selectedColumns = selectedCols;
        this.port = portNum;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CustomViewSettings) {
            CustomViewSettings other = (CustomViewSettings)obj;
            return this.getSelectorSettings().equals(other.getSelectorSettings()) && this.getColumnThresholds().equals(other.getColumnThresholds()) && this.getBundleType() == other.getBundleType() && this.selectedColumnsEqual(other.getSelectedColumns()) && this.getShowAllSelected() == other.getShowAllSelected() && this.getPort() == other.getPort();
        }
        return false;
    }

    private boolean selectedColumnsEqual(ArrayList cols) {
        if (cols.size() != this.getSelectedColumns().size()) {
            return false;
        }
        int i = 0;
        while (i < cols.size()) {
            if (((Integer)cols.get(i)).intValue() != ((Integer)this.getSelectedColumns().get(i)).intValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getBundleType() {
        return this.bundleType;
    }

    public ArrayList getSelectedColumns() {
        return this.selectedColumns;
    }

    public int getPort() {
        return this.port;
    }

    public void setThresholds(String key, double[] ths) {
        GradingThresholds gt = new GradingThresholds(ths[0], ths[1], ths[2], ths[3]);
        this.columnThresholds.add(key, gt);
    }

    public void setAllSelected(ChannelList list, SohTableRow prototype) {
        Vector<String> rows = new Vector<String>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            KeyedChannel kc = (KeyedChannel)e.nextElement();
            int key = kc.getKey();
            if (!prototype.acceptKey(key)) continue;
            String name = kc.getName();
            rows.addElement(name);
        }
        this.selectorSettings.setRowLabels(rows);
    }
}

