/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.uitools.NmxHelp;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class CustomViewer
extends StandardSohViewer {
    public CustomViewer(SohTableRow sampleRow, Frame frame) {
        super(sampleRow, frame);
        this.augmentButtonPanel();
        this.pack();
    }

    protected void adjustColumnSettings() {
        GradingThresholdTable gtt = this.getThresholdTable();
        String lastUpdateString = NmxHelp.getFieldName("lastupdate");
        int cols = 0;
        Enumeration keys = gtt.keys();
        while (keys.hasMoreElements()) {
            String str = (String)keys.nextElement();
            if (str.equalsIgnoreCase(lastUpdateString)) continue;
            ++cols;
            break;
        }
        if (cols == 0) {
            JOptionPane.showMessageDialog(this, "No Adjustable Columns");
            return;
        }
        ColumnSettingsDialog csd = new ColumnSettingsDialog((JDialog)this, gtt);
        csd.setTitle(String.valueOf(this.getTitle()) + " - set column color thresholds");
        csd.setVisible(true);
        if (csd.isOk()) {
            this.applyColumnSettings(gtt);
        }
    }

    private void augmentButtonPanel() {
        JButton button = new JButton("Edit Columns");
        button.addActionListener(new EditButtonAction());
        this.getButtonPanel().add(button);
    }

    protected void setPort(SohBundle bdl) {
        if (!bdl.hasPort()) {
            return;
        }
        int port = -1;
        try {
            String title = this.getTitle();
            Integer portInt = new Integer(title.substring(title.length() - 1));
            port = portInt;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bdl.setPort(port);
    }

    public class EditButtonAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            CustomSohTableRow prototype = (CustomSohTableRow)CustomViewer.this.getPrototype();
            ArrayList<SohBundle> list = new ArrayList<SohBundle>();
            SohBundle bdl = prototype.getBundle();
            CustomViewer.this.setPort(bdl);
            list.add(bdl);
            CustomViewDialog dlog = new CustomViewDialog(list, CustomViewer.this.getTitle(), prototype.getSelectedColumns());
            if (!dlog.getSuccess() && !dlog.cancelled()) {
                JOptionPane.showMessageDialog(CustomViewer.this, "Dialog Failed to Edit Custom Viewer.", "Dialog Failure", 2);
                return;
            }
            CustomSohTableRow row = new CustomSohTableRow(0, "STN", dlog.getSelectedBundle(), dlog.getSelectedColumns(), dlog.getPort());
            row.setDataSource(prototype.getDataSource());
            CustomViewer.this.updatePrototype(row);
        }
    }
}

