/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.uitools.table.NmxTable;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DoubleNode
extends NaqsNode {
    private double currentVal = 0.0;
    private double currentTime = 0.0;
    private double minVal = Double.POSITIVE_INFINITY;
    private double minValTime = 0.0;
    private double maxVal = Double.NEGATIVE_INFINITY;
    private double maxValTime = 0.0;
    private double initialTime = 0.0;
    private Format format;
    private NmxDateFormat dateFmt = new NmxDateFormat();
    private SohDataSource source;
    private int precision;
    private GradingThresholds thresholds;

    public DoubleNode(String stn, String chan, String instr, String label, int bdlType, int[] bdlTypes, String formatStr, SohDataSource src, int precision) {
        super(stn, chan, instr, label, bdlType, bdlTypes);
        this.format = new Format(formatStr);
        this.setDataSource(src);
        this.setPrecision(precision);
        this.thresholds = new GradingThresholds();
    }

    public void setDataSource(SohDataSource src) {
        this.source = src;
    }

    public void setPrecision(int p) {
        this.precision = p;
    }

    public void setThresholds(GradingThresholds gt) {
        this.thresholds = gt;
    }

    public void setUserName(String name) {
        this.source.setUserName(name);
    }

    public void setPassword(String pword) {
        this.source.setPassword(pword);
    }

    public void setHost(String host) {
        this.source.setHost(host);
    }

    public void setPort(int port) {
        this.source.setPort(port);
    }

    public void setCurrentValues(double val, double time) {
        if (time <= 0.0) {
            return;
        }
        if (this.initialTime == 0.0) {
            this.initialTime = time;
        }
        if (val < this.minVal) {
            this.minVal = val;
            this.minValTime = time;
        }
        if (val > this.maxVal) {
            this.maxVal = val;
            this.maxValTime = time;
        }
        this.currentVal = val;
        this.currentTime = time;
    }

    public int getPrecision() {
        return this.precision;
    }

    public GradingThresholds getThresholds() {
        if (this.thresholds == null) {
            this.thresholds = new GradingThresholds();
        }
        return this.thresholds;
    }

    public double getThreshold1() {
        return this.thresholds.getThreshold1();
    }

    public double getThreshold2() {
        return this.thresholds.getThreshold2();
    }

    public double getThreshold3() {
        return this.thresholds.getThreshold3();
    }

    public double getThreshold4() {
        return this.thresholds.getThreshold4();
    }

    public Format getFormat() {
        return this.format;
    }

    public double getCurrentValue() {
        return this.currentVal;
    }

    public double getMinValue() {
        return this.minVal;
    }

    public double getMaxValue() {
        return this.maxVal;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public String getCurentTimeValueText() {
        return this.dateFmt.format(this.getCurrentTime());
    }

    public String getMaxValueTimeText() {
        NmxDateFormat dateFmt = new NmxDateFormat();
        return dateFmt.format(this.getMaxValueTime());
    }

    public double getMaxValueTime() {
        return this.maxValTime;
    }

    public String getMinValueTimeText() {
        NmxDateFormat dateFmt = new NmxDateFormat();
        return dateFmt.format(this.getMinValueTime());
    }

    public double getMinValueTime() {
        return this.minValTime;
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getMinDataServerTime() throws IOException {
        return this.source.getMinDataServerTime(this);
    }

    public double getMaxDataServerTime() throws IOException {
        return this.source.getMaxDataServerTime(this);
    }

    public SohDataSource getDataSource() {
        return this.source;
    }

    public String getUserName() {
        return this.source.getUserName();
    }

    public String getPassword() {
        return this.source.getPassword();
    }

    public String getHost() {
        return this.source.getHost();
    }

    public int getPort() {
        return this.source.getPort();
    }

    public String toString() {
        if (this.format == null) {
            return Double.toString(this.currentVal);
        }
        return this.format.form(this.currentVal);
    }

    public void updateBundleType(int type) {
        String name;
        this.setBundleType(type);
        SohBundle bundle = SohBundleFactory.createBundle(type);
        int index = 2;
        ArrayList<String> list = new ArrayList<String>();
        while ((name = bundle.getReadingHeaderByIndex(index++)) != null && name.trim().length() > 0) {
            list.add(name);
        }
        Object[] possibleValues = new String[list.size()];
        int i = 0;
        while (i < possibleValues.length) {
            possibleValues[i] = (String)list.get(i);
            ++i;
        }
        Object selectedValue = JOptionPane.showInputDialog(null, "Choose data name", bundle.getName(), 1, null, possibleValues, possibleValues[0]);
        int i2 = 0;
        while (i2 < possibleValues.length) {
            if (((String)possibleValues[i2]).equalsIgnoreCase((String)selectedValue)) {
                index = i2 + 2;
                break;
            }
            ++i2;
        }
        this.setBundleType(type);
        this.setReadingName((String)selectedValue);
        this.setReadingDataIndex(index);
    }

    public void rightClick(JComponent showHere, int x, int y) {
        JPopupMenu popUp = new JPopupMenu();
        popUp.add(new ResetAction(showHere));
        if (showHere instanceof NmxTable) {
            popUp.addSeparator();
            if (this.getBundleType() == 0) {
                int[] types = this.getBundleTypes();
                if (types.length == 1) {
                    this.updateBundleType(types[0]);
                    return;
                }
                JPopupMenu popUpList = new JPopupMenu();
                int i = 0;
                while (i < types.length) {
                    popUpList.add(new BundleChoiceAction(showHere, types[i]));
                    ++i;
                }
                popUpList.show(showHere, x, y);
                return;
            }
            ArrayList viewers = HistoryViewer.viewers;
            if (viewers.size() == 0) {
                popUp.add(new HistoryAction("History", 0));
            } else {
                JMenu historyPopup = new JMenu("History");
                historyPopup.add(new HistoryAction("New History", 0));
                int i = 0;
                while (i < viewers.size()) {
                    HistoryViewer viewer = (HistoryViewer)viewers.get(i);
                    historyPopup.add(new HistoryAction(viewer.getTitle(), i + 1));
                    ++i;
                }
                popUp.add(historyPopup);
            }
        }
        popUp.add(new ReportAction());
        popUp.show(showHere, x, y);
    }

    private void dataChanged() {
        this.setChanged();
        this.notifyHierarchy();
    }

    public double[] getTimeSeries(double startTime, double endTime) {
        double[] vals = null;
        try {
            vals = this.source.getTimeSeries(this, startTime, endTime);
        }
        catch (IOException e) {
            String message = e.getMessage().indexOf("Connection refused") >= 0 ? "Data Retrieval Failed; Connection refused." : "Data Retrieval Failed; " + e.getMessage();
            ErrorDisplay.display(message, "Data Failure");
            vals = null;
        }
        return vals;
    }

    public double[] getDataSeries(double startTime, double endTime) {
        double[] vals = null;
        try {
            vals = this.source.getDataSeries(this, startTime, endTime);
        }
        catch (IOException e) {
            String message = e.getMessage().indexOf("Connection refused") >= 0 ? "Data Retrieval Failed; Connection refused." : "Data Retrieval Failed; " + e.getMessage();
            ErrorDisplay.display(message, "Data Failure");
            vals = null;
        }
        return vals;
    }

    private void joinHistoryViewer(int viewerIndex) {
        if (viewerIndex >= HistoryViewer.viewers.size()) {
            return;
        }
        HistoryViewer viewer = (HistoryViewer)HistoryViewer.viewers.get(viewerIndex);
        viewer.addNode(this);
    }

    protected void createHistoryViewer(int viewerIndex) {
        if (viewerIndex > 0) {
            this.joinHistoryViewer(viewerIndex - 1);
            return;
        }
        HistoryDurationDialog dlog = null;
        try {
            NaqsView.statusBar.push(0, "Retrieving Dialog");
            dlog = new HistoryDurationDialog(this);
            NaqsView.statusBar.pop(0);
        }
        catch (IOException e) {
            String message = "";
            String user = this.source.getUserName();
            user = user == null || user.length() == 0 ? "; No User Name.  " : " for user: " + user + ".  ";
            message = e.getMessage().indexOf("invalid logon") >= 0 ? "Failed to logon to DataServer" + user : (e.getMessage().indexOf("Connection refused") >= 0 ? "Failed to logon to DataServer" + user + " Error: Connection refused." : "History Duration Dialog Failure; Error: " + e.getMessage());
            Log.report(this, 1, 3, message);
            ErrorDisplay.display(message, "History Duration Dialog Failure");
            NaqsView.statusBar.pop();
            return;
        }
        catch (IllegalArgumentException iae) {
            Log.report(this, 1, 3, "Failed to connect to DataServer; Error: Port Number: " + this.source.getPort() + " out of range");
            ErrorDisplay.display("Failed to connect to DataServer; Error: Port Number: " + this.source.getPort() + " out of range", "DataServer Connection Problem");
            return;
        }
        if (dlog.getSuccess()) {
            double startTime = dlog.getStartTime();
            double endTime = startTime + dlog.getDuration();
            ArrayList<DoubleNode> list = new ArrayList<DoubleNode>();
            list.add(this);
            NaqsView.statusBar.push(0, "Creating History Viewer...");
            HistoryViewer hv = new HistoryViewer(list, startTime, endTime, HistoryViewer.viewers.size() + 1);
            if (!hv.success()) {
                return;
            }
            hv.setVisible(true);
            hv.toFront();
            NaqsView.statusBar.pop();
        }
    }

    public boolean saveData(double startTime, double endTime, String dirName) throws IOException {
        return this.source.saveData(this, startTime, endTime, dirName);
    }

    public void reset() {
        this.maxVal = this.currentVal;
        this.minVal = this.currentVal;
        this.maxValTime = this.currentTime;
        this.minValTime = this.currentTime;
        this.initialTime = this.currentTime;
        this.dataChanged();
    }

    public TableCellRenderer getCellRenderer() {
        return new FloatTableCellRenderer(this.getPrecision());
    }

    class BundleChoiceAction
    extends AbstractAction {
        private int type;

        public BundleChoiceAction(JComponent showHere, int _type) {
            super(String.valueOf(SohBundleFactory.createBundle(_type).getName()) + " *." + SohBundleFactory.createBundle(_type).getCsvName());
            this.type = _type;
        }

        public void actionPerformed(ActionEvent e) {
            DoubleNode.this.updateBundleType(this.type);
        }
    }

    class HistoryAction
    extends AbstractAction {
        int viewerIndex;

        public HistoryAction(String name, int i) {
            super(name);
            this.viewerIndex = 0;
            this.viewerIndex = i;
        }

        public void actionPerformed(ActionEvent e) {
            DoubleNode.this.createHistoryViewer(this.viewerIndex);
        }
    }

    class ReportAction
    extends AbstractAction {
        public ReportAction() {
            super("Report");
        }

        public void actionPerformed(ActionEvent e) {
            new HistoryReportDialog(DoubleNode.this);
        }
    }

    class ResetAction
    extends AbstractAction {
        private JTable table;

        public ResetAction(JComponent showHere) {
            super("Reset");
            this.table = null;
            if (showHere instanceof JTable) {
                this.table = (JTable)showHere;
            }
        }

        public void actionPerformed(ActionEvent e) {
            DoubleNode.this.reset();
            if (this.table != null) {
                this.table.repaint();
            }
        }
    }
}

