/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.Format;
import ca.nanometrics.util.Numeric;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class FloatTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private Format fmt;

    public FloatTableCellRenderer(int precision) {
        this.setOpaque(true);
        if (precision < 0) {
            precision = 0;
        }
        if (precision > 12) {
            precision = 12;
        }
        this.fmt = new Format("%." + precision + "f");
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(Color.black);
        if (isSelected) {
            this.setBackground(Color.lightGray);
        } else {
            this.setBackground(Color.white);
        }
        if (value == null) {
            this.setText("");
        } else if (value instanceof Number) {
            double dval = ((Number)value).doubleValue();
            this.setText(this.fmt.form(dval));
        } else if (value instanceof Numeric) {
            double dval = ((Numeric)value).doubleValue();
            this.setText(this.fmt.form(dval));
        } else {
            this.setText(value.toString());
        }
        return this;
    }
}

