/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.shapes.TriangleJPanel;
import ca.nanometrics.util.Format;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTable;

public class GradedFloatTableCellRenderer
extends GradedTableCellRenderer {
    private Format fmt;
    private TriangleJPanel upArrow;
    private TriangleJPanel downArrow;
    private JPanel arrowPanel;

    public GradedFloatTableCellRenderer(int precision, GradingThresholds gt) {
        super(gt);
        this.add((Component)this.createArrowPanel(), "West");
        this.arrowPanel.setAlignmentX(0.5f);
        if (precision < 0) {
            precision = 0;
        }
        if (precision > 12) {
            precision = 12;
        }
        this.fmt = new Format("%." + precision + "f");
    }

    private JPanel createArrowPanel() {
        this.arrowPanel = new JPanel(new GridLayout(2, 1, 0, 1));
        this.upArrow = new TriangleJPanel(this.innerColor, this.innerColor, this.innerColor, new Dimension(9, 9), true);
        this.upArrow.setToolTipText("hi");
        this.arrowPanel.add(this.upArrow);
        this.downArrow = new TriangleJPanel(this.innerColor, this.innerColor, this.innerColor, new Dimension(9, 9), false);
        this.arrowPanel.add(this.downArrow);
        return this.arrowPanel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DoubleColorNode) {
            DoubleColorNode node = (DoubleColorNode)value;
            double dval = node.getCurrentValue();
            this.setNodeBackground(node);
            this.textLabel.setText(this.fmt.form(dval));
            if (node.isOld()) {
                this.setTextColor(this.oldColor);
            } else {
                this.setTextColor(this.newColor);
            }
        } else {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return this;
    }

    protected void setAllBackgrounds(Color color) {
        super.setAllBackgrounds(color);
        this.arrowPanel.setBackground(color);
        this.upArrow.setColors(color);
        this.downArrow.setColors(color);
    }

    protected void setCellBackground(double value) {
        super.setCellBackground(value);
        if (value < this.getThreshold1() || value > this.getThreshold4()) {
            this.arrowPanel.setBackground(this.outerColor);
            this.upArrow.setColors(this.outerColor);
            this.downArrow.setColors(this.outerColor);
        } else if (value < this.getThreshold2() || value > this.getThreshold3()) {
            this.arrowPanel.setBackground(this.marginColor);
            this.upArrow.setColors(this.marginColor);
            this.downArrow.setColors(this.marginColor);
        } else {
            this.arrowPanel.setBackground(this.innerColor);
            this.upArrow.setColors(this.innerColor);
            this.downArrow.setColors(this.innerColor);
        }
    }

    public void setNodeBackground(DoubleColorNode node) {
        double minVal = node.getMinValue();
        double maxVal = node.getMaxValue();
        double value = node.getCurrentValue();
        Color statusColor = this.getStatusColor(value, true, true);
        Color maxColor = this.getStatusColor(maxVal, false, true);
        Color minColor = this.getStatusColor(minVal, true, false);
        this.textLabel.setBackground(statusColor);
        this.arrowPanel.setBackground(statusColor);
        this.setBackground(statusColor);
        this.upArrow.setBackground(statusColor);
        this.downArrow.setBackground(statusColor);
        if (maxColor.getRed() == 0 && maxColor.getGreen() == 255 && maxColor.getBlue() == 0 || maxColor.equals(statusColor)) {
            this.upArrow.setColors(null);
        } else {
            this.upArrow.setColors(maxColor);
            this.upArrow.setLineColor(Color.black);
            this.upArrow.setInsideColor(maxColor);
        }
        if (minColor.getRed() == 0 && minColor.getGreen() == 255 && minColor.getBlue() == 0 || minColor.equals(statusColor)) {
            this.downArrow.setColors(null);
        } else {
            this.downArrow.setColors(minColor);
            this.downArrow.setInsideColor(minColor);
            this.downArrow.setLineColor(Color.black);
        }
    }
}

