/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.Numeric;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class GradedTableCellRenderer
extends NaqsViewTableCellRenderer {
    protected GradingThresholds thresholds = new GradingThresholds();
    protected Color innerColor = Color.green;
    protected Color marginColor = Color.yellow;
    protected Color outerColor = Color.red;
    protected Color selectedFG = Color.blue;
    protected Color unselectedFG = Color.black;
    protected Color defaultBG = Color.white;

    public GradedTableCellRenderer(GradingThresholds gt) {
        this.setThresholds(gt);
    }

    public void setThresholds(double t1, double t2, double t3, double t4) {
        this.thresholds.setThresholds(t1, t2, t3, t4);
    }

    protected void setThresholds(GradingThresholds gt) {
        this.setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
    }

    public GradingThresholds getThresholds() {
        return this.thresholds;
    }

    public double getThreshold1() {
        return this.thresholds.getThreshold1();
    }

    public double getThreshold2() {
        return this.thresholds.getThreshold2();
    }

    public double getThreshold3() {
        return this.thresholds.getThreshold3();
    }

    public double getThreshold4() {
        return this.thresholds.getThreshold4();
    }

    public Color getInnerColor() {
        return this.innerColor;
    }

    public Color getMarginColor() {
        return this.marginColor;
    }

    public Color getOuterColor() {
        return this.outerColor;
    }

    protected void setCellBackground(double value) {
        if (value < this.getThreshold1() || value > this.getThreshold4()) {
            this.setBackground(this.outerColor);
            this.textLabel.setBackground(this.outerColor);
        } else if (value < this.getThreshold2() || value > this.getThreshold3()) {
            this.setBackground(this.marginColor);
            this.textLabel.setBackground(this.marginColor);
        } else {
            this.setBackground(this.innerColor);
            this.textLabel.setBackground(this.innerColor);
        }
    }

    protected void setAllBackgrounds(Color color) {
        this.setBackground(color);
        this.textLabel.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            this.setAllBackgrounds(this.defaultBG);
            this.textLabel.setText("");
        } else if (value instanceof Number) {
            double dval = ((Number)value).doubleValue();
            this.setCellBackground(dval);
            this.textLabel.setText(value.toString());
        } else if (value instanceof Numeric) {
            double dval = ((Numeric)value).doubleValue();
            this.setCellBackground(dval);
            this.textLabel.setText(value.toString());
        } else {
            this.setAllBackgrounds(this.defaultBG);
            this.textLabel.setText(value.toString());
        }
        return this;
    }

    protected Color getStatusColor(double value, boolean checkMin, boolean checkMax) {
        if (checkMin && value < this.getThreshold1() || checkMax && value > this.getThreshold4()) {
            return this.outerColor;
        }
        if (checkMin && value < this.getThreshold2() || checkMax && value > this.getThreshold3()) {
            return this.marginColor;
        }
        return this.innerColor;
    }
}

