/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HelpViewerDialog
extends JDialog {
    protected JTextField pdfExecName = new JTextField(30);
    private JButton pdfExecChooser = null;
    private static JFileChooser fileChooser = null;
    private String fileName = "";
    private boolean finalStatus;

    public HelpViewerDialog(JDialog parent, String aFileName) {
        super(parent);
        this.setModal(true);
        this.setTitle("Help Viewer Chooser");
        this.fileName = aFileName;
        this.initDialog();
        this.setLocation();
        this.setSize(new Dimension(400, 200));
        this.show();
    }

    private void setLocation() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screen.width / 6;
        int y = screen.height / 6;
        this.setLocation(x, y);
    }

    public void initDialog() {
        Container con = this.getContentPane();
        con.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout());
        JLabel field = new JLabel("Specify the full path to a pdf reader executable\n");
        field.setForeground(Color.red.darker());
        panel.add(field);
        this.pdfExecName.setText(this.fileName);
        this.pdfExecChooser = this.createButton("Browse", "Browse for a pdf reader executable");
        this.pdfExecChooser.addActionListener(new FileDialogButtonAction());
        panel.add(this.pdfExecName);
        panel.add(this.pdfExecChooser);
        con.add((Component)panel, "Center");
        con.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        JButton okButton = this.createButton("OK", "Change to the specified pdf reader");
        okButton.addActionListener(new OKAction());
        panel.add(okButton);
        JButton cancelButton = this.createButton("Cancel", "Don't change the pdf reader.");
        cancelButton.addActionListener(new CancelAction());
        panel.add(cancelButton);
        return panel;
    }

    protected static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        return fileChooser;
    }

    protected JButton createButton(String name, String bTip) {
        JButton aButton = new JButton(name);
        aButton.setToolTipText(bTip);
        aButton.setPreferredSize(new Dimension(100, 30));
        return aButton;
    }

    public String getExecPath() {
        return this.pdfExecName.getText();
    }

    public boolean getFinalStatus() {
        return this.finalStatus;
    }

    protected void dispose(boolean success) {
        this.finalStatus = success;
        super.dispose();
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HelpViewerDialog.this.dispose(false);
        }
    }

    public class FileDialogButtonAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            HelpViewerDialog.getFileChooser().setDialogTitle("Set path to pdf reader executable");
            if (HelpViewerDialog.getFileChooser().showOpenDialog(HelpViewerDialog.this) != 0) {
                return;
            }
            File file = HelpViewerDialog.getFileChooser().getSelectedFile();
            HelpViewerDialog.this.pdfExecName.setText(file.getPath());
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HelpViewerDialog.this.dispose(true);
        }
    }
}

