/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.NmxDateFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HistoryHeader
extends JPanel {
    private JLabel nameLabel = new JLabel("name");
    private JLabel startLabel = new JLabel("start");
    private JLabel maxLabel = new JLabel(" Max:");
    private JLabel minLabel = new JLabel(" Min:");
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy-MM-dd HH:mm:ss");
    private DecimalFormat decFormat = new DecimalFormat("#0.00");

    public HistoryHeader(String name) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.nameLabel.setFont(new Font("Dialog", 1, 16));
        this.nameLabel.setForeground(Color.blue);
        this.nameLabel.setHorizontalAlignment(0);
        this.maxLabel.setFont(new Font("Dialog", 0, 11));
        this.maxLabel.setForeground(Color.black);
        this.maxLabel.setHorizontalAlignment(4);
        this.minLabel.setFont(new Font("Dialog", 0, 11));
        this.minLabel.setForeground(Color.black);
        this.minLabel.setHorizontalAlignment(4);
        this.startLabel.setFont(new Font("Dialog", 0, 11));
        this.startLabel.setForeground(Color.black);
        this.startLabel.setHorizontalAlignment(4);
        this.initLayout();
        this.setName(name);
    }

    protected void initLayout() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.maxLabel, "North");
        mainPanel.add((Component)this.minLabel, "South");
        mainPanel.add((Component)this.nameLabel, "Center");
        this.add((Component)mainPanel, "Center");
        this.add((Component)this.startLabel, "South");
    }

    public int getPreferredWidth() {
        int timewidth;
        FontMetrics fm = this.getFontMetrics(this.nameLabel.getFont());
        int namewidth = fm.stringWidth("MMMMM.MMM");
        int maxwidth = namewidth;
        if (maxwidth < (timewidth = (fm = this.getFontMetrics(this.startLabel.getFont())).stringWidth(this.dateFormat.format(new Date())))) {
            maxwidth = timewidth;
        }
        return maxwidth + 10;
    }

    public void setName(String name) {
        this.nameLabel.setText(name);
    }

    public void setStartTime(double startTime) {
        this.startLabel.setText(this.dateFormat.format(startTime));
    }

    public void setMax(double val) {
        this.maxLabel.setText(this.decFormat.format(val));
    }

    public void setMin(double val) {
        this.minLabel.setText(this.decFormat.format(val));
    }
}

