/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.plot.ScalarRange;
import ca.nanometrics.uitools.plot.SimpleRounder;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.NmxDateFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.PlotArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public abstract class HistoryPanel
extends JPanel
implements Printable {
    protected JCChart chart;
    protected double startTime;
    protected double endTime;
    protected int thresholdChoice;
    protected String name = null;
    protected boolean success = true;
    protected boolean isPlot = true;
    protected boolean firstDiff = false;

    public HistoryPanel(double startTime_, double endTime_, String name, int choice, boolean doFirstDiff) {
        this.setLayout(new BorderLayout());
        this.startTime = startTime_;
        this.endTime = endTime_;
        this.thresholdChoice = choice;
        this.setPlotName(name);
        this.firstDiff = doFirstDiff;
        this.setPreferredSize(new Dimension(500, 200));
    }

    public int getThresholdChoice() {
        return this.thresholdChoice;
    }

    protected String getColorString(Color color) {
        if (color == null) {
            return null;
        }
        String str = "";
        int c = color.getRed();
        String s = Integer.toHexString(c);
        while (s.length() < 2) {
            s = "0" + s;
        }
        str = String.valueOf(str) + s;
        c = color.getGreen();
        s = Integer.toHexString(c);
        while (s.length() < 2) {
            s = "0" + s;
        }
        str = String.valueOf(str) + s;
        c = color.getBlue();
        s = Integer.toHexString(c);
        while (s.length() < 2) {
            s = "0" + s;
        }
        str = String.valueOf(str) + s;
        return "\"#" + str + "\"";
    }

    public PlotArea getPlotArea() {
        return this.chart.getChartArea().getPlotArea();
    }

    protected String getDate(double start, double end) {
        String date = "";
        NmxDateFormat fmt = new NmxDateFormat();
        String date1 = fmt.format(start);
        String date2 = fmt.format(end);
        date = date1.substring(0, 10).equals(date2.substring(0, 10)) ? date1.substring(0, 10) : String.valueOf(date1.substring(0, 10)) + " - " + date2.substring(0, 10);
        return String.valueOf(date) + " (UTC)";
    }

    protected abstract boolean createChart();

    public abstract Vector getData();

    public String getPlotName() {
        return this.name;
    }

    public void setPlotName(String n) {
        this.name = n;
    }

    public boolean success() {
        return this.success;
    }

    protected void setSuccess(boolean s) {
        this.success = s;
    }

    public abstract void saveData(String var1);

    public void saveData(DoubleNode node, String dirName) {
        boolean success = true;
        try {
            success = node.saveData(this.startTime, this.endTime, dirName);
        }
        catch (IOException exc) {
            ErrorDisplay.display("Failed to save data for station: " + node.getName() + " Error: " + exc.getMessage(), "Failure");
            return;
        }
        if (!success) {
            ErrorDisplay.display("Failed to save data for station: " + node.getName(), "Failure");
        }
    }

    public void rightClickMenu(JComponent showHere, int x, int y) {
        JPopupMenu popUp = new JPopupMenu();
        popUp.add(new PrintPlotAction());
        popUp.add(new SaveDataAction());
        popUp.show(showHere, x, y);
    }

    public BufferedImage getImage(int width, int height) {
        Dimension oldSize = this.getPreferredSize();
        this.setSize(new Dimension(width, height));
        this.validate();
        int w = this.getWidth();
        int h = this.getHeight();
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D graph = image.createGraphics();
        AffineTransform trans = AffineTransform.getTranslateInstance(0.0, 0.0);
        graph.setClip(0, 0, w, h);
        graph.setBackground(Color.white);
        graph.clearRect(0, 0, w, h);
        graph.setTransform(trans);
        this.paintAll(graph);
        this.setSize(oldSize);
        this.revalidate();
        return image;
    }

    public boolean isPlot() {
        return this.isPlot;
    }

    protected void setIsPlot(boolean plot) {
        this.isPlot = plot;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 1) {
            return 1;
        }
        BufferedImage image = this.getImage(600, 400);
        int width = image.getWidth();
        int height = image.getHeight();
        Graphics2D graph2D = (Graphics2D)graphics;
        double scalex = pageFormat.getImageableWidth() / (double)width;
        double scaley = pageFormat.getImageableHeight() / (double)height;
        double scale = Math.min(scalex, scaley);
        graph2D.scale(scale, scale);
        graph2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graph2D.setClip(0, 0, width, height);
        int curHeight = 0;
        int curWidth = 0;
        if (image != null) {
            this.drawBufferedImage(image, graph2D, 0, curHeight);
            curWidth += image.getWidth();
        }
        return 0;
    }

    private void drawBufferedImage(BufferedImage image, Graphics2D graphics, int x, int y) {
        graphics.drawImage((Image)image, x, y, new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        });
    }

    protected double[] getTimeSeries(PlotData data) {
        double[] time = data.getTimeSeries();
        if (time == null) {
            return null;
        }
        if (this.firstDiff) {
            double[] fTime = new double[time.length - 1];
            int i = 0;
            while (i < fTime.length) {
                fTime[i] = time[i + 1];
                ++i;
            }
            return fTime;
        }
        return time;
    }

    protected double[] getDataSeries(PlotData data) {
        double[] y = data.getDataSeries();
        if (y == null) {
            return null;
        }
        if (this.firstDiff) {
            double[] fY = new double[y.length - 1];
            int i = 1;
            while (i <= fY.length) {
                fY[i - 1] = y[i] - y[i - 1];
                ++i;
            }
            return fY;
        }
        return y;
    }

    public void firstDifferencePlot(boolean doFirstDiff) {
        this.firstDiff = doFirstDiff;
        this.remove((Component)this.chart);
        this.createChart();
    }

    class ChartMouseListener
    extends MouseAdapter {
        ChartMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int buttonNo = e.getButton();
            if (buttonNo == 3 && e.getClickCount() == 1) {
                HistoryPanel.this.rightClickMenu(HistoryPanel.this, e.getX(), e.getY());
            }
        }
    }

    protected class MinMaxCalculator {
        private double minVal;
        private double maxVal;
        private double precVal;

        public MinMaxCalculator(double minValue, double maxValue, int precision) {
            SimpleRounder sr = new SimpleRounder(5.0);
            ScalarRange range = sr.getRange(minValue, maxValue);
            this.maxVal = range.getMax();
            this.minVal = range.getMin();
            this.precVal = 1.0 / Math.pow(10.0, precision);
            while (this.maxVal - this.minVal < this.precVal) {
                this.maxVal += this.precVal;
                this.minVal -= this.precVal;
            }
        }

        public double getMinValue() {
            return this.minVal;
        }

        public double getMaxValue() {
            return this.maxVal;
        }

        public double getNumSpacing() {
            double range = Math.abs(this.maxVal - this.minVal);
            double tic = range / 10.0;
            double val = range / tic;
            while (val > 5.0) {
                val = range / (tic += range / 10.0);
            }
            tic /= this.precVal;
            tic = Math.round(tic);
            if ((tic *= this.precVal) == 0.0) {
                tic = this.precVal;
            }
            return tic;
        }
    }

    private class PlotPageable
    implements Pageable {
        private PageFormat format;

        public PlotPageable(PageFormat format) {
            this.format = format;
            format.setOrientation(1);
        }

        public int getNumberOfPages() {
            return 1;
        }

        public PageFormat getPageFormat(int pageIndex) {
            return this.format;
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            return HistoryPanel.this;
        }
    }

    private class PrintPlotAction
    extends AbstractAction {
        public PrintPlotAction() {
            super("Print Plot");
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(new PlotPageable(printJob.defaultPage()));
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception ex) {
                    ErrorDisplay.display("Print Error: " + ex.getMessage(), "Printing Error");
                }
            }
        }
    }

    private class SaveDataAction
    extends AbstractAction {
        public SaveDataAction() {
            super("Save Data");
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save To");
            chooser.setFileSelectionMode(1);
            String dir = System.getProperty("user.dir");
            chooser.setCurrentDirectory(new File(dir));
            if (chooser.showSaveDialog(HistoryPanel.this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            String directoryName = file.getPath();
            HistoryPanel.this.saveData(directoryName);
        }
    }
}

