/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.layout.VerFlowLayout;
import ca.nanometrics.util.ErrorDisplay;
import com.klg.jclass.chart.PlotArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class HistoryViewer
extends JFrame
implements DropTargetListener,
Printable {
    public static ArrayList viewers = new ArrayList();
    protected Vector allPlotData = new Vector();
    private JScrollPane scrollPane;
    private boolean finalStatus;
    double startTime;
    double endTime;
    boolean success = true;
    private DropTarget dropTarget;
    protected JPanel plotPanel;
    protected static PlotSettings plotSettings = new PlotSettings();
    private static Color[] colorValues = new Color[]{new Color(255, 0, 0), new Color(255, 200, 0), new Color(0, 0, 255), new Color(255, 0, 255), new Color(0, 255, 0), new Color(128, 128, 128)};
    private int colorIndex = 0;
    private JMenuBar menuBar = new JMenuBar();
    protected Vector plots = new Vector();
    protected JMenu deletePlotsMenu;
    protected JMenu dataMenu;
    private JButton plotButton;
    protected int plotType = 0;
    protected static String[] plotTypeTitles = new String[]{"Single Plots", "Combine Plots", "Combine All Plots"};
    private static final int SINGLE_PLOTS = 0;
    private static final int SINGLE_VARIABLE_PLOTS = 1;
    private static final int COMBINE_ALL_PLOTS = 2;
    private boolean combineAllPlots = false;
    private JButton scrollButton;
    protected int layoutType = 0;
    private static String[] scrollTitles = new String[]{"Scroll", "Fit To Window"};
    private static final int SCROLL = 0;
    private static final int STRETCH = 1;
    public static int DEFAULT_THRESHOLDS = 0;
    public static int ALL_THRESHOLDS = 1;
    public static int NO_THRESHOLDS = 2;
    protected int thresholdChoice = 0;
    protected static final String[] thresholdList = new String[]{"Default", "All", "None"};
    protected boolean firstDiff = false;
    protected JCheckBox firstDiffCheck;
    protected JButton closeButton;
    protected JLabel loadLabel;
    static /* synthetic */ Class class$0;

    public HistoryViewer(ArrayList nodes, double start, double end, int ith) {
        this.setIcon();
        this.setStartTime(start);
        this.setEndTime(end);
        this.dropTarget = new DropTarget(this, this);
        this.setTitle(this.getUniqueTitle(ith));
        Container content = this.getContentPane();
        this.prepareData(nodes);
        this.applyPlotSettings();
        Thread plotThread = new Thread(new PlotRunnable());
        JPanel buttonPanel = this.createButtonPanel();
        content.add((Component)buttonPanel, "South");
        plotThread.start();
        this.addWindowListener(new WindowCloser());
        this.loadLabel = new JLabel("Loading...");
        content.add((Component)this.loadLabel, "Center");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screen.width / 3;
        int y = screen.height / 3;
        this.setLocation(x, y);
        this.setSize(new Dimension(600, 400));
        viewers.add(this);
        this.show();
    }

    protected void activatePanel() {
        this.firstDiffCheck.setEnabled(true);
        this.scrollButton.setEnabled(true);
        this.closeButton.setEnabled(true);
        this.plotButton.setEnabled(true);
        Container content = this.getContentPane();
        content.remove(this.loadLabel);
    }

    private void setIcon() {
        URL url = this.getClass().getResource("drag.GIF");
        Image image = null;
        if (url != null) {
            image = Toolkit.getDefaultToolkit().getImage(url);
        }
        if (image != null) {
            this.setIconImage(image);
        }
    }

    protected void applyPlotSettings() {
        PlotSettings settings = HistoryViewer.getPlotSettings();
        this.plotType = settings.getSingleHistory() ? 0 : 1;
        this.layoutType = settings.scroll() ? 0 : 1;
        this.thresholdChoice = settings.getShowThreshold();
        this.firstDiff = settings.getDoFirstDifferences();
    }

    private String getUniqueTitle(int ith) {
        String title = "History Viewer " + ith;
        int i = 0;
        while (i < viewers.size()) {
            HistoryViewer viewer = (HistoryViewer)viewers.get(i);
            if (viewer.getTitle().equalsIgnoreCase(title)) {
                title = "History Viewer " + (ith + 1);
            }
            ++i;
        }
        return title;
    }

    protected void createMenu() {
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(new SaveAllAction());
        fileMenu.addSeparator();
        fileMenu.add(new PrintAllAction());
        fileMenu.addSeparator();
        fileMenu.add(new ExitAction());
        this.menuBar.add(fileMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        viewMenu.add(new PlotComboAction(0));
        viewMenu.add(new PlotComboAction(1));
        viewMenu.add(new PlotComboAction(2));
        viewMenu.addSeparator();
        JMenu thresholdMenu = new JMenu("Show Thresholds");
        thresholdMenu.add(new ThresholdAction(DEFAULT_THRESHOLDS));
        thresholdMenu.add(new ThresholdAction(ALL_THRESHOLDS));
        thresholdMenu.add(new ThresholdAction(NO_THRESHOLDS));
        viewMenu.add(thresholdMenu);
        this.menuBar.add(viewMenu);
        this.dataMenu = new JMenu("Data");
        this.dataMenu.setMnemonic('D');
        this.dataMenu.add(new ChangeTimesAction());
        this.dataMenu.addMenuListener(new DataMenuListener());
        this.menuBar.add(this.dataMenu);
    }

    protected boolean createPlotPanel() {
        if (this.scrollPane != null) {
            this.getContentPane().remove(this.scrollPane);
        }
        this.plotPanel = new JPanel(new VerFlowLayout());
        this.plotPanel.setBackground(Color.white);
        boolean success = false;
        switch (this.plotType) {
            case 0: {
                success = this.createSinglePlots();
                break;
            }
            case 1: {
                success = this.createSingleVariablePlots();
                break;
            }
            case 2: {
                success = this.combineAllPlots();
            }
        }
        this.plotPanel.setPreferredSize(new Dimension(0, (int)this.plotPanel.getPreferredSize().getHeight()));
        int verScroll = this.layoutType == 0 ? 20 : 21;
        this.scrollPane = new JScrollPane(this.plotPanel, verScroll, 31);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.firstDiffCheck.setSelected(this.firstDiff);
        if (this.plotType == 1) {
            this.combineAllPlots = false;
            this.plotButton.setText(plotTypeTitles[0]);
        }
        return success;
    }

    private boolean createSinglePlots() {
        this.plots.removeAllElements();
        ArrayList<SingleHistoryPlot> failedPlots = new ArrayList<SingleHistoryPlot>();
        if (this.allPlotData.size() > 0) {
            Iterator iter = this.allPlotData.iterator();
            while (iter.hasNext()) {
                PlotData data = (PlotData)iter.next();
                SingleHistoryPlot hPanel = new SingleHistoryPlot(data, this.startTime, this.endTime, this.thresholdChoice, this.firstDiff);
                if (!hPanel.success()) {
                    failedPlots.add(hPanel);
                    continue;
                }
                this.addThePlot(hPanel);
            }
            this.addFailedPlots(failedPlots);
            return true;
        }
        return false;
    }

    protected void lineUpPlots() {
        PlotArea area;
        HistoryPanel panel;
        Iterator iter = this.plots.iterator();
        int left = 0;
        while (iter.hasNext()) {
            panel = (HistoryPanel)iter.next();
            area = panel.getPlotArea();
            if (area.getLeft() <= left) continue;
            left = area.getLeft();
        }
        iter = this.plots.iterator();
        while (iter.hasNext()) {
            panel = (HistoryPanel)iter.next();
            area = panel.getPlotArea();
            area.setLeft(left);
        }
    }

    private void addThePlot(HistoryPanel hPanel) {
        this.plots.add(hPanel);
        this.plotPanel.add(hPanel);
        if (this.layoutType == 0) {
            hPanel.setPreferredSize(new Dimension(0, (int)hPanel.getPreferredSize().getHeight()));
        } else {
            hPanel.setPreferredSize(new Dimension(0, 0));
        }
    }

    private boolean createSingleVariablePlots() {
        this.plots.removeAllElements();
        if (this.allPlotData.size() == 0) {
            return false;
        }
        ArrayList<String> varList = new ArrayList<String>();
        Iterator iter = this.allPlotData.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            String name = data.getVariableName();
            if (name == null) {
                name = "";
            }
            varList.add(name);
        }
        if (varList.size() == 0) {
            return false;
        }
        Collections.sort(varList);
        String str = ".";
        ArrayList<SingleVariablePlot> failedPlots = new ArrayList<SingleVariablePlot>();
        int i = 0;
        while (i < varList.size()) {
            String var = (String)varList.get(i);
            if (!this.stringsAreEqual(var, str)) {
                Vector list = this.collectPlotDataByVariable(var);
                SingleVariablePlot hPanel = new SingleVariablePlot(list, this.startTime, this.endTime, this.thresholdChoice, this.firstDiff);
                if (hPanel.success()) {
                    this.addThePlot(hPanel);
                } else {
                    failedPlots.add(hPanel);
                }
                str = var;
            }
            ++i;
        }
        this.addFailedPlots(failedPlots);
        return true;
    }

    private boolean combineAllPlots() {
        this.plots.removeAllElements();
        if (this.allPlotData.size() == 0) {
            return false;
        }
        Vector allData = new Vector();
        Iterator iter = this.allPlotData.iterator();
        while (iter.hasNext()) {
            allData.add(iter.next());
        }
        CombineAllPlots hPanel = new CombineAllPlots(allData, this.startTime, this.endTime, this.thresholdChoice, this.firstDiff);
        this.addThePlot(hPanel);
        return true;
    }

    private void addFailedPlots(ArrayList failedPlots) {
        int i = 0;
        while (i < failedPlots.size()) {
            HistoryPanel plot = (HistoryPanel)failedPlots.get(i);
            this.addThePlot(plot);
            ++i;
        }
    }

    private Vector collectPlotDataByVariable(String var) {
        Vector<PlotData> list = new Vector<PlotData>();
        Iterator iter = this.allPlotData.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            if (!this.stringsAreEqual(data.getVariableName(), var)) continue;
            list.add(data);
        }
        return list;
    }

    private boolean stringsAreEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.equalsIgnoreCase(s2);
    }

    private void prepareData(ArrayList nodes) {
        int i = 0;
        while (i < nodes.size()) {
            DoubleNode node = (DoubleNode)nodes.get(i);
            this.prepareData(node);
            ++i;
        }
    }

    private void prepareData(DoubleNode node) {
        PlotData data;
        Iterator iter = this.allPlotData.iterator();
        while (iter.hasNext()) {
            data = (PlotData)iter.next();
            if (data.getNode() != node) continue;
            this.allPlotData.remove(data);
            break;
        }
        data = new PlotData(node, this.startTime, this.endTime);
        this.setColor(data);
        this.allPlotData.add(data);
    }

    protected void setStartTime(double time) {
        this.startTime = time;
    }

    protected void setEndTime(double time) {
        this.endTime = time;
    }

    protected double getStartTime() {
        return this.startTime;
    }

    protected double getEndTime() {
        return this.endTime;
    }

    private void setColor(PlotData newData) {
        Iterator iter = this.allPlotData.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            if (!this.stringsAreEqual(data.getNode().getName(), newData.getNode().getName()) || this.combineAllPlots) continue;
            newData.setColor(data.getColor());
            return;
        }
        if (this.colorIndex == colorValues.length) {
            this.colorIndex = 0;
        }
        newData.setColor(colorValues[this.colorIndex++]);
    }

    private void resetColors() {
        Iterator iter = this.allPlotData.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            this.setColor(data);
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.firstDiffCheck = new JCheckBox("Plot First Difference");
        this.firstDiffCheck.setSelected(this.firstDiff);
        this.firstDiffCheck.addActionListener(new FirstDiffCheckboxAction());
        this.firstDiffCheck.setEnabled(false);
        buttonPanel.add(this.firstDiffCheck);
        this.scrollButton = this.layoutType == 0 ? new JButton(scrollTitles[1]) : new JButton(scrollTitles[0]);
        this.scrollButton.setPreferredSize(new Dimension(120, 30));
        this.scrollButton.addActionListener(new ScrollButtonAction());
        this.scrollButton.setEnabled(false);
        buttonPanel.add(this.scrollButton);
        this.plotButton = this.plotType == 0 ? new JButton(plotTypeTitles[1]) : new JButton(plotTypeTitles[0]);
        this.plotButton.setPreferredSize(new Dimension(120, 30));
        this.plotButton.addActionListener(new PlotButtonAction());
        this.plotButton.setEnabled(false);
        buttonPanel.add(this.plotButton);
        this.closeButton = new JButton("Close");
        this.closeButton.setPreferredSize(new Dimension(100, 30));
        this.closeButton.addActionListener(new OkButtonAction());
        this.closeButton.setEnabled(false);
        buttonPanel.add(this.closeButton);
        return buttonPanel;
    }

    protected void changePlotType(int type) {
        this.plotType = type;
        switch (this.plotType) {
            case 0: {
                this.combineAllPlots = false;
                this.plotButton.setText(plotTypeTitles[1]);
                plotSettings.setSingleHistory(true);
                break;
            }
            case 2: {
                this.combineAllPlots = true;
                this.resetColors();
                this.plotButton.setText(plotTypeTitles[0]);
                plotSettings.setSingleHistory(false);
                break;
            }
            case 1: {
                this.combineAllPlots = false;
                this.resetColors();
                this.plotButton.setText(plotTypeTitles[0]);
                plotSettings.setSingleHistory(false);
            }
        }
        this.createPlotPanel();
        this.validate();
        this.lineUpPlots();
        this.validate();
    }

    protected void changePlotLayout(int type) {
        this.layoutType = type;
        switch (this.layoutType) {
            case 0: {
                this.scrollButton.setText(scrollTitles[1]);
                HistoryViewer.getPlotSettings().setScroll(true);
                break;
            }
            case 1: {
                this.scrollButton.setText(scrollTitles[0]);
                HistoryViewer.getPlotSettings().setScroll(false);
            }
        }
        this.createPlotPanel();
        this.validate();
        this.lineUpPlots();
        this.validate();
    }

    public void closeWindow() {
        this.setPlotSettings();
        this.dispose(true);
    }

    public boolean success() {
        return this.success;
    }

    protected void dispose(boolean success) {
        viewers.remove(this);
        this.finalStatus = success;
        super.dispose();
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
        Transferable trans = dtde.getTransferable();
        Object obj = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("NaqsNode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            obj = trans.getTransferData(new DataFlavor(clazz, "DoubleNode"));
        }
        catch (UnsupportedFlavorException e) {
            System.out.println("Unsupported Flavor; message: " + e.getMessage());
            return;
        }
        catch (IOException ioe) {
            System.out.println("IOException on drop; message: " + ioe.getMessage());
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof DoubleNode) {
            DoubleNode node = (DoubleNode)obj;
            this.prepareData(node);
            this.createPlotPanel();
            this.validate();
            this.lineUpPlots();
            this.validate();
        } else if (obj instanceof StationNode) {
            StationNode sNode = (StationNode)obj;
            ArrayList nodes = sNode.getNodes();
            this.prepareData(nodes);
            this.createPlotPanel();
            this.validate();
            this.lineUpPlots();
            this.validate();
        }
    }

    public void addNode(DoubleNode node) {
        this.prepareData(node);
        this.createPlotPanel();
        this.validate();
        this.lineUpPlots();
        this.validate();
    }

    public void addNodes(ArrayList nodes) {
        this.prepareData(nodes);
        this.createPlotPanel();
        this.validate();
        this.lineUpPlots();
        this.validate();
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static PlotSettings getPlotSettings() {
        return plotSettings;
    }

    private void setPlotSettings() {
        PlotSettings pSettings = HistoryViewer.getPlotSettings();
        if (this.layoutType == 0) {
            pSettings.setScroll(true);
        } else {
            pSettings.setScroll(false);
        }
        if (this.plotType == 0) {
            pSettings.setSingleHistory(true);
        } else {
            pSettings.setSingleHistory(false);
        }
        pSettings.setShowThreshold(this.thresholdChoice);
    }

    public static void updateSettings(NaqsViewSettings naqsSettings) {
        PlotSettings pSettings = HistoryViewer.getPlotSettings();
        PlotSettings updateSettings = naqsSettings.getPlotSettings();
        updateSettings.setDuration(pSettings.getDuration());
        updateSettings.setMostRecent(pSettings.getMostRecent());
        updateSettings.setScroll(pSettings.scroll());
        updateSettings.setShowThreshold(pSettings.getShowThreshold());
        updateSettings.setSingleHistory(pSettings.getSingleHistory());
        updateSettings.setStartTime(pSettings.getStartTime());
        updateSettings.setUnitsString(pSettings.getUnitString());
        updateSettings.setDoFirstDifferences(pSettings.getDoFirstDifferences());
    }

    public static void applySettings(NaqsViewSettings naqsSettings) {
        PlotSettings pSettings = HistoryViewer.getPlotSettings();
        PlotSettings newSettings = naqsSettings.getPlotSettings();
        pSettings.setDuration(newSettings.getDuration());
        pSettings.setMostRecent(newSettings.getMostRecent());
        pSettings.setScroll(newSettings.scroll());
        pSettings.setShowThreshold(newSettings.getShowThreshold());
        pSettings.setSingleHistory(newSettings.getSingleHistory());
        pSettings.setStartTime(newSettings.getStartTime());
        pSettings.setUnitsString(newSettings.getUnitString());
        pSettings.setDoFirstDifferences(newSettings.getDoFirstDifferences());
    }

    private ArrayList getActualPlots() {
        ArrayList<HistoryPanel> list = new ArrayList<HistoryPanel>();
        int i = 0;
        while (i < this.plots.size()) {
            HistoryPanel plot = (HistoryPanel)this.plots.get(i);
            if (plot.isPlot()) {
                list.add(plot);
            }
            ++i;
        }
        return list;
    }

    protected void setFirstDifferencePlot(boolean setFirstDiff) {
        this.firstDiff = setFirstDiff;
        plotSettings.setDoFirstDifferences(this.firstDiff);
        Enumeration enumeration = this.plots.elements();
        while (enumeration.hasMoreElements()) {
            HistoryPanel panel = (HistoryPanel)enumeration.nextElement();
            panel.firstDifferencePlot(setFirstDiff);
        }
    }

    public int printStretch(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        int i = 0;
        int width = 0;
        int height = 0;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        BufferedImage image = null;
        ArrayList actualPlots = this.getActualPlots();
        int plotHeight = (int)Math.round(pageFormat.getHeight() / (double)actualPlots.size());
        i = 0;
        while (i < actualPlots.size()) {
            HistoryPanel plot = (HistoryPanel)actualPlots.get(i);
            image = plot.getImage(600, plotHeight);
            height += image.getHeight();
            images.add(image);
            ++i;
        }
        if (image == null) {
            return 1;
        }
        width = image.getWidth();
        Graphics2D graph2D = (Graphics2D)graphics;
        double scalex = pageFormat.getImageableWidth() / (double)width;
        double scaley = pageFormat.getImageableHeight() / (double)height;
        double scale = Math.min(scalex, scaley);
        graph2D.scale(scale, scale);
        graph2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graph2D.setClip(0, 0, width, height);
        int curHeight = 0;
        i = 0;
        while (i < images.size()) {
            image = (BufferedImage)images.get(i);
            this.drawBufferedImage(image, graph2D, 0, curHeight);
            curHeight += image.getHeight();
            ++i;
        }
        return 0;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.layoutType == 1) {
            return this.printStretch(graphics, pageFormat, pageIndex);
        }
        int plot1 = pageIndex * 2;
        int plot2 = plot1 + 1;
        BufferedImage plot1Image = null;
        BufferedImage plot2Image = null;
        ArrayList actualPlots = this.getActualPlots();
        if (plot1 >= actualPlots.size()) {
            return 1;
        }
        HistoryPanel p1 = (HistoryPanel)actualPlots.get(plot1);
        plot1Image = p1.getImage(600, 400);
        if (plot2 < actualPlots.size()) {
            HistoryPanel p2 = (HistoryPanel)actualPlots.get(plot2);
            plot2Image = p2.getImage(600, 400);
        }
        int width = 0;
        int height = 0;
        if (plot1Image == null) {
            return 1;
        }
        width = plot1Image.getWidth();
        height = plot1Image.getHeight();
        if (plot2Image != null) {
            height += plot2Image.getHeight();
        }
        Graphics2D graph2D = (Graphics2D)graphics;
        double scalex = pageFormat.getImageableWidth() / (double)width;
        double scaley = pageFormat.getImageableHeight() / (double)height;
        double scale = Math.min(scalex, scaley);
        graph2D.scale(scale, scale);
        graph2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graph2D.setClip(0, 0, width, height);
        int curHeight = 0;
        if (plot1Image != null) {
            this.drawBufferedImage(plot1Image, graph2D, 0, curHeight);
            curHeight = plot1Image.getHeight();
        }
        if (plot2Image != null) {
            this.drawBufferedImage(plot2Image, graph2D, 0, curHeight);
        }
        return 0;
    }

    private void drawBufferedImage(BufferedImage image, Graphics2D graphics, int x, int y) {
        graphics.drawImage((Image)image, x, y, new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return true;
            }
        });
    }

    private class ChangeTimesAction
    extends AbstractAction {
        public ChangeTimesAction() {
            super("Change Times");
        }

        public void actionPerformed(ActionEvent e) {
            HistoryDurationDialog dlog = null;
            try {
                dlog = new HistoryDurationDialog(HistoryViewer.this.getStartTime(), HistoryViewer.this.getEndTime() - HistoryViewer.this.getStartTime());
            }
            catch (IOException exc) {
                ErrorDisplay.display("Unable to display History Duration Dialog; Error: " + exc.getMessage(), " Dialog Failure");
                return;
            }
            NaqsView.statusBar.push("Recreating plots with new times");
            HistoryViewer.this.setStartTime(dlog.getStartTime());
            HistoryViewer.this.setEndTime(HistoryViewer.this.getStartTime() + dlog.getDuration());
            Iterator iter = HistoryViewer.this.allPlotData.iterator();
            while (iter.hasNext()) {
                PlotData data = (PlotData)iter.next();
                data.updateData(HistoryViewer.this.getStartTime(), HistoryViewer.this.getEndTime());
            }
            HistoryViewer.this.createPlotPanel();
            HistoryViewer.this.validate();
            HistoryViewer.this.lineUpPlots();
            HistoryViewer.this.validate();
            NaqsView.statusBar.pop();
        }
    }

    private class DataMenuListener
    implements MenuListener {
        public void menuSelected(MenuEvent e) {
            if (HistoryViewer.this.deletePlotsMenu != null) {
                HistoryViewer.this.dataMenu.remove(HistoryViewer.this.deletePlotsMenu);
            }
            if (HistoryViewer.this.plots.size() == 0) {
                return;
            }
            HistoryViewer.this.deletePlotsMenu = new JMenu("Delete Plots");
            int i = 0;
            while (i < HistoryViewer.this.plots.size()) {
                HistoryViewer.this.deletePlotsMenu.add(new DeletePlotAction((HistoryPanel)HistoryViewer.this.plots.get(i)));
                ++i;
            }
            HistoryViewer.this.dataMenu.add(HistoryViewer.this.deletePlotsMenu);
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class DeletePlotAction
    extends AbstractAction {
        private HistoryPanel plot;

        public DeletePlotAction(HistoryPanel plot) {
            super(plot.getPlotName());
            this.plot = plot;
        }

        public void actionPerformed(ActionEvent e) {
            Vector datas = this.plot.getData();
            if (datas == null) {
                ErrorDisplay.display("Unable to delete plot: " + this.plot.getPlotName(), "Delete plot failed");
                return;
            }
            Iterator iter = datas.iterator();
            while (iter.hasNext()) {
                PlotData data = (PlotData)iter.next();
                if (!HistoryViewer.this.allPlotData.contains(data)) continue;
                HistoryViewer.this.allPlotData.remove(data);
            }
            HistoryViewer.this.createPlotPanel();
            HistoryViewer.this.validate();
            HistoryViewer.this.lineUpPlots();
            HistoryViewer.this.validate();
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent e) {
            HistoryViewer.this.closeWindow();
        }
    }

    private class FirstDiffCheckboxAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (HistoryViewer.this.firstDiffCheck.isSelected()) {
                if (HistoryViewer.this.firstDiff) {
                    return;
                }
                HistoryViewer.this.setFirstDifferencePlot(true);
            } else {
                if (!HistoryViewer.this.firstDiff) {
                    return;
                }
                HistoryViewer.this.setFirstDifferencePlot(false);
            }
            HistoryViewer.this.validate();
            HistoryViewer.this.lineUpPlots();
            HistoryViewer.this.validate();
        }
    }

    class OkButtonAction
    implements ActionListener {
        OkButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HistoryViewer.this.closeWindow();
        }
    }

    class PlotButtonAction
    implements ActionListener {
        PlotButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (HistoryViewer.this.plotType == 0) {
                HistoryViewer.this.changePlotType(1);
            } else {
                HistoryViewer.this.changePlotType(0);
            }
        }
    }

    private class PlotComboAction
    extends AbstractAction {
        private int type;

        public PlotComboAction(int i) {
            super(plotTypeTitles[i]);
            this.type = i;
        }

        public void actionPerformed(ActionEvent e) {
            HistoryViewer.this.changePlotType(this.type);
        }
    }

    private class PlotPageable
    implements Pageable {
        private PageFormat format;

        public PlotPageable(PageFormat format) {
            this.format = format;
            format.setOrientation(1);
        }

        public int getNumberOfPages() {
            int retVal = HistoryViewer.this.plots.size() / 2;
            if (HistoryViewer.this.plots.size() % 2 > 0) {
                ++retVal;
            }
            return retVal;
        }

        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            return this.format;
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            return HistoryViewer.this;
        }
    }

    private class PlotRunnable
    implements Runnable {
        public void run() {
            HistoryViewer.this.plotPanel = new JPanel();
            if (!HistoryViewer.this.createPlotPanel()) {
                ErrorDisplay.display("History Viewer failed to retrieve data.", "Data Failure");
                HistoryViewer.this.success = false;
                return;
            }
            HistoryViewer.this.createMenu();
            HistoryViewer.this.activatePanel();
            HistoryViewer.this.validate();
            HistoryViewer.this.repaint();
            HistoryViewer.this.lineUpPlots();
            HistoryViewer.this.validate();
            HistoryViewer.this.repaint();
        }
    }

    private class PrintAllAction
    extends AbstractAction {
        public PrintAllAction() {
            super("Print All Plots");
        }

        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPageable(new PlotPageable(printJob.defaultPage()));
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception ex) {
                    ErrorDisplay.display("Print Error: " + ex.getMessage(), "Printing Error");
                }
            }
        }
    }

    private class SaveAllAction
    extends AbstractAction {
        public SaveAllAction() {
            super("Save All Data");
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save To");
            chooser.setFileSelectionMode(1);
            String dir = System.getProperty("user.dir");
            chooser.setCurrentDirectory(new File(dir));
            if (chooser.showSaveDialog(HistoryViewer.this) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            String directoryName = file.getPath();
            Iterator iter = HistoryViewer.this.plots.iterator();
            while (iter.hasNext()) {
                HistoryPanel plot = (HistoryPanel)iter.next();
                plot.saveData(directoryName);
            }
        }
    }

    class ScrollButtonAction
    implements ActionListener {
        ScrollButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (HistoryViewer.this.layoutType == 0) {
                HistoryViewer.this.changePlotLayout(1);
            } else {
                HistoryViewer.this.changePlotLayout(0);
            }
        }
    }

    class ThresholdAction
    extends AbstractAction {
        int type;

        public ThresholdAction(int aType) {
            super(thresholdList[aType]);
            this.type = aType;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.type == HistoryViewer.this.thresholdChoice) {
                return;
            }
            switch (this.type) {
                case 0: {
                    HistoryViewer.this.thresholdChoice = DEFAULT_THRESHOLDS;
                    break;
                }
                case 1: {
                    HistoryViewer.this.thresholdChoice = ALL_THRESHOLDS;
                    break;
                }
                case 2: {
                    HistoryViewer.this.thresholdChoice = NO_THRESHOLDS;
                }
            }
            plotSettings.setShowThreshold(HistoryViewer.this.thresholdChoice);
            HistoryViewer.this.createPlotPanel();
            HistoryViewer.this.validate();
            HistoryViewer.this.lineUpPlots();
            HistoryViewer.this.validate();
        }
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == HistoryViewer.this) {
                HistoryViewer.this.closeWindow();
            }
        }
    }
}

