/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class InfoDialog
extends CenteredDialog {
    public static final int BLANK = 32;
    public static final int RETURN = 10;
    private JLabel msgLine1;
    private JLabel msgLine2;
    private JLabel msgLine3;
    private JLabel msgLine4;
    protected JButton okButton;

    public InfoDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        this.finishConstruction();
    }

    public InfoDialog(JDialog parent, boolean modal) {
        super(parent, modal);
        this.finishConstruction();
    }

    private void finishConstruction() {
        Container content = this.getContentPane();
        content.setLayout(null);
        this.setVisible(false);
        this.setSize(397, 213);
        this.msgLine1 = new JLabel("You have totally screwed up.", 0);
        this.msgLine1.setBounds(24, 24, 348, 23);
        this.msgLine1.setFont(new Font("Dialog", 1, 12));
        content.add(this.msgLine1);
        this.msgLine2 = new JLabel("This application will self-destruct in 10 seconds", 0);
        this.msgLine2.setBounds(24, 48, 348, 23);
        this.msgLine2.setFont(new Font("Dialog", 1, 12));
        content.add(this.msgLine2);
        this.msgLine3 = new JLabel("Too bad about your hard drive...", 0);
        this.msgLine3.setBounds(24, 72, 348, 23);
        this.msgLine3.setFont(new Font("Dialog", 1, 12));
        content.add(this.msgLine3);
        this.msgLine4 = new JLabel("Do you want to continue?", 0);
        this.msgLine4.setBounds(24, 96, 348, 23);
        this.msgLine4.setFont(new Font("Dialog", 1, 12));
        content.add(this.msgLine4);
        this.okButton = new JButton(" OK ");
        this.okButton.setMnemonic('O');
        this.okButton.setBounds(138, 156, 120, 24);
        this.okButton.setFont(new Font("Dialog", 1, 12));
        content.add(this.okButton);
        this.setTitle("Calibration Settings");
        this.setResizable(false);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.okButton.addActionListener(buttonHandler);
    }

    String fitStringIn(JLabel label, String str) {
        int space = label.getSize().width;
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int lower = -1;
        int maxlen = str.indexOf(10);
        if (maxlen < 0) {
            maxlen = str.length();
        }
        int upper = maxlen;
        while (upper - lower > 1) {
            int mid = (upper + lower) / 2;
            int width = fm.stringWidth(str.substring(0, mid));
            if (width <= space) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        int last = upper;
        if (upper > 0 && upper < maxlen) {
            last = str.lastIndexOf(32, upper);
        }
        if (last < 0) {
            last = upper;
        }
        if (last > 0) {
            label.setText(str.substring(0, last));
        } else {
            label.setText("");
        }
        if (last < str.length() && (str.charAt(last) == ' ' || str.charAt(last) == '\n')) {
            ++last;
        }
        if (last < str.length()) {
            return str.substring(last);
        }
        return "";
    }

    public void setText(String line) {
        String remainder = this.fitStringIn(this.msgLine1, line);
        remainder = this.fitStringIn(this.msgLine2, remainder);
        remainder = this.fitStringIn(this.msgLine3, remainder);
        remainder = this.fitStringIn(this.msgLine4, remainder);
    }

    public void setText(String line1, String line2, String line3, String line4) {
        this.msgLine1.setText(line1);
        this.msgLine2.setText(line2);
        this.msgLine3.setText(line3);
        this.msgLine4.setText(line4);
    }

    void okButtonSelected() {
        this.dispose();
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == InfoDialog.this.okButton) {
                InfoDialog.this.okButtonSelected();
            }
        }
    }
}

