/*
 * Decompiled with CFR 0.152.
 */
public class LinearScale {
    private double rLPtoDP;
    private double kLPtoDP;
    private double rDPtoLP;
    private double kDPtoLP;

    public LinearScale(double xminLP, double wLP, double xminDP, double wDP) {
        if (wDP != 0.0 && wLP != 0.0) {
            this.rLPtoDP = wDP / wLP;
            this.rDPtoLP = wLP / wDP;
        } else {
            this.rLPtoDP = 0.0;
            this.rDPtoLP = 0.0;
        }
        this.kLPtoDP = xminDP - this.rLPtoDP * xminLP;
        this.kDPtoLP = xminLP - this.rDPtoLP * xminDP;
    }

    public double xDPtoLP(double xDP) {
        return this.kDPtoLP + this.rDPtoLP * xDP;
    }

    public double xLPtoDP(double xLP) {
        return this.kLPtoDP + this.rLPtoDP * xLP;
    }
}

