/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.FastExternalSohBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.table.SimpleTableCellRenderer;
import ca.nanometrics.util.InvalidInputException;
import java.util.Enumeration;
import javax.swing.table.TableCellRenderer;

public class MassPositionTableRow
extends AbstractSohTableRow {
    public static String tableName = "Mass Position and Centering";
    private int[] bundleTypes = new int[]{32};
    protected boolean enabled = false;
    public final int STATION = 0;
    public final int SELECTOR = 1;
    public final int INSTRUMENT = 2;
    public final int LAST_UPDATE = 3;
    public final int MASS_POS1 = 4;
    public final int MASS_POS2 = 5;
    public final int MASS_POS3 = 6;
    public final int SENSOR = 7;
    public final int CENTERABLE = 8;
    public final int COLUMN_COUNT = 9;
    private boolean selected = false;
    private long lastUpdate = 0L;
    private float massPos1 = 0.0f;
    private float massPos2 = 0.0f;
    private float massPos3 = 0.0f;
    private String sensorType = "none";
    private int centerable = 0;
    private DoubleColorNode massPosNode1;
    private DoubleColorNode massPosNode2;
    private DoubleColorNode massPosNode3;
    protected GradingThresholds gt1;
    protected GradingThresholds gt2;
    protected GradingThresholds gt3;
    protected StationNode stationNode;
    private SohDataSource dataSource;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public MassPositionTableRow(int theKey, String theStation) {
        super(theKey, theStation);
        this.createThresholds();
    }

    public SohTableRow createTableRow(int key, String name) {
        MassPositionTableRow row = new MassPositionTableRow(key, name);
        row.setDataSource(this.getDataSource());
        row.setGradingThresholds(this.getGradingThresholds(1), 1);
        row.setGradingThresholds(this.getGradingThresholds(2), 2);
        row.setGradingThresholds(this.getGradingThresholds(3), 3);
        return row;
    }

    public void applyThresholds(GradingThresholdTable table) {
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            GradingThresholds gt = table.get(key);
            if (key.equalsIgnoreCase("Mass Pos 1")) {
                this.gt1.setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
                continue;
            }
            if (key.equalsIgnoreCase("Mass Pos 2")) {
                this.gt2.setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
                continue;
            }
            if (!key.equalsIgnoreCase("Mass Pos 3")) continue;
            this.gt3.setThresholds(gt.getThreshold1(), gt.getThreshold2(), gt.getThreshold3(), gt.getThreshold4());
        }
    }

    private void createThresholds() {
        this.gt1 = new GradingThresholds(-5.0, -2.0, 2.0, 5.0);
        this.gt2 = new GradingThresholds(-5.0, -2.0, 2.0, 5.0);
        this.gt3 = new GradingThresholds(-5.0, -2.0, 2.0, 5.0);
    }

    private void setGradingThresholds(GradingThresholds gt, int i) {
        switch (i) {
            case 1: {
                this.gt1 = gt;
                this.getMassPosNode(i).setThresholds(this.gt1);
                return;
            }
            case 2: {
                this.gt2 = gt;
                this.getMassPosNode(i).setThresholds(this.gt2);
                return;
            }
            case 3: {
                this.gt3 = gt;
                this.getMassPosNode(i).setThresholds(this.gt3);
                return;
            }
        }
    }

    private GradingThresholds getGradingThresholds(int i) {
        switch (i) {
            case 1: {
                return this.gt1;
            }
            case 2: {
                return this.gt2;
            }
            case 3: {
                return this.gt3;
            }
        }
        return null;
    }

    public String getTableName() {
        String str = NmxHelp.getFieldName("mpc.title");
        if (str != null || str.trim().length() > 0) {
            return str;
        }
        return tableName;
    }

    public boolean acceptKey(int key) {
        int model = ChannelKey.getModelOf(key);
        return ChannelKey.getTypeOf(key) == 2;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void resetChannelInfo() {
        this.centerable = 0;
        this.sensorType = "";
    }

    public void addChannelInfo(int enable, String sensor) {
        if (enable > 0) {
            ++this.centerable;
            this.sensorType = sensor;
        } else if (this.sensorType.equals("")) {
            this.sensorType = sensor;
        }
    }

    public int getColumnCount() {
        return 9;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NmxHelp.getFieldName("station");
            }
            case 1: {
                return NmxHelp.getFieldName("mpc.selected");
            }
            case 2: {
                return NmxHelp.getFieldName("instrument");
            }
            case 3: {
                return NmxHelp.getFieldName("lastupdate");
            }
            case 4: {
                return NmxHelp.getFieldName("mpc.masspos1");
            }
            case 5: {
                return NmxHelp.getFieldName("mpc.masspos2");
            }
            case 6: {
                return NmxHelp.getFieldName("mpc.masspos3");
            }
            case 7: {
                return NmxHelp.getFieldName("mpc.sensortype");
            }
            case 8: {
                return NmxHelp.getFieldName("mpc.numchannels");
            }
        }
        return "Invalid";
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("StationNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 1: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 3: {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("DateNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 4: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 5: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 6: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("DoubleColorNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 7: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 8: {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
        }
        return null;
    }

    public TableCellRenderer getColumnRenderer(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return new SimpleTableCellRenderer();
            }
            case 1: {
                return null;
            }
            case 2: {
                return new SimpleTableCellRenderer();
            }
            case 3: {
                return new GradedDateSecTableCellRenderer(new GradingThresholds(-30.0, -10.0, 120.0, 600.0));
            }
            case 4: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(-5.0, -2.0, 2.0, 5.0));
            }
            case 5: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(-5.0, -2.0, 2.0, 5.0));
            }
            case 6: {
                return new GradedFloatTableCellRenderer(2, new GradingThresholds(-5.0, -2.0, 2.0, 5.0));
            }
            case 7: {
                return new SimpleTableCellRenderer();
            }
            case 8: {
                return new SimpleTableCellRenderer();
            }
        }
        return null;
    }

    private DoubleColorNode getMassPosNode(int i) {
        switch (i) {
            case 1: {
                if (this.massPosNode1 == null) {
                    this.createMassPosNode(1);
                }
                return this.massPosNode1;
            }
            case 2: {
                if (this.massPosNode2 == null) {
                    this.createMassPosNode(2);
                }
                return this.massPosNode2;
            }
            case 3: {
                if (this.massPosNode3 == null) {
                    this.createMassPosNode(3);
                }
                return this.massPosNode3;
            }
        }
        return null;
    }

    private void createMassPosNode(int i) {
        DoubleColorNode node = null;
        switch (i) {
            case 1: {
                node = this.massPosNode1;
                break;
            }
            case 2: {
                node = this.massPosNode2;
                break;
            }
            case 3: {
                node = this.massPosNode3;
                break;
            }
            default: {
                System.out.println("Node not created");
            }
        }
        if (node != null) {
            return;
        }
        node = new DoubleColorNode(this.getStationName(), this.getChannelName(), this.getInstrument(), "Mass Pos " + i, this.bundleType, this.bundleTypes, "%0.2f", this.dataSource, 2);
        node.setThresholds(this.getGradingThresholds(i));
        switch (i) {
            case 1: {
                this.massPosNode1 = node;
                break;
            }
            case 2: {
                this.massPosNode2 = node;
                break;
            }
            case 3: {
                this.massPosNode3 = node;
                break;
            }
            default: {
                System.out.println("Node not created");
            }
        }
    }

    private StationNode getStationNode() {
        if (this.stationNode == null) {
            this.stationNode = new StationNode(this.getStationName(), this.getChannelName(), this.getInstrument());
            this.stationNode.addNode(this.getMassPosNode(1));
            this.stationNode.addNode(this.getMassPosNode(2));
            this.stationNode.addNode(this.getMassPosNode(3));
        }
        return this.stationNode;
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getStationNode();
            }
            case 1: {
                return new Boolean(this.selected);
            }
            case 2: {
                return this.getInstrument();
            }
            case 3: {
                return this.getDateNode();
            }
            case 4: {
                return this.getMassPosNode(1);
            }
            case 5: {
                return this.getMassPosNode(2);
            }
            case 6: {
                return this.getMassPosNode(3);
            }
            case 7: {
                return this.sensorType;
            }
            case 8: {
                return new Integer(this.centerable);
            }
        }
        return null;
    }

    public void setValueAt(Object obj, int columnIndex) {
        if (columnIndex == 1 && obj instanceof Boolean) {
            boolean doSelect = (Boolean)obj;
            this.selected = doSelect && this.centerable > 0;
        }
    }

    public boolean isCellEditable(int columnIndex) {
        if (columnIndex == 1 && this.enabled) {
            return this.selected || this.centerable > 0;
        }
        return false;
    }

    public int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 80;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 120;
            }
            case 4: {
                return 60;
            }
            case 5: {
                return 60;
            }
            case 6: {
                return 60;
            }
            case 7: {
                return 80;
            }
            case 8: {
                return 60;
            }
        }
        return 20;
    }

    public void process(SohBundle bundle) throws InvalidInputException {
        if (bundle.getType() == 32) {
            FastExternalSohBundle fesb = new FastExternalSohBundle(bundle);
            this.lastUpdate = fesb.getLongSeconds();
            if (this.lastUpdate > 0L) {
                this.enabled = true;
            }
            this.getDateNode().setCurrentTime(this.lastUpdate);
            this.massPos1 = fesb.getMassPos1();
            this.getMassPosNode(1).setCurrentValues(this.massPos1, this.lastUpdate);
            this.massPos2 = fesb.getMassPos2();
            this.getMassPosNode(2).setCurrentValues(this.massPos2, this.lastUpdate);
            this.massPos3 = fesb.getMassPos3();
            this.getMassPosNode(3).setCurrentValues(this.massPos3, this.lastUpdate);
            this.setNodeNamesAndIndexes(fesb);
            this.bundleType = 32;
            int i = 1;
            while (i < 4) {
                this.getMassPosNode(i).setBundleType(this.bundleType);
                ++i;
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void setNodeNamesAndIndexes(SohBundle bundle) {
        int index = 0;
        int i = 0;
        while (i < bundle.getColumnCount()) {
            String newStr = bundle.getReadingHeaderByIndex(i);
            if (newStr.indexOf("1") >= 0) {
                index = 1;
            } else if (newStr.indexOf("2") >= 0) {
                index = 2;
            } else if (newStr.indexOf("3") >= 0) {
                index = 3;
            }
            if (index != 0) {
                this.getMassPosNode(index).setReadingName(newStr);
                this.getMassPosNode(index).setReadingDataIndex(i);
            }
            ++i;
        }
    }

    public void setDataSource(SohDataSource src) {
        this.dataSource = src;
        int i = 1;
        while (i < 4) {
            this.getMassPosNode(i).setDataSource(this.dataSource);
            ++i;
        }
    }

    public SohDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean hasPopup(int col) {
        return col == 4 || col == 5 || col == 6;
    }

    public void resetNode(int col) {
        switch (col) {
            case 4: {
                this.getMassPosNode(1).reset();
                break;
            }
            case 5: {
                this.getMassPosNode(2).reset();
                break;
            }
            case 6: {
                this.getMassPosNode(3).reset();
            }
        }
    }

    public void resetAll() {
        this.resetNode(4);
        this.resetNode(5);
        this.resetNode(6);
    }

    public DoubleNode getDoubleNode(int col) {
        switch (col) {
            case 4: {
                return this.getMassPosNode(1);
            }
            case 5: {
                return this.getMassPosNode(2);
            }
            case 6: {
                return this.getMassPosNode(3);
            }
        }
        return null;
    }
}

