/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.MassCenterCommand;
import ca.nanometrics.msg.MassCenterResult;
import ca.nanometrics.msg.MsgConsumer;
import ca.nanometrics.msg.MsgProducer;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Packable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class MassPositionViewer
extends SohViewer
implements MsgConsumer {
    static final int SOH_TYPE = 2;
    static final int SOH_CHANNEL = 0;
    private MsgProducer producer = null;
    private CalibrationInfoTable calTable = new CalibrationInfoTable();

    public MassPositionViewer(Frame frame) {
        super(new MassPositionTableRow(0, "STN"), frame);
        JPanel buttonPanel = this.createButtonPanel();
        this.getMainPanel().add((Component)buttonPanel, "South");
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.showButton = new JCheckBox("Show Active Only");
        if (!this.getShowAllSelected()) {
            this.showButton.setSelected(true);
        } else {
            this.showButton.setSelected(false);
        }
        buttonPanel.add(this.showButton);
        this.showButton.addActionListener(new SohViewer.ShowAllAction(this));
        JButton resetSelector = new JButton("Reset All");
        buttonPanel.add(resetSelector);
        resetSelector.addActionListener(new SohViewer.ResetAllAction(this));
        JButton stationSelector = new JButton("Select Stations");
        stationSelector.setMnemonic('S');
        buttonPanel.add(stationSelector);
        stationSelector.addActionListener(new SohViewer.SelectStationAction(this));
        JButton columnAdjuster = new JButton("Column Settings");
        columnAdjuster.setMnemonic('C');
        buttonPanel.add(columnAdjuster);
        columnAdjuster.addActionListener(new SohViewer.ColumnSettingsAction(this));
        JButton massCenterer = new JButton("Mass Center");
        massCenterer.setMnemonic('M');
        buttonPanel.add(massCenterer);
        massCenterer.addActionListener(new MassCenterAction());
        return buttonPanel;
    }

    protected void invokeMassCenter() {
        int[] keys = new int[this.calTable.size()];
        int numKeys = 0;
        Enumeration e = this.calTable.elements();
        while (e.hasMoreElements()) {
            CalibrationInfo info = (CalibrationInfo)e.nextElement();
            int ID = info.getInstrumentID();
            int sohKey = ChannelKey.getKeyOf(2, 0, ID);
            MassPositionTableRow entry = (MassPositionTableRow)this.getEntry(sohKey);
            if (entry == null || !entry.isSelected()) continue;
            keys[numKeys] = info.getKey();
            ++numKeys;
        }
        if (numKeys == 0) {
            ErrorDialog edb = new ErrorDialog((JDialog)this, "Mass Centering");
            edb.setText("\nError:  No channels were selected!");
            edb.setVisible(true);
            return;
        }
        PasswordDialog pwd = new PasswordDialog(this);
        pwd.setTitle("Enter calibration password");
        pwd.setText("An authorized password is required", "to perform mass centering.");
        pwd.setVisible(true);
        if (!pwd.isOk()) {
            return;
        }
        String password = pwd.getPassword();
        int[] channelKeys = new int[numKeys];
        System.arraycopy(keys, 0, channelKeys, 0, numKeys);
        boolean sent = this.send(new MassCenterCommand(channelKeys, password, 1.0f));
        if (!sent) {
            ErrorDialog edb = new ErrorDialog((JDialog)this, "Mass Center send error");
            edb.setText("No connection to the NaqsServer host.", "Cannot send mass center command.", "", "Try again later.");
            edb.setVisible(true);
        }
    }

    public void subscribeTo(MsgProducer msgProducer) {
        if (this.producer != null) {
            this.producer.removeSubscriber(this);
        }
        this.producer = msgProducer;
        if (this.producer != null) {
            this.producer.addSubscriber(this);
        }
    }

    private void updateChannelInfo() {
        Enumeration e = this.getEntries();
        while (e.hasMoreElements()) {
            MassPositionTableRow entry = (MassPositionTableRow)e.nextElement();
            entry.resetChannelInfo();
        }
        e = this.calTable.elements();
        while (e.hasMoreElements()) {
            CalibrationInfo info = (CalibrationInfo)e.nextElement();
            int ID = info.getInstrumentID();
            int sohKey = ChannelKey.getKeyOf(2, 0, ID);
            MassPositionTableRow entry = (MassPositionTableRow)this.getEntry(sohKey);
            if (entry == null) continue;
            entry.addChannelInfo(info.getMassCenterEnable(), info.getSensorName());
        }
    }

    public void put(Packable pkt) {
        if (pkt instanceof CalibrationInfoTable) {
            this.calTable = (CalibrationInfoTable)pkt;
            this.updateChannelInfo();
        } else if (pkt instanceof MassCenterResult) {
            MassCenterResult result = (MassCenterResult)pkt;
            InfoDialog idb = new InfoDialog(this, false);
            idb.setTitle("Mass Centering Result");
            idb.setText("MassCenter result from NaqsServer:\n\n" + result.getMessage());
            idb.beep();
            idb.setVisible(true);
        }
    }

    protected boolean send(Packable pkt) {
        if (this.producer != null) {
            return this.producer.acceptRequest(pkt);
        }
        return false;
    }

    class MassCenterAction
    implements ActionListener {
        MassCenterAction() {
        }

        public void actionPerformed(ActionEvent event) {
            MassPositionViewer.this.invokeMassCenter();
        }
    }
}

