/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.JavaObjectTransferable;
import ca.nanometrics.uitools.table.TableNode;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.net.URL;
import javax.swing.JComponent;

public class NaqsNode
extends TableNode {
    protected String station;
    protected String channel;
    protected String instrument;
    private int bundleType = 0;
    private int[] bundleTypes = null;
    protected int readingIndex;
    protected String readingName;
    protected boolean old = false;

    public NaqsNode(String stn, String chan, String instr, String lbl, int bdlType, int[] bdlTypes) {
        this.station = stn;
        this.channel = chan;
        this.instrument = instr;
        this.bundleType = bdlType;
        this.setBundleTypes(bdlTypes);
        this.readingName = lbl;
    }

    public NaqsNode(String stn, String chan, String instr, String label) {
        this(stn, chan, instr, label, 0, null);
        this.setBundleTypes(null);
    }

    public NaqsNode(String stn, String chan, String instr, String label, int bdlType) {
        this(stn, chan, instr, label, bdlType, null);
        this.setBundleTypes(bdlType);
    }

    public NaqsNode() {
        this("", "", "", "");
    }

    private void setBundleTypes(int[] bdlTypes) {
        if (bdlTypes != null && bdlTypes.length > 0) {
            this.bundleTypes = bdlTypes;
        } else {
            this.setBundleTypes(0);
        }
    }

    private void setBundleTypes(int bdlType) {
        this.bundleTypes = new int[1];
        this.bundleTypes[0] = bdlType;
    }

    public String getStationName() {
        return this.station;
    }

    public String getChannelName() {
        return this.channel;
    }

    public String getName() {
        return String.valueOf(this.station) + "." + this.channel;
    }

    public String getInstrumentName() {
        return this.instrument;
    }

    public String getReadingName() {
        return this.readingName;
    }

    public int getReadingData() {
        return this.readingIndex;
    }

    protected int getBundleType() {
        return this.bundleType;
    }

    protected int[] getBundleTypes() {
        return this.bundleTypes;
    }

    public boolean bundleHandled(int type) {
        return type == this.bundleType;
    }

    public void setStationName(String stn) {
        this.station = stn;
    }

    public void setChannelName(String chan) {
        this.channel = chan;
    }

    public void setInstrumentName(String instr) {
        this.instrument = instr;
    }

    public void setReadingName(String rdgName) {
        this.readingName = rdgName;
    }

    public void setReadingDataIndex(int rdgIndex) {
        this.readingIndex = rdgIndex;
    }

    public void setBundleType(int bdlType) {
        this.bundleType = bdlType;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        DragSource dragSource = dge.getDragSource();
        if (dragSource != null) {
            JavaObjectTransferable trans = new JavaObjectTransferable(this);
            Image image = null;
            URL url = this.getClass().getResource("drag.GIF");
            if (url != null) {
                image = Toolkit.getDefaultToolkit().getImage(url);
            }
            Cursor cursor = image != null ? Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "mine") : Cursor.getPredefinedCursor(12);
            dragSource.startDrag(dge, cursor, trans, null);
        }
    }

    public void rightClick(JComponent showHere, int x, int y) {
    }

    public void setOld() {
        this.old = true;
    }

    public void setNew() {
        this.old = false;
    }

    public boolean isOld() {
        return this.old;
    }
}

