/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.uitools.NmxHelp;
import ca.nanometrics.uitools.StatusBar;
import ca.nanometrics.util.BrowserControl;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class NaqsView
extends NaqsViewAppDialog {
    static final String appName = "NaqsView";
    static final String appVersion = "NaqsView 2.10.02";
    static final String copyright = "Copyright (C) 1998-2007 Nanometrics, Inc.";
    NaqsViewSettings loadedSettings = null;
    File settingsFile = null;
    private String propFile = "NaqsView.properties";
    private SohViewer extSohViewer;
    private SohViewer instSohViewer;
    private SohViewer instGpsViewer;
    private SohViewer rm4SohViewer;
    private SohViewer modemSohViewer;
    protected MassPositionViewer massPositionViewer;
    protected CalibrationViewer calibrationViewer;
    private ListLog listLog = new ListLog();
    private NaqsViewReceiver receiver;
    private SohDispatcher sohDispatcher;
    protected ViewerTable viewers = new ViewerTable();
    private ViewerStateTable loadedViewerStateTable = null;
    protected TextViewer textViewer = null;
    protected SohDataSource dataServerSource;
    private ViewerResourceCache resourceCache;
    protected FileDialog openFileDialog;
    protected FileDialog saveFileDialog;
    private JMenu viewMenu;
    private JMenuBar menuBar;
    protected JFrame frame;
    private ConnectionPanel connPanel;
    public static StatusBar statusBar;
    private LogViewer logViewer = null;
    private String pdfReader = "";
    static /* synthetic */ Class class$0;

    public NaqsView(JFrame frame_) {
        super(frame_);
        Log.installLog(this.listLog);
        this.frame = frame_;
        this.frame.addWindowListener(new FrameListener());
        this.doLocate(false);
        this.openFileDialog = new FileDialog(this.frame);
        this.openFileDialog.setMode(0);
        this.openFileDialog.setTitle("Open");
        this.saveFileDialog = new FileDialog(this.frame);
        this.saveFileDialog.setMode(1);
        this.saveFileDialog.setTitle("Save As");
        this.setTitle(appName);
        this.setFont(new Font("Serif", 0, 12));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout(0, 0));
        JList jList = new JList(this.listLog.getLogList());
        this.logViewer = new LogViewer(jList, this.frame);
        NmxHelp.initialize(this, this.propFile, true);
        this.dataServerSource = new SohDataSource(this.frame);
        this.extSohViewer = this.createViewer(new ExternalSohTableRow(0, "STN"));
        this.instSohViewer = this.createViewer(new InstrumentSohTableRow(0, "STN"));
        this.instGpsViewer = this.createViewer(new InstrumentGpsTableRow(0, "STN"));
        this.rm4SohViewer = this.createViewer(new Rm4SohTableRow(0, "STN"));
        this.modemSohViewer = this.createViewer(new SatModemTableRow(0, "STN"));
        this.massPositionViewer = new MassPositionViewer(this.frame);
        this.setDefaultSizeAndLocation(this.massPositionViewer);
        this.viewers.add(this.massPositionViewer);
        this.calibrationViewer = new CalibrationViewer(this.frame);
        this.setDefaultSizeAndLocation(this.calibrationViewer);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowCloser());
        this.setJMenuBar(this.createMenuBar());
        this.sohDispatcher = new SohDispatcher();
        this.receiver = new NaqsViewReceiver();
        this.receiver.addSubscriber(this.sohDispatcher);
        JPanel panel = this.createControlPanel();
        content.add((Component)panel, "North");
        statusBar = new StatusBar(content, "South", 3, 0);
        this.massPositionViewer.subscribeTo(this.receiver);
        this.calibrationViewer.subscribeTo(this.receiver);
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            this.sohDispatcher.addSubscriber((SohViewer)e.nextElement());
        }
        this.resourceCache = new ViewerResourceCache();
        this.sohDispatcher.addSubscriber(this.resourceCache);
        this.receiver.start();
        this.sohDispatcher.start();
        this.setFrameVisible();
    }

    private JPanel createControlPanel() {
        this.connPanel = new ConnectionPanel(this.receiver, this.dataServerSource);
        this.connPanel.addPropertyChangeListener(new ConnectionChangeListener());
        return this.connPanel;
    }

    public static void setIcon(JFrame frame) {
        URL url;
        ImageIcon icon = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName(appName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = clazz.getResource("icon.GIF")) != null) {
            icon = new ImageIcon(url);
        }
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
        frame.setTitle(appName);
    }

    public void setSizeAndLocation() {
        int width = this.connPanel.getPreferredSize().width + 15;
        int height = this.connPanel.getPreferredSize().height;
        height += this.menuBar.getPreferredSize().height;
        this.setSize(width, height += NaqsView.statusBar.getStatusBar().getPreferredSize().height + 35);
        Dimension scr = this.getToolkit().getScreenSize();
        Rectangle bounds = new Rectangle(scr);
        int x = 0;
        int y = bounds.height - height - 25;
        this.setLocation(x, y);
    }

    public void setLogSizeAndLocation() {
        int width = 640;
        int height = this.getPreferredSize().height + 10;
        this.logViewer.setSize(width, height);
        Dimension scr = this.getToolkit().getScreenSize();
        Rectangle bounds = new Rectangle(scr);
        int x = this.getPreferredSize().width + 10;
        int y = bounds.height - height - 25;
        this.logViewer.setLocation(x, y);
    }

    private void setFrameVisible() {
        int x = -100;
        int y = -100;
        this.frame.setLocation(x, y);
        this.frame.setVisible(true);
    }

    protected SohViewer createViewer(SohTableRow sampleRow) {
        sampleRow.setDataSource(this.dataServerSource);
        StandardSohViewer viewer = new StandardSohViewer(sampleRow, this.frame);
        this.setDefaultSizeAndLocation(viewer);
        this.viewers.add(viewer);
        return viewer;
    }

    private void setDefaultSizeAndLocation(BasicViewer viewer) {
        viewer.setLocation(100, 100);
        viewer.pack();
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuBar.setBorder(BorderFactory.createEtchedBorder());
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menu.setName("File");
        JMenuItem mi = menu.add("Open...");
        mi.setMnemonic('O');
        mi.addActionListener(new OpenAction());
        mi = menu.add("Save");
        mi.setMnemonic('S');
        mi.addActionListener(new SaveAction());
        mi = menu.add("Save As...");
        mi.setMnemonic('A');
        mi.addActionListener(new SaveAsAction());
        menu.addSeparator();
        mi = menu.add("Restore Default Properties");
        mi.setMnemonic('C');
        mi.addActionListener(new RestoreDefaultAction());
        mi = menu.add("Reload Properties");
        mi.addActionListener(new ReloadPropertiesAction());
        menu.addSeparator();
        mi = menu.add("Exit");
        mi.setMnemonic('X');
        mi.addActionListener(new ExitAction());
        this.menuBar.add(menu);
        this.viewMenu = this.createViewMenu();
        this.menuBar.add(this.viewMenu);
        JMenu logMenu = this.listLog.getMenu();
        mi = logMenu.add("Show Log");
        mi.setMnemonic('S');
        mi.addActionListener(new ShowLogAction());
        this.menuBar.add(logMenu);
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        mi = menu.add("Help topics...");
        mi.addActionListener(new HelpAction());
        mi = menu.add("Change pdf Reader");
        mi.addActionListener(new ChangePdfReaderAction());
        menu.addSeparator();
        mi = menu.add("About NaqsView");
        mi.setMnemonic('A');
        mi.addActionListener(new AboutAction());
        this.menuBar.add(menu);
        return this.menuBar;
    }

    protected void updateViewMenu() {
        this.viewMenu.removeAll();
        this.createViewMenu();
    }

    private JMenu createViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu("View");
            this.viewMenu.setMnemonic('V');
        }
        this.viewMenu.add(new ViewAction(this.instSohViewer));
        this.viewMenu.add(new ViewAction(this.extSohViewer));
        this.viewMenu.add(new ViewAction(this.modemSohViewer));
        this.viewMenu.add(new ViewAction(this.rm4SohViewer));
        this.viewMenu.addSeparator();
        this.viewMenu.add(new ViewAction(this.instGpsViewer));
        this.viewMenu.addSeparator();
        this.viewMenu.add(new ViewAction(this.massPositionViewer));
        this.viewMenu.add(new ViewAction(this.calibrationViewer));
        this.viewMenu.addSeparator();
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            SohViewer viewer = (SohViewer)e.nextElement();
            SohTableRow prototype = viewer.getPrototype();
            if (!(prototype instanceof CustomSohTableRow)) continue;
            JMenu menu = new JMenu(viewer.getTitle());
            menu.add(new OpenCustomViewAction(viewer));
            menu.add(new CloseCustomViewAction(viewer));
            menu.add(new EditCustomViewAction(viewer));
            menu.add(new DeleteCustomViewAction(viewer));
            this.viewMenu.add(menu);
        }
        this.viewMenu.add(new CustomViewCreator());
        return this.viewMenu;
    }

    protected SohDataSource getDataSource() {
        return this.dataServerSource;
    }

    private ListLog getListLog() {
        return this.listLog;
    }

    private ConnectionPanel getConnectionPanel() {
        return this.connPanel;
    }

    protected NaqsViewSettings getNaqsViewSettings() {
        NaqsViewSettings settings = new NaqsViewSettings();
        this.getListLog().updateSettings(settings);
        this.getConnectionPanel().updateSettings(settings);
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            SohViewer viewer = (SohViewer)e.nextElement();
            viewer.updateSettings(settings);
        }
        HistoryViewer.updateSettings(settings);
        this.logViewer.updateSettings(settings);
        settings.setPdfReader(this.pdfReader);
        return settings;
    }

    public void saveSettings(File outputFile) {
        try {
            NaqsViewSettings settings = this.getNaqsViewSettings();
            ViewerStateTable viewerTable = this.getCurrentViewerState();
            FileOutputStream fos = new FileOutputStream(outputFile);
            ObjectOutputStream obs = new ObjectOutputStream(fos);
            obs.writeObject(settings);
            obs.writeObject(viewerTable);
            obs.flush();
            fos.close();
            this.settingsFile = outputFile;
            this.setTitle("NaqsView - " + this.settingsFile.getAbsolutePath());
            this.loadedSettings = settings;
            this.loadedViewerStateTable = viewerTable;
        }
        catch (IOException ioe) {
            this.displayErrorMessage("Save Settings", "Unable to save settings to file:\n" + outputFile.getAbsolutePath() + "\n\n" + ioe.getMessage());
        }
    }

    private boolean okToLoseSettings() {
        NaqsViewSettings settings = this.getNaqsViewSettings();
        if (this.loadedSettings == null || !settings.equals(this.loadedSettings) || this.loadedViewerStateTable == null || !this.loadedViewerStateTable.equals(this.getCurrentViewerState())) {
            SaveDialog sd = new SaveDialog(this.frame);
            if (this.settingsFile != null) {
                sd.setFile(this.settingsFile.getName());
            }
            sd.setVisible(true);
            if (sd.getResult() == 2) {
                this.miSave_Action();
                return settings.equals(this.loadedSettings);
            }
            return sd.getResult() == 1;
        }
        return true;
    }

    protected void closeWindow() {
        if (this.okToLoseSettings()) {
            this.receiver.stop();
            this.sohDispatcher.stop();
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    private void applySettings(NaqsViewSettings settings) throws Exception {
        statusBar.push(0, "Applying Settings");
        this.listLog.applySettings(settings);
        this.getConnectionPanel().applySettings(settings, true);
        this.dataServerSource.applySettings(settings);
        this.testDataServerSource();
        HistoryViewer.applySettings(settings);
        this.logViewer.applySettings(settings);
        this.pdfReader = settings.getPdfReader();
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            SohViewer viewer = (SohViewer)e.nextElement();
            viewer.applySettings(settings);
            viewer.setDataSource(this.dataServerSource);
        }
        if (settings.getViewNumber() > this.viewers.size()) {
            ViewSettingsTable table = settings.getViewSettingsTable();
            Enumeration enumeration = table.elements();
            while (enumeration.hasMoreElements()) {
                SohViewSettings viewSet = (SohViewSettings)enumeration.nextElement();
                if (!(viewSet instanceof CustomViewSettings)) continue;
                this.createCustomViewer((CustomViewSettings)viewSet);
            }
            this.updateViewMenu();
        }
        this.calibrationViewer.applySettings(settings);
        statusBar.pop(0);
    }

    public boolean loadSettings(File inputFile) {
        statusBar.push(0, "Loading Settings");
        if (!inputFile.exists()) {
            this.displayErrorMessage("Open Settings", "Unable to open settings file:\n" + inputFile.getAbsolutePath() + "\n\n  File not found.");
            statusBar.pop(0);
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(inputFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.loadedSettings = (NaqsViewSettings)ois.readObject();
            this.loadedViewerStateTable = (ViewerStateTable)ois.readObject();
            fis.close();
            this.applySettings(this.loadedSettings);
            this.settingsFile = inputFile;
            this.setTitle("NaqsView - " + this.settingsFile.getAbsolutePath());
            this.restoreViewerState(this.loadedViewerStateTable);
        }
        catch (Exception ioe) {
            this.displayErrorMessage("Open Settings", "Error reading settings file:\n" + inputFile.getAbsolutePath() + "\n" + ioe.toString());
            statusBar.pop(0);
            statusBar.pop(0);
            return false;
        }
        statusBar.pop(0);
        return true;
    }

    protected void miOpen_Action() {
        File inputFile;
        if (this.okToLoseSettings() && (inputFile = this.getOpenFileName()) != null) {
            this.loadSettings(inputFile);
        }
    }

    private File getOpenFileName() {
        String oldDirectory = this.openFileDialog.getDirectory();
        String oldFile = this.openFileDialog.getFile();
        this.openFileDialog.setVisible(true);
        String inputFileName = this.openFileDialog.getFile();
        if (inputFileName == null) {
            this.openFileDialog.setDirectory(oldDirectory);
            this.openFileDialog.setFile(oldFile);
            return null;
        }
        return new File(this.openFileDialog.getDirectory(), inputFileName);
    }

    protected void miSave_Action() {
        if (this.settingsFile == null) {
            this.miSaveAs_Action();
        } else {
            this.saveSettings(this.settingsFile);
        }
    }

    protected void miSaveAs_Action() {
        File outputFile = this.getSaveFileName();
        if (outputFile != null) {
            this.saveSettings(outputFile);
        }
    }

    protected void restoreDefaults() {
        InputStream inputStream = this.getClass().getResourceAsStream(this.propFile);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.propFile);
        }
        catch (FileNotFoundException fnfe) {
            ErrorDisplay.display("Unable to create file: " + this.propFile, "File Write Error");
            return;
        }
        try {
            int howMany;
            byte[] bytes = new byte[500];
            while ((howMany = inputStream.read(bytes, 0, 500)) >= 0) {
                outputStream.write(bytes, 0, howMany);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException ioe) {
            ErrorDisplay.display("Unable to write to file: " + this.propFile, "File Write Error");
            return;
        }
        this.reloadProperties();
    }

    protected void reloadProperties() {
        NmxHelp.initialize(this, this.propFile, true);
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            SohViewer viewer = (SohViewer)e.nextElement();
            viewer.updateProperties();
        }
        this.calibrationViewer.updateProperties();
    }

    public String getFileString(String fileName) throws IOException {
        String retVal = "";
        FileInputStream inputStream = new FileInputStream(fileName);
        byte[] bytes = new byte[500];
        int howMuch = 0;
        while ((howMuch = inputStream.read(bytes)) > 0) {
            retVal = String.valueOf(retVal) + new String(bytes, 0, howMuch);
        }
        inputStream.close();
        return retVal;
    }

    private File getSaveFileName() {
        String oldDirectory = this.saveFileDialog.getDirectory();
        String oldFile = this.saveFileDialog.getFile();
        if (this.settingsFile != null) {
            this.saveFileDialog.setFile(this.settingsFile.getAbsolutePath());
        }
        this.saveFileDialog.setVisible(true);
        String outputFileName = this.saveFileDialog.getFile();
        String outputDirectory = this.saveFileDialog.getDirectory();
        if (outputFileName == null) {
            this.saveFileDialog.setDirectory(oldDirectory);
            this.saveFileDialog.setFile(oldFile);
            return null;
        }
        return new File(outputDirectory, outputFileName);
    }

    protected void showAboutBox() {
        String[] message = new String[]{appVersion, copyright, "Displays Nanometrics Instrument State of Health"};
        JOptionPane.showMessageDialog(this, message, "About NaqsView", 1);
    }

    private void displayErrorMessage(String title, String message) {
        new ErrorDialog(this.frame, title, message).setVisible(true);
    }

    protected boolean changePdfReaderAction() {
        HelpViewerDialog dlog = new HelpViewerDialog(this, this.pdfReader);
        if (dlog.getFinalStatus()) {
            this.pdfReader = dlog.getExecPath();
            return true;
        }
        return false;
    }

    protected void helpAction() {
        int howMany;
        byte[] bytes;
        InputStream html = this.getClass().getResourceAsStream("NaqsViewIndex.html");
        InputStream pdf = this.getClass().getResourceAsStream("NaqsView_UserGuide.pdf");
        if (html == null || pdf == null) {
            JOptionPane.showMessageDialog(this, "Unable to access help files.  Refer to User Guide.", "No Online Help", 0);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream("NaqsViewIndex.html");
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, "Unable to access help files.  Refer to User Guide.", "No Online Help", 0);
            return;
        }
        try {
            bytes = new byte[500];
            while ((howMany = html.read(bytes, 0, 500)) >= 0) {
                outputStream.write(bytes, 0, howMany);
            }
            outputStream.close();
            html.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to access help files.  Refer to User Guide.", "No Online Help", 0);
            return;
        }
        outputStream = null;
        try {
            outputStream = new FileOutputStream("NaqsView_UserGuide.pdf");
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, "4) Unable to access help files.  Refer to User Guide.", "No Online Help", 0);
            return;
        }
        try {
            bytes = new byte[500];
            while ((howMany = pdf.read(bytes, 0, 500)) >= 0) {
                outputStream.write(bytes, 0, howMany);
            }
            outputStream.close();
            pdf.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to access help files.  Refer to User Guide.", "No Online Help", 0);
            return;
        }
        BrowserControl.displayURL("NaqsViewIndex.html");
    }

    protected void showLogWindow() {
        this.setLogSizeAndLocation();
        this.logViewer.setVisible(true);
    }

    public void dispose() {
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            SohViewer viewer = (SohViewer)e.nextElement();
            viewer.dispose();
        }
        this.calibrationViewer.dispose();
        super.dispose();
    }

    protected void restoreViewerState(ViewerStateTable vst) {
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            SohViewer viewer = (SohViewer)e.nextElement();
            vst.restoreViewerState(viewer);
        }
        vst.restoreViewerState(this.calibrationViewer);
        vst.restoreViewerState(this);
    }

    protected ViewerStateTable getCurrentViewerState() {
        ViewerStateTable vst = new ViewerStateTable();
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            vst.addViewerState((SohViewer)e.nextElement());
        }
        vst.addViewerState(this.calibrationViewer);
        vst.addViewerState(this);
        return vst;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        NaqsView.setIcon(frame);
        NaqsView nv = new NaqsView(frame);
        if (args.length > 0) {
            if (!nv.loadSettings(new File(args[0]))) {
                nv.setSizeAndLocation();
                nv.setLogSizeAndLocation();
            }
        } else {
            nv.setSizeAndLocation();
            nv.setLogSizeAndLocation();
        }
        nv.validate();
        nv.setVisible();
    }

    private SohViewer createCustomViewer(CustomViewSettings vStg) throws Exception {
        SohBundle bundle = SohBundleFactory.createBundle(vStg.getBundleType());
        if (bundle != null) {
            return this.createCustomViewer(bundle, vStg.getSelectedColumns(), vStg, 0);
        }
        return null;
    }

    protected SohViewer createCustomViewer(SohBundle bundle, ArrayList selectedColumns, CustomViewSettings vStg, int portNum) throws Exception {
        CustomViewSettings svs;
        if (vStg != null) {
            portNum = vStg.getPort();
        }
        CustomSohTableRow row = new CustomSohTableRow(0, "STN", bundle, selectedColumns, portNum);
        row.setDataSource(this.getDataSource());
        SohViewer viewer = this.getCustomViewerFromList(row);
        if (viewer != null) {
            viewer.updatePrototype(row);
            return viewer;
        }
        viewer = this.createCustomViewer(row);
        ChannelList list = null;
        list = this.resourceCache.getChannelList();
        viewer.setChannelList(list);
        if (vStg != null) {
            svs = vStg;
        } else {
            svs = new CustomViewSettings(bundle.getType(), selectedColumns, portNum);
            Iterator iter = selectedColumns.iterator();
            while (iter.hasNext()) {
                int index = (Integer)iter.next();
                String key = bundle.getReadingHeaderByIndex(index);
                svs.setThresholds(key, bundle.getThresholds(index));
                svs.setAllSelected(list, viewer.getPrototype());
            }
        }
        NaqsViewSettings settings = this.getNaqsViewSettings();
        settings.addViewSettings(viewer.getTitle(), svs);
        viewer.applySettings(settings);
        viewer.setDataSource(this.getDataSource());
        this.sohDispatcher.addSubscriber(viewer);
        this.viewers.add(viewer);
        this.updateViewMenu();
        viewer.getComponentState().setVisible(true);
        return viewer;
    }

    private SohViewer createCustomViewer(CustomSohTableRow sampleRow) {
        sampleRow.setDataSource(this.dataServerSource);
        CustomViewer viewer = new CustomViewer(sampleRow, this.frame);
        this.setDefaultSizeAndLocation(viewer);
        return viewer;
    }

    private SohViewer getCustomViewerFromList(SohTableRow row) {
        Enumeration e = this.viewers.elements();
        while (e.hasMoreElements()) {
            CustomSohTableRow cRow;
            SohBundleHandler handler = (SohBundleHandler)e.nextElement();
            SohTableRow prototype = handler.getPrototype();
            if (prototype == null || !(prototype instanceof CustomSohTableRow) || !(cRow = (CustomSohTableRow)prototype).equalsExceptSelectedColumns(row)) continue;
            return (SohViewer)handler;
        }
        return null;
    }

    public void setComponentState(ComponentState newState) {
        if (newState != null) {
            this.setBounds(newState.getBounds());
            this.setVisible(newState.isVisible());
        }
    }

    public ComponentState getComponentState() {
        ComponentState state = new ComponentState();
        state.setBounds(this.getBounds());
        state.setVisible(true);
        return state;
    }

    protected ArrayList retrieveActiveBundles() {
        statusBar.push("Retrieving Active Bundles...");
        ArrayList list = new ArrayList();
        long startTime = System.currentTimeMillis();
        long endTime = startTime + 5000L;
        while (startTime < endTime) {
            list = this.getActiveBundleList();
            if (list.size() > 0) break;
            startTime = System.currentTimeMillis();
        }
        statusBar.pop();
        return list;
    }

    private ArrayList getActiveBundleList() {
        ArrayList typeList = new ArrayList();
        Enumeration e = this.resourceCache.getActiveBundleTypes();
        while (e.hasMoreElements()) {
            typeList.add(e.nextElement());
        }
        ArrayList list = SohBundleFactory.getBundleList();
        ArrayList<SohBundle> currentList = new ArrayList<SohBundle>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            SohBundle bundle = (SohBundle)iter.next();
            if (!typeList.contains(new Integer(bundle.getType()))) continue;
            currentList.add(bundle);
        }
        return currentList;
    }

    protected void testDataServerSource() {
        try {
            this.dataServerSource.pingSource();
        }
        catch (IOException ioe) {
            String message = ioe.getMessage().indexOf("Connection refused") >= 0 ? "DataServer Unavailable; Error: Connection Refused; check DataServer Parameters." : "DataServer Unavailable; Error: " + ioe.getMessage();
            Log.report(this, 1, 3, message);
            return;
        }
        catch (IllegalArgumentException iae) {
            Log.report(this, 2, 3, "Failed to connect to DataServer; Error: Port Number: " + this.dataServerSource.getPort() + " out of range");
            return;
        }
        Log.report(this, 1, 2, "Connected to Dataserver.");
    }

    private class AboutAction
    implements ActionListener {
        private AboutAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.showAboutBox();
        }
    }

    private class ChangePdfReaderAction
    implements ActionListener {
        private ChangePdfReaderAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            NaqsView.this.changePdfReaderAction();
        }
    }

    public class CloseCustomViewAction
    extends AbstractAction {
        private JDialog frame;

        public CloseCustomViewAction(JDialog jframe) {
            super("Hide");
            this.frame = jframe;
        }

        public void actionPerformed(ActionEvent e) {
            this.frame.setVisible(false);
        }
    }

    public class ConnectionChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Object objNew = evt.getNewValue();
            Object objOld = evt.getOldValue();
            if (objNew instanceof ConnectionSettings) {
                ConnectionSettings newSettings = (ConnectionSettings)objNew;
                ConnectionSettings oldSettings = (ConnectionSettings)objOld;
                NaqsViewSettings settings = NaqsView.this.getNaqsViewSettings();
                ConnectionSettings currSettings = settings.getConnectionSettings();
                currSettings.applySettings(newSettings);
                NaqsView.this.dataServerSource.applySettings(settings);
                if (currSettings.isConnect()) {
                    NaqsView.this.testDataServerSource();
                } else {
                    Log.report(this, 1, 2, "Disconnected from Dataserver.");
                }
                if (newSettings.isConnect() && newSettings.equalsNaqsServerSettings(oldSettings) && newSettings.isConnect() == oldSettings.isConnect()) {
                    return;
                }
                Enumeration e = NaqsView.this.viewers.elements();
                while (e.hasMoreElements()) {
                    SohViewer viewer = (SohViewer)e.nextElement();
                    viewer.setChannelList(new ChannelList());
                }
                NaqsView.this.massPositionViewer.setChannelList(new ChannelList());
                NaqsView.this.calibrationViewer.put(new CalibrationInfoTable());
            }
        }
    }

    private class CustomViewCreator
    extends AbstractAction {
        public CustomViewCreator() {
            super("Custom");
        }

        public void actionPerformed(ActionEvent e) {
            ArrayList list = NaqsView.this.retrieveActiveBundles();
            CustomViewDialog dlog = new CustomViewDialog(list);
            if (dlog.getSuccess()) {
                try {
                    SohViewer viewer = NaqsView.this.createCustomViewer(dlog.getSelectedBundle(), dlog.getSelectedColumns(), null, dlog.getPort());
                    viewer.setVisible(true);
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(NaqsView.this, "No Channel List Available.");
                }
            }
        }
    }

    public class DeleteCustomViewAction
    extends AbstractAction {
        private SohViewer viewer;

        public DeleteCustomViewAction(SohViewer aViewer) {
            super("Delete");
            this.viewer = aViewer;
        }

        public void actionPerformed(ActionEvent e) {
            this.viewer.setVisible(false);
            NaqsView.this.viewers.remove(this.viewer);
            NaqsView.this.updateViewMenu();
        }
    }

    public class EditCustomViewAction
    extends AbstractAction {
        private SohViewer viewer;

        public EditCustomViewAction(SohViewer aViewer) {
            super("Edit");
            this.viewer = aViewer;
        }

        public void actionPerformed(ActionEvent e) {
            ArrayList list = NaqsView.this.retrieveActiveBundles();
            CustomSohTableRow row = (CustomSohTableRow)this.viewer.getPrototype();
            CustomViewDialog dlog = new CustomViewDialog(list, this.viewer.getTitle(), row.getSelectedColumns());
            if (!dlog.getSuccess() && !dlog.cancelled()) {
                JOptionPane.showMessageDialog(NaqsView.this, "Dialog Failed to Edit Custom Viewer.", "Dialog Failure", 2);
                return;
            }
            row = new CustomSohTableRow(0, "STN", dlog.getSelectedBundle(), dlog.getSelectedColumns(), dlog.getPort());
            row.setDataSource(NaqsView.this.getDataSource());
            this.viewer.updatePrototype(row);
        }
    }

    private class ExitAction
    implements ActionListener {
        private ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.closeWindow();
        }
    }

    public class FrameListener
    implements WindowListener {
        Vector visibleViewers;

        public void windowOpened(WindowEvent e) {
            NaqsView.this.setVisible(true);
            NaqsView.this.toFront();
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
            this.visibleViewers = new Vector();
            Enumeration enumeration = NaqsView.this.viewers.elements();
            while (enumeration.hasMoreElements()) {
                SohViewer viewer = (SohViewer)enumeration.nextElement();
                if (viewer.isVisible()) {
                    this.visibleViewers.add(viewer);
                }
                viewer.setVisible(false);
            }
            NaqsView.this.setVisible(false);
        }

        public void windowDeiconified(WindowEvent e) {
            Enumeration enumeration = this.visibleViewers.elements();
            while (enumeration.hasMoreElements()) {
                SohViewer viewer = (SohViewer)enumeration.nextElement();
                viewer.setVisible();
            }
            NaqsView.this.setVisible();
        }

        public void windowActivated(WindowEvent e) {
            if (!NaqsView.this.saveFileDialog.isVisible() && !NaqsView.this.openFileDialog.isVisible()) {
                NaqsView.this.setVisible(true);
                NaqsView.this.toFront();
            }
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }

    private class HelpAction
    implements ActionListener {
        private HelpAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            NaqsView.this.helpAction();
        }
    }

    private class OpenAction
    implements ActionListener {
        private OpenAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.miOpen_Action();
        }
    }

    public class OpenCustomViewAction
    extends AbstractAction {
        private JDialog frame;

        public OpenCustomViewAction(JDialog jframe) {
            super("Show");
            this.frame = jframe;
        }

        public void actionPerformed(ActionEvent e) {
            this.frame.setVisible(true);
        }
    }

    private class ReloadPropertiesAction
    implements ActionListener {
        private ReloadPropertiesAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.reloadProperties();
        }
    }

    private class RestoreDefaultAction
    implements ActionListener {
        private RestoreDefaultAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.restoreDefaults();
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.miSave_Action();
        }
    }

    private class SaveAsAction
    implements ActionListener {
        private SaveAsAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.miSaveAs_Action();
        }
    }

    private class ShowLogAction
    implements ActionListener {
        private ShowLogAction() {
        }

        public void actionPerformed(ActionEvent e) {
            NaqsView.this.showLogWindow();
        }
    }

    class WindowCloser
    extends WindowAdapter {
        WindowCloser() {
        }

        public void windowClosing(WindowEvent event) {
            NaqsView.this.closeWindow();
        }
    }
}

