/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.vmodel.BooleanModel;
import ca.nanometrics.vmodel.DoubleModel;
import ca.nanometrics.vmodel.IntegerModel;
import ca.nanometrics.vmodel.StringModel;
import java.io.Serializable;

public class PlotSettings
implements Serializable {
    private BooleanModel scroll;
    private DoubleModel startTime;
    private DoubleModel duration;
    private StringModel units;
    private BooleanModel mostRecent;
    private BooleanModel singleHistory;
    private IntegerModel showThreshold;
    private BooleanModel firstDifferences;

    public PlotSettings() {
        this.scroll = new BooleanModel(true);
        this.startTime = new DoubleModel(0.0);
        this.duration = new DoubleModel(0.0);
        this.units = new StringModel("seconds");
        this.mostRecent = new BooleanModel(false);
        this.singleHistory = new BooleanModel(true);
        this.showThreshold = new IntegerModel(0);
        this.firstDifferences = new BooleanModel(false);
    }

    public PlotSettings(boolean toScroll, double start, double dur, String unitStr, boolean recent, boolean single, int threshold, boolean doFirstDiff) {
        this.scroll = new BooleanModel(toScroll);
        this.startTime = new DoubleModel(start);
        this.duration = new DoubleModel(dur);
        this.units = new StringModel(unitStr);
        this.mostRecent = new BooleanModel(recent);
        this.singleHistory = new BooleanModel(single);
        this.showThreshold = new IntegerModel(threshold);
        this.firstDifferences = new BooleanModel(doFirstDiff);
    }

    public PlotSettings(PlotSettings settings) {
        this(settings.scroll(), settings.getStartTime(), settings.getDuration(), settings.getUnitString(), settings.getMostRecent(), settings.getSingleHistory(), settings.getShowThreshold(), settings.getDoFirstDifferences());
    }

    public void applySettings(PlotSettings settings) {
        this.setScroll(settings.scroll());
        this.setStartTime(settings.getStartTime());
        this.setDuration(settings.getDuration());
        this.setUnitsString(settings.getUnitString());
        this.setMostRecent(settings.getMostRecent());
        this.setSingleHistory(settings.getSingleHistory());
        this.setShowThreshold(settings.getShowThreshold());
        this.setDoFirstDifferences(settings.getDoFirstDifferences());
    }

    public boolean equals(Object that) {
        if (that instanceof PlotSettings) {
            PlotSettings settings = (PlotSettings)that;
            if (!(this.scroll.equals(settings.scroll) && this.mostRecent.equals(settings.mostRecent) && this.singleHistory.equals(settings.singleHistory) && this.units.equals(settings.units) && this.showThreshold.equals(settings.showThreshold) && this.firstDifferences.equals(settings.firstDifferences))) {
                return false;
            }
            return !(this.getMostRecent() ? !this.duration.equals(settings.duration) : !this.startTime.equals(settings.startTime));
        }
        return false;
    }

    public IntegerModel getShowThresholdModel() {
        return this.showThreshold;
    }

    public BooleanModel getScrollModel() {
        return this.scroll;
    }

    public DoubleModel getStartTimeModel() {
        return this.startTime;
    }

    public DoubleModel getDurationModel() {
        return this.duration;
    }

    public StringModel getUnitsModel() {
        return this.units;
    }

    public BooleanModel getMostRecentModel() {
        return this.mostRecent;
    }

    public BooleanModel getSingleHistoryModel() {
        return this.singleHistory;
    }

    public BooleanModel getFirstDifferencesModel() {
        return this.firstDifferences;
    }

    public int getShowThreshold() {
        return this.showThreshold.getValue();
    }

    public boolean scroll() {
        return this.scroll.getValue();
    }

    public double getStartTime() {
        return this.startTime.getValue();
    }

    public double getDuration() {
        return this.duration.getValue();
    }

    public String getUnitString() {
        return this.units.getValue();
    }

    public boolean getMostRecent() {
        return this.mostRecent.getValue();
    }

    public boolean getSingleHistory() {
        return this.singleHistory.getValue();
    }

    public boolean getDoFirstDifferences() {
        return this.firstDifferences.getValue();
    }

    public void setShowThreshold(int val) {
        this.showThreshold.setValue(val);
    }

    public void setScroll(boolean scrl) {
        this.scroll.setValue(scrl);
    }

    public void setStartTime(double time) {
        this.startTime.setValue(time);
    }

    public void setDuration(double time) {
        this.duration.setValue(time);
    }

    public void setUnitsString(String unitsString) {
        this.units.setValue(unitsString);
    }

    public void setMostRecent(boolean recent) {
        this.mostRecent.setValue(recent);
    }

    public void setSingleHistory(boolean single) {
        this.singleHistory.setValue(single);
    }

    public void setDoFirstDifferences(boolean firstDiff) {
        this.firstDifferences.setValue(firstDiff);
    }
}

