/*
 * Decompiled with CFR 0.152.
 */
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class SingleVariablePlot
extends HistoryPanel {
    Vector plotDatas;
    ChartDataSource source;

    public SingleVariablePlot(Vector somePlotDatas, double startTime, double endTime, int choice, boolean doFirstDiff) {
        super(startTime, endTime, ((PlotData)somePlotDatas.get(0)).getVariableName(), choice, doFirstDiff);
        this.plotDatas = somePlotDatas;
        if (!this.createChart()) {
            this.setIsPlot(false);
            String staList = this.getStationList();
            JTextArea area = new JTextArea("No Data To Plot for stations:\n" + staList);
            area.setForeground(Color.red);
            area.setBackground(Color.white);
            area.setEditable(false);
            this.add(area);
            int numLines = 2;
            String a = staList.substring(staList.indexOf("\n") + 1);
            while (a.indexOf("\n") >= 0) {
                a = a.substring(staList.indexOf("\n") + 1);
                ++numLines;
            }
            this.setPreferredSize(new Dimension(500, numLines * 30 + 30));
            this.setSuccess(false);
        }
    }

    private String getStationList() {
        String retStr = "";
        Iterator iter = this.plotDatas.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            if (retStr.length() > 0) {
                retStr = String.valueOf(retStr) + ",\n";
            }
            retStr = String.valueOf(retStr) + data.getNode().getName();
            retStr = data.getVariableName() == null || data.getVariableName().trim() == "" ? String.valueOf(retStr) : String.valueOf(retStr) + "." + data.getVariableName();
        }
        return retStr;
    }

    private String getSuitablePlotName() {
        Iterator iter = this.plotDatas.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            if (data.getVariableName() == null || data.getVariableName().length() <= 0) continue;
            return data.getVariableName();
        }
        return "";
    }

    protected boolean createChart() {
        this.chart = new JCChart();
        if (this.getPlotName() == null || this.getPlotName() == "") {
            this.setPlotName(this.getSuitablePlotName());
            if (this.getPlotName() == null || this.getPlotName() == "") {
                return false;
            }
        }
        this.source = new ChartDataSource();
        if (this.plotDatas == null || this.plotDatas.size() == 0) {
            return false;
        }
        Collections.sort(this.plotDatas);
        PlotData data = null;
        if (!this.firstDiff) {
            data = (PlotData)this.plotDatas.get(0);
            this.source.setThresholds(data);
        }
        Iterator iter = this.plotDatas.iterator();
        while (iter.hasNext()) {
            double[] x;
            double[] y;
            data = (PlotData)iter.next();
            if (data == null || (y = this.getDataSeries(data)) == null || (x = this.getTimeSeries(data)) == null) continue;
            try {
                this.source.addSeries(x, y, data.getNode().getName(), data.getColor(), data.getNode().getPrecision());
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.source.getRealNumSeries() <= 0) {
            return false;
        }
        this.chart.getDataView(0).setDataSource((ChartDataModel)this.source);
        this.chart.getDataView(0).setHoleValue(this.source.getHoleValue());
        JCChartArea chartArea = this.chart.getChartArea();
        JCAxis xAxis = chartArea.getXAxis(0);
        xAxis.setMin(this.source.getMinXValue());
        xAxis.setMax(this.source.getMaxXValue());
        xAxis.setLabelGenerator((JCLabelGenerator)new ChartTimeLabelGenerator("Md_HH:mm:ss"));
        String titleStr = this.getDate(this.source.getMinXValue(), this.source.getMaxXValue());
        if (this.firstDiff) {
            titleStr = "First Difference " + titleStr;
        }
        JCAxisTitle xAxisTitle = new JCAxisTitle(titleStr);
        xAxisTitle.setPlacement(32);
        xAxis.setTitle(xAxisTitle);
        JCAxis yAxis = chartArea.getYAxis(0);
        yAxis.setPlacement(1);
        yAxis.setPrecision(data.getPrecision());
        HistoryPanel.MinMaxCalculator calc = new HistoryPanel.MinMaxCalculator(this.source.getMinYValue(), this.source.getMaxYValue(), this.source.getPrecision());
        yAxis.setMin(calc.getMinValue());
        yAxis.setMax(calc.getMaxValue());
        yAxis.setOriginPlacement(3);
        String title = "";
        int i = 0;
        while (i < this.source.getRealNumSeries()) {
            ChartDataViewSeries series = this.chart.getDataView(0).getSeries(i);
            JCChartStyle oldStyle = series.getStyle();
            Color color = this.source.getColor(i);
            if (color == null) {
                color = Color.black;
            }
            String str = this.getColorString(color);
            String dataTag = this.source.getDataTag(i);
            title = String.valueOf(title) + " " + "<font color=" + str + ">" + dataTag + "</font>";
            JCLineStyle line = new JCLineStyle(1, color, 1);
            JCChartStyle style = new JCChartStyle(line, oldStyle.getFillStyle(), new JCSymbolStyle(0, null, 0));
            series.setStyle(style);
            ++i;
        }
        this.setRangeAppearances(this.source);
        if (data != null) {
            JCAxisTitle axisTitle = new JCAxisTitle(data.getVariableName());
            axisTitle.setRotation(3);
            axisTitle.setPlacement(2);
            yAxis.setTitle(axisTitle);
        }
        String header = "<html>";
        if (data != null) {
            header = String.valueOf(header) + this.getPlotName();
        }
        header = String.valueOf(header) + " for " + title + "</html>";
        JLabel label = (JLabel)this.chart.getHeader();
        label.setText(header);
        this.chart.getHeader().setVisible(true);
        this.chart.setBackground(Color.white);
        this.chart.setAllowUserChanges(true);
        this.chart.setTrigger(0, new EventTrigger(1, 6));
        this.chart.setPreferredSize(new Dimension(500, 200));
        this.chart.addMouseListener((MouseListener)new HistoryPanel.ChartMouseListener());
        this.add((Component)this.chart, "Center");
        return true;
    }

    private void setRangeAppearances(ChartDataSource source) {
        if (this.firstDiff) {
            return;
        }
        if (this.getThresholdChoice() == HistoryViewer.NO_THRESHOLDS) {
            return;
        }
        int index = source.getRealNumSeries();
        ChartDataViewSeries series = this.chart.getDataView(0).getSeries(index);
        JCLineStyle line = new JCLineStyle(1, Color.red, 2);
        JCChartStyle style = new JCChartStyle(line, new JCFillStyle(Color.red, 0), new JCSymbolStyle(2, null, 0));
        series.setStyle(style);
        series = this.chart.getDataView(0).getSeries(++index);
        line = new JCLineStyle(1, Color.green, 2);
        style = new JCChartStyle(line, new JCFillStyle(Color.green, 0), new JCSymbolStyle(9, null, 0));
        series.setStyle(style);
        series = this.chart.getDataView(0).getSeries(++index);
        line = new JCLineStyle(1, Color.green, 2);
        style = new JCChartStyle(line, new JCFillStyle(Color.green, 0), new JCSymbolStyle(3, null, 0));
        series.setStyle(style);
        series = this.chart.getDataView(0).getSeries(++index);
        line = new JCLineStyle(1, Color.red, 2);
        style = new JCChartStyle(line, new JCFillStyle(Color.red, 0), new JCSymbolStyle(4, null, 0));
        series.setStyle(style);
    }

    public Vector getData() {
        return this.plotDatas;
    }

    public void saveData(String dirName) {
        Vector pData = this.getData();
        Iterator iter = pData.iterator();
        while (iter.hasNext()) {
            PlotData data = (PlotData)iter.next();
            this.saveData(data.getNode(), dirName);
        }
    }

    class ChartDataSource
    implements ChartDataModel,
    HoleValueChartDataModel {
        private ArrayList ySeries = new ArrayList();
        private ArrayList xSeries = new ArrayList();
        private ArrayList dataTags = new ArrayList();
        private ArrayList colors = new ArrayList();
        private double[] tx;
        private double[] t1;
        private double[] t2;
        private double[] t3;
        private double[] t4;
        private double maxVal = -1.7976931348623157E308;
        private double minVal = Double.MAX_VALUE;
        private double minXVal = Double.MAX_VALUE;
        private double maxXVal = -1.7976931348623157E308;
        private int prec = 0;

        ChartDataSource() {
        }

        public void setThresholds(PlotData data) {
            this.t1 = new double[2];
            this.t2 = new double[2];
            this.t3 = new double[2];
            this.t4 = new double[2];
            int i = 0;
            while (i < 2) {
                this.t1[i] = data.getNode().getThreshold1();
                this.t2[i] = data.getNode().getThreshold2();
                this.t3[i] = data.getNode().getThreshold3();
                this.t4[i] = data.getNode().getThreshold4();
                ++i;
            }
            this.tx = new double[2];
            this.tx[0] = SingleVariablePlot.this.startTime;
            this.tx[1] = SingleVariablePlot.this.endTime;
        }

        public int getNumSeries() {
            if (SingleVariablePlot.this.getThresholdChoice() == HistoryViewer.NO_THRESHOLDS || SingleVariablePlot.this.firstDiff) {
                return this.ySeries.size();
            }
            return this.ySeries.size() + 4;
        }

        public int getRealNumSeries() {
            return this.ySeries.size();
        }

        public String getDataTag(int param) {
            if (this.dataTags.size() > param) {
                return (String)this.dataTags.get(param);
            }
            return null;
        }

        public Color getColor(int param) {
            if (this.colors.size() > param) {
                return (Color)this.colors.get(param);
            }
            return null;
        }

        private double[] getXThresholdSeries(int param) {
            if (this.ySeries.size() + 4 <= param) {
                return null;
            }
            return this.tx;
        }

        public double[] getXSeries(int param) {
            if (this.xSeries.size() <= param) {
                return this.getXThresholdSeries(param);
            }
            ArrayList series = (ArrayList)this.xSeries.get(param);
            double[] x = new double[series.size()];
            int i = 0;
            while (i < series.size()) {
                Double val = (Double)series.get(i);
                x[i] = val;
                ++i;
            }
            return x;
        }

        private double[] getYThresholdSeries(int param) {
            if (this.ySeries.size() + 4 <= param) {
                return null;
            }
            int index = param - this.ySeries.size();
            switch (index) {
                case 0: {
                    return this.t1;
                }
                case 1: {
                    return this.t2;
                }
                case 2: {
                    return this.t3;
                }
                case 3: {
                    return this.t4;
                }
            }
            return null;
        }

        public double[] getYSeries(int param) {
            if (this.ySeries.size() <= param) {
                return this.getYThresholdSeries(param);
            }
            ArrayList series = (ArrayList)this.ySeries.get(param);
            double[] y = new double[series.size()];
            int i = 0;
            while (i < series.size()) {
                Double val = (Double)series.get(i);
                y[i] = val;
                ++i;
            }
            return y;
        }

        public void addSeries(double[] x, double[] y, String tag, Color color, int precision) throws Exception {
            if (x.length != y.length) {
                throw new Exception("Combined History Panel.  Series are different lengths");
            }
            ArrayList<Double> yList = new ArrayList<Double>();
            ArrayList<Double> xList = new ArrayList<Double>();
            int currInt = x.length < 4 ? -1 : (int)Math.abs(x[0] - x[1]);
            int i = 0;
            while (i < y.length) {
                this.setMinMax(y[i], x[i]);
                if (currInt > 0 && i < y.length - 1) {
                    int newInt = (int)Math.abs(x[i] - x[i + 1]);
                    if ((double)newInt > (double)currInt * 1.2 || (double)newInt < (double)currInt * 0.8) {
                        Double lastY = (Double)yList.get(xList.size() - 1);
                        yList.add(new Double(y[i]));
                        xList.add(new Double(x[i]));
                        if (lastY.doubleValue() != this.getHoleValue()) {
                            xList.add(new Double(x[i] + (x[i + 1] - x[i]) / 2.0));
                            yList.add(new Double(this.getHoleValue()));
                        }
                        currInt = newInt;
                    } else {
                        yList.add(new Double(y[i]));
                        xList.add(new Double(x[i]));
                    }
                } else {
                    yList.add(new Double(y[i]));
                    xList.add(new Double(x[i]));
                }
                ++i;
            }
            this.ySeries.add(yList);
            this.xSeries.add(xList);
            this.dataTags.add(tag);
            this.colors.add(color);
            if (this.prec < precision) {
                this.prec = precision;
            }
        }

        private void setMinMax(double y, double x) {
            if (this.minXVal > x) {
                this.minXVal = x;
            }
            if (this.maxXVal < x) {
                this.maxXVal = x;
            }
            if (y == this.getHoleValue()) {
                return;
            }
            if (y > this.maxVal) {
                this.maxVal = y;
            }
            if (y < this.minVal) {
                this.minVal = y;
            }
        }

        public double getMinXValue() {
            return this.minXVal;
        }

        public double getMaxXValue() {
            return this.maxXVal;
        }

        public double getMinYValue() {
            if (SingleVariablePlot.this.firstDiff) {
                return this.minVal;
            }
            if (SingleVariablePlot.this.getThresholdChoice() == HistoryViewer.DEFAULT_THRESHOLDS) {
                if (this.minVal > this.t2[0]) {
                    return this.t2[0];
                }
            } else if (SingleVariablePlot.this.getThresholdChoice() == HistoryViewer.ALL_THRESHOLDS && this.minVal > this.t1[0]) {
                return this.t1[0];
            }
            return this.minVal;
        }

        public double getMaxYValue() {
            if (SingleVariablePlot.this.firstDiff) {
                return this.maxVal;
            }
            if (SingleVariablePlot.this.getThresholdChoice() == HistoryViewer.DEFAULT_THRESHOLDS) {
                if (this.maxVal < this.t3[0]) {
                    return this.t3[0];
                }
            } else if (SingleVariablePlot.this.getThresholdChoice() == HistoryViewer.ALL_THRESHOLDS && this.maxVal < this.t4[0]) {
                return this.t4[0];
            }
            return this.maxVal;
        }

        public int getPrecision() {
            return this.prec;
        }

        public double getHoleValue() {
            return Double.MAX_VALUE;
        }
    }
}

