/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.bundle.SohDataSaver;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.KeyedChannel;
import ca.nanometrics.nda.ChannelPrecis;
import ca.nanometrics.nda.PacketConsumer;
import ca.nanometrics.nda.PrecisList;
import ca.nanometrics.nda.TcpDataSource;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.SohPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;

public class SohDataSource
implements Observer {
    protected TcpDataSource source = null;
    private String host = "localhost";
    private int port = 28002;
    private String userName = "";
    private String password = "";
    private ArrayList nodeData = new ArrayList();
    protected JFrame frame;

    public SohDataSource(JFrame f) {
        SohBundleFactory.init();
        this.frame = f;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = "localhost";
        }
        return this.host;
    }

    public int getPort() {
        if (this.port == 0) {
            return 28002;
        }
        return this.port;
    }

    public String getUserName() {
        if (this.userName == null) {
            return "";
        }
        return this.userName;
    }

    public String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public void applySettings(NaqsViewSettings naqsSettings) {
        ConnectionSettings settings = naqsSettings.getConnectionSettings();
        this.setHost(settings.getDataServerHost());
        this.setPort(settings.getDataServerPort());
        this.setUserName(settings.getUserName());
        this.setPassword(settings.getPassword());
    }

    private void setSourceNull() {
        if (this.source == null) {
            return;
        }
        this.source.close();
        this.source = null;
    }

    public void setHost(String aHost) {
        if (!this.equalStrings(this.host, aHost)) {
            this.host = aHost;
            this.setSourceNull();
        }
    }

    public void setPort(int aPort) {
        if (this.port != aPort) {
            this.port = aPort;
            this.setSourceNull();
        }
    }

    public void setUserName(String aUser) {
        if (!this.equalStrings(this.userName, aUser)) {
            this.userName = aUser;
            this.setSourceNull();
        }
    }

    public void setPassword(String aPassword) {
        if (!this.equalStrings(this.password, aPassword)) {
            this.password = aPassword;
            this.setSourceNull();
        }
    }

    public void setSourceParameters(String host, int port, String userName, String password) {
        this.setHost(host);
        this.setPort(port);
        this.setUserName(userName);
        this.setPassword(password);
    }

    private boolean equalStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.equals(s2);
    }

    private void setSource() {
        if (this.source == null) {
            this.source = new TcpDataSource(this.getHost(), this.getPort(), this.getUserName(), this.getPassword());
        }
    }

    public void pingSource() throws IOException {
        this.setSource();
        this.source.getChannelList();
    }

    protected void updateConnection(DoubleNode node) {
        this.setHost(node.getHost());
        this.setPort(node.getPort());
        this.setUserName(node.getUserName());
        this.setPassword(node.getPassword());
    }

    public String toString() {
        return String.valueOf(this.getHost()) + this.getUserName();
    }

    public ChannelList getChannelList() throws IOException {
        ChannelList list = this.source.getChannelList();
        return list;
    }

    public void dispose() {
        if (this.source != null) {
            this.source.finalize();
        }
    }

    public double[] getDataSeries(DoubleNode node, double startTime, double endTime) throws IOException {
        return this.getNodeData(node, startTime, endTime).getDataArray();
    }

    public double[] getTimeSeries(DoubleNode node, double startTime, double endTime) throws IOException {
        return this.getNodeData(node, startTime, endTime).getTimeArray();
    }

    public boolean saveData(DoubleNode node, double startTime, double endTime, String dirName) throws IOException {
        return this.getNodeData(node, startTime, endTime).saveData(dirName);
    }

    public double getMinDataServerTime(DoubleNode node) throws IOException {
        if (node.getBundleType() == 0) {
            return 0.0;
        }
        NodeData data = this.getNodeData(node);
        ChannelPrecis precis = data.getPrecis();
        this.nodeData.remove(data);
        if (precis == null) {
            return 0.0;
        }
        int sTime = precis.getStartTime();
        return sTime;
    }

    public double getMaxDataServerTime(DoubleNode node) throws IOException {
        NodeData data = this.getNodeData(node);
        ChannelPrecis precis = data.getPrecis();
        this.nodeData.remove(data);
        if (precis == null) {
            return 0.0;
        }
        return precis.getEndTime();
    }

    private NodeData getNodeData(DoubleNode node) {
        return this.getNodeData(node, 0.0, 0.0);
    }

    private NodeData getNodeData(DoubleNode node, double startTime, double endTime) {
        NodeData data;
        Iterator iter = this.nodeData.iterator();
        while (iter.hasNext()) {
            data = (NodeData)iter.next();
            if (!data.isSameNode(node)) continue;
            data.resetTimes(startTime, endTime);
            return data;
        }
        data = new NodeData(node, startTime, endTime);
        this.nodeData.add(data);
        return data;
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ConnectionSettings) {
            this.setSourceNull();
        }
    }

    public void updateSettings(NaqsViewSettings naqsSettings) {
        ConnectionSettings settings = naqsSettings.getConnectionSettings();
        settings.setDataServerHost(this.getHost());
        settings.setDataServerPort(this.getPort());
        settings.setPassword(this.getPassword());
        settings.setUserName(this.getUserName());
    }

    class NodeData {
        ArrayList savedPackets = null;
        double startTime;
        double endTime;
        double[] timeArray = null;
        double[] valueArray = null;
        Vector times = new Vector();
        Vector values = new Vector();
        DoubleNode node;
        boolean refresh = true;

        public NodeData(DoubleNode node, double startTime, double endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.node = node;
        }

        protected void resetTimes(double startTime_, double endTime_) {
            if (Math.abs(startTime_ - this.startTime) < 0.9 && Math.abs(endTime_ - this.endTime) < 0.9) {
                return;
            }
            this.savedPackets = null;
            this.startTime = startTime_;
            this.endTime = endTime_;
            this.refresh = true;
        }

        protected boolean isSameNode(DoubleNode newNode) {
            return this.node == newNode;
        }

        protected double[] getTimeArray() throws IOException {
            if (this.refresh) {
                ArrayList packets = this.retrievePackets();
                this.refresh = this.processPacketsForPlotting(packets);
            }
            return this.timeArray;
        }

        protected double[] getDataArray() throws IOException {
            if (this.refresh) {
                ArrayList packets = this.retrievePackets();
                this.refresh = this.processPacketsForPlotting(packets);
            }
            return this.valueArray;
        }

        private void clearVectors() {
            this.times.removeAllElements();
            this.values.removeAllElements();
        }

        protected boolean saveData(String dirName) throws IOException {
            ArrayList packets;
            String nodeFileName = this.node.getName();
            if (nodeFileName.indexOf(".") > 0) {
                nodeFileName = "R" + nodeFileName.substring(0, nodeFileName.indexOf("."));
            }
            if ((packets = this.retrievePackets()) == null && packets.size() == 0) {
                return false;
            }
            Iterator iter = packets.iterator();
            SohDataSaver saver = new SohDataSaver(dirName, nodeFileName, (long)Math.floor(this.startTime), (long)Math.ceil(this.endTime));
            while (iter.hasNext()) {
                SohPacket packet = (SohPacket)iter.next();
                try {
                    saver.savePacket(packet);
                }
                catch (IOException e) {
                    throw new IOException("Failed to save packet for station: " + this.node.getName() + " Error: " + e.getMessage());
                }
            }
            saver.close();
            return true;
        }

        private KeyedChannel getKeyedChannel() throws IOException {
            SohDataSource.this.pingSource();
            ChannelList channelList = SohDataSource.this.source.getChannelList();
            if (channelList == null || channelList.size() == 0) {
                throw new IOException("Failed to retrieve any channels.");
            }
            KeyedChannel chan = null;
            Enumeration e = channelList.elements();
            while (e.hasMoreElements()) {
                chan = (KeyedChannel)e.nextElement();
                if (!chan.getName().equalsIgnoreCase(this.node.getName())) continue;
                return chan;
            }
            return chan;
        }

        protected ChannelPrecis getPrecis() throws IOException {
            KeyedChannel chan = null;
            chan = this.getKeyedChannel();
            if (chan == null) {
                return null;
            }
            PrecisList chanInfo = SohDataSource.this.source.getPrecisList(chan.getKey());
            if (chanInfo == null || chanInfo.getChannelCount() <= 0) {
                throw new IOException("No Channels Obtained!");
            }
            ChannelPrecis precis = (ChannelPrecis)chanInfo.iterator().next();
            return precis;
        }

        private ArrayList retrievePackets() throws IOException {
            if (this.savedPackets != null) {
                return this.savedPackets;
            }
            SohDataSource.this.updateConnection(this.node);
            SohDataSource.this.pingSource();
            this.clearVectors();
            KeyedChannel chan = this.getKeyedChannel();
            if (chan == null) {
                return null;
            }
            SohDataConsumer consumer = new SohDataConsumer();
            int start = (int)Math.floor(this.startTime - 600.0);
            int end = (int)Math.ceil(this.endTime + 600.0);
            SohDataSource.this.source.getData(chan.getKey(), start, end, consumer);
            this.savedPackets = consumer.getPackets();
            return this.savedPackets;
        }

        private boolean processPacketsForPlotting(ArrayList packets) throws IOException {
            if (packets == null || packets.size() == 0) {
                this.timeArray = null;
                this.valueArray = null;
                return true;
            }
            Iterator iter = packets.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof SohPacket)) continue;
                SohPacket p = (SohPacket)obj;
                this.processPacketForPlotting(p);
            }
            this.prepareDataArrays();
            return false;
        }

        private void processPacketForPlotting(SohPacket sohPacket) {
            int numBundles = sohPacket.getNumBundles();
            SohBundle bundle = new SohBundle(9);
            int ix = 1;
            while (ix <= numBundles) {
                byte[] bundleBytes = sohPacket.getBundle(ix);
                bundle = SohBundleFactory.createBundle(bundleBytes, 0);
                if (bundle.getType() == 9) break;
                this.processBundleForPlotting(bundle);
                ++ix;
            }
        }

        private void processBundleForPlotting(SohBundle bundle) {
            int index;
            if (bundle == null) {
                return;
            }
            if (this.node.bundleHandled(bundle.getType()) && (index = bundle.getIndexOfReadingHeader(this.node.getReadingName())) > 0) {
                double val = 0.0;
                Object obj = bundle.getReadingByIndex(index);
                if (obj instanceof Number) {
                    double time = bundle.getLongSeconds();
                    if (obj instanceof Double) {
                        Double d = (Double)obj;
                        val = d;
                    } else if (obj instanceof Integer) {
                        Integer integer = (Integer)obj;
                        val = integer.doubleValue();
                    }
                    if (time >= this.startTime - 1.0 && time <= this.endTime + 1.0) {
                        this.addToDataSeries(time, val);
                    }
                }
            }
        }

        private void addToDataSeries(double time, double val) {
            this.times.add(new Double(time));
            this.values.add(new Double(val));
        }

        private void prepareDataArrays() throws IOException {
            if (this.times.size() == 0 || this.values.size() == 0) {
                this.timeArray = null;
                this.valueArray = null;
                return;
            }
            if (this.times.size() != this.values.size()) {
                this.timeArray = null;
                this.valueArray = null;
                throw new IOException("Number of times do not equal number of values.");
            }
            this.timeArray = new double[this.times.size()];
            this.valueArray = new double[this.times.size()];
            int i = 0;
            while (i < this.times.size()) {
                this.timeArray[i] = (Double)this.times.get(i);
                this.valueArray[i] = (Double)this.values.get(i);
                ++i;
            }
        }
    }

    private class SohDataConsumer
    implements PacketConsumer {
        ArrayList packets = new ArrayList();

        public void processPacket(Packable packet) throws IOException {
            this.packets.add(packet);
        }

        public ArrayList getPackets() {
            return this.packets;
        }
    }
}

