/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.MsgConsumer;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.SohPacket;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;
import java.util.Enumeration;
import java.util.Vector;

public class SohDispatcher
extends BufferedConsumer
implements MsgConsumer {
    private Vector subscribers = new Vector();

    public SohDispatcher() {
        super("SohDispatcher");
    }

    public SohDispatcher(String name) {
        super(name);
    }

    public void addSubscriber(SohBundleHandler handler) {
        if (handler != null && !this.subscribers.contains(handler)) {
            this.subscribers.addElement(handler);
        }
    }

    public void removeSubscriber(SohBundleHandler handler) {
        this.subscribers.removeElement(handler);
    }

    protected void open() {
        Log.report(this, 5, 2, "starting...");
    }

    protected void close() {
        Log.report(this, 6, 2, "quitting...");
    }

    protected SohBundle makeBundle(byte[] buffer, int offset) {
        try {
            return new SohBundle(buffer, offset);
        }
        catch (Exception iie) {
            return null;
        }
    }

    protected void process(Object obj) {
        SohPacket packet = (SohPacket)obj;
        int key = packet.getKey();
        byte[] buffer = packet.getStorableBytes();
        int numBundles = packet.getNumBundles();
        int count = 1;
        while (count <= numBundles) {
            int offset = count * 17;
            int type = SohBundle.getSohBundleType(buffer, offset);
            if (type == 9) {
                return;
            }
            SohBundle bundle = this.makeBundle(buffer, offset);
            if (bundle != null) {
                this.distribute(key, bundle);
            }
            ++count;
        }
    }

    protected void tick() {
        Enumeration e = this.subscribers.elements();
        while (e.hasMoreElements()) {
            ((SohBundleHandler)e.nextElement()).tick();
        }
    }

    public void setChannelList(ChannelList chList) {
        Log.report(this, 4, 2, "got Channel List...");
        this.distribute(chList);
    }

    public void put(Packable packet) {
        if (packet instanceof SohPacket) {
            Log.report(this, 7, 1, "received " + packet);
            this.append(packet);
        } else if (packet instanceof ChannelList) {
            this.setChannelList((ChannelList)packet);
        }
    }

    private void distribute(ChannelList list) {
        Enumeration e = this.subscribers.elements();
        while (e.hasMoreElements()) {
            ((SohBundleHandler)e.nextElement()).setChannelList(list);
        }
    }

    private void distribute(int key, SohBundle bundle) {
        Enumeration e = this.subscribers.elements();
        while (e.hasMoreElements()) {
            ((SohBundleHandler)e.nextElement()).put(key, bundle);
        }
    }
}

