/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.util.Numeric;

public class SohHistory
implements Numeric {
    private String station;
    private String instrument;
    private String variable;
    private double current;
    private double[] values;
    private int[] times;
    private int oldest;
    private int numValues;
    private int arraySize;

    public SohHistory(String stationName, String instrumentName, String variableName, int capacity) {
        this.station = stationName;
        this.instrument = instrumentName;
        this.variable = variableName;
        this.arraySize = capacity;
        if (this.arraySize < 1) {
            this.arraySize = 1;
        }
        this.values = new double[this.arraySize];
        this.times = new int[this.arraySize];
        this.oldest = 0;
        this.numValues = 0;
        this.current = 0.0;
    }

    public SohHistory(String stationName, String instrumentName, String variableName) {
        this(stationName, instrumentName, variableName, 1000);
    }

    public synchronized void add(int time, double value) {
        int index = (this.oldest + this.numValues) % this.arraySize;
        this.times[index] = time;
        this.values[index] = value;
        this.current = value;
        if (this.numValues < this.arraySize) {
            ++this.numValues;
        } else {
            this.oldest = (this.oldest + 1) % this.arraySize;
        }
    }

    public synchronized void clear() {
        this.oldest = 0;
        this.numValues = 0;
        this.current = 0.0;
    }

    public synchronized double doubleValue() {
        return this.current;
    }

    public synchronized long longValue() {
        return Math.round(this.doubleValue());
    }

    public int getSize() {
        return this.arraySize;
    }

    public synchronized int getNumValues() {
        return this.numValues;
    }

    public synchronized double[] getValues() {
        double[] dest = new double[this.numValues];
        System.arraycopy(this.values, this.oldest, dest, 0, this.numValues - this.oldest);
        if (this.oldest > 0) {
            System.arraycopy(this.values, 0, dest, this.numValues - this.oldest, this.oldest);
        }
        return dest;
    }

    public synchronized int[] getTimes() {
        int[] dest = new int[this.numValues];
        System.arraycopy(this.times, this.oldest, dest, 0, this.numValues - this.oldest);
        if (this.oldest > 0) {
            System.arraycopy(this.times, 0, dest, this.numValues - this.oldest, this.oldest);
        }
        return dest;
    }

    public String getStation() {
        return this.station;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getVariable() {
        return this.variable;
    }

    public String toString() {
        return "" + this.doubleValue();
    }
}

