/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.KeyedChannel;
import ca.nanometrics.uitools.table.NmxTable;
import ca.nanometrics.uitools.table.RowTable;
import ca.nanometrics.uitools.table.TableRow;
import ca.nanometrics.uitools.table.TableSorter;
import ca.nanometrics.uitools.table.VectorTableModel;
import ca.nanometrics.util.ErrorDisplay;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class SohViewer
extends BasicViewer
implements SohBundleHandler,
Observer {
    private static final int UPDATE_INTERVAL = 30;
    private JPanel mainPanel;
    protected SohTableRow prototype;
    protected RowTable rowTable = new RowTable();
    private Vector rows = new Vector();
    private VectorTableModel sohData = new VectorTableModel();
    private RendererTable rtt = new RendererTable();
    protected NaqsViewTable table;
    private TableSorter sorter;
    protected RowSelector selector;
    private Vector selectedRows;
    private RowSelectorSettings rowSettings = new RowSelectorSettings();
    private double start = 0.0;
    private int ticks = 0;
    protected JCheckBox showButton = null;
    private boolean showAll = true;

    public SohViewer(SohTableRow sampleRow, Frame frame) {
        super(frame);
        this.prototype = sampleRow;
        this.setTitle(this.prototype.getTableName());
        this.initializeTable();
        this.setHeaderListener();
        this.start = Math.floor(System.currentTimeMillis() / 1000L);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)scrollPane, "Center");
        this.setContentPane(this.mainPanel);
    }

    public SohTableRow getPrototype() {
        return this.prototype;
    }

    public void setHeaderListener() {
        JTableHeader th = this.table.getTableHeader();
        th.addMouseListener(new HeaderMouseHandler());
    }

    private void initializeTable() {
        this.sohData.setPrototype(this.prototype);
        if (this.selector == null) {
            this.selector = new RowSelector(this.sohData);
        } else {
            this.selector.setModel(this.sohData);
        }
        if (this.sorter == null) {
            this.sorter = new TableSorter(this.selector);
        } else {
            this.sorter.setModel(this.selector);
        }
        if (this.table == null) {
            this.table = new NaqsViewTable(this.sorter);
            this.table.setRowHeight(18);
            this.sorter.addMouseListenerToHeaderInTable(this.table);
            this.table.setRowSelectionAllowed(false);
            this.table.getTableHeader().setResizingAllowed(false);
        } else {
            this.table.setModel(this.sorter);
        }
        int numColumns = this.table.getColumnCount();
        int totalWidth = 0;
        int col = 0;
        while (col < numColumns) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            int width = this.prototype.getPreferredWidth(col);
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width * 2);
            TableCellRenderer tcr = this.prototype.getColumnRenderer(col);
            if (tcr != null) {
                column.setCellRenderer(tcr);
                this.rtt.addRenderer(this.prototype.getColumnName(col), tcr);
            }
            ++col;
        }
        Dimension prefSize = new Dimension(totalWidth * 3 / 2, 200);
        this.table.setPreferredScrollableViewportSize(prefSize);
    }

    protected JPanel getMainPanel() {
        return this.mainPanel;
    }

    protected NmxTable getTable() {
        return this.table;
    }

    protected void resetAll() {
        Enumeration enumeration = this.rowTable.elements();
        while (enumeration.hasMoreElements()) {
            SohTableRow row = (SohTableRow)enumeration.nextElement();
            row.resetAll();
        }
        this.getTable().repaint();
    }

    protected void selectStation() {
        SubscriptionDialog subd = new SubscriptionDialog(this);
        subd.setTitle(String.valueOf(this.getTitle()) + " - Select Stations");
        if (!this.getShowAllSelected()) {
            this.selector.setSelectedRows(this.selectedRows);
        }
        subd.setChannels(this.sohData, this.selector);
        subd.setVisible(true);
        if (subd.isOkSelected()) {
            Vector rows = subd.getSelectedChannels();
            this.getSelectorSettings().setRowLabels(rows);
            this.selector.setSelectedRows(rows);
            if (!this.getShowAllSelected()) {
                this.showActiveOnly(true);
            }
            this.sohData.fireTableDataChanged();
        }
    }

    protected RowSelectorSettings getSelectorSettings() {
        return this.rowSettings;
    }

    protected GradingThresholdTable getThresholdTable() {
        GradingThresholdTable gtt = new GradingThresholdTable();
        Enumeration keys = this.rtt.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            TableCellRenderer tcr = this.rtt.getRenderer(key);
            if (!(tcr instanceof GradedTableCellRenderer)) continue;
            GradedTableCellRenderer gtcr = (GradedTableCellRenderer)tcr;
            GradingThresholds gt = gtcr.getThresholds();
            GradingThresholds newGT = new GradingThresholds(gt);
            gtt.add(key, newGT);
        }
        return gtt;
    }

    protected void adjustColumnSettings() {
        GradingThresholdTable gtt = this.getThresholdTable();
        ColumnSettingsDialog csd = new ColumnSettingsDialog((JDialog)this, gtt);
        csd.setTitle(String.valueOf(this.getTitle()) + " - set column color thresholds");
        csd.setVisible(true);
        if (csd.isOk()) {
            this.applyColumnSettings(gtt);
        }
    }

    public void setDataSource(SohDataSource source) {
        this.prototype.setDataSource(source);
    }

    public void setChannelList(ChannelList list) {
        if (list == null) {
            return;
        }
        this.rowTable.clear();
        this.rows.removeAllElements();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            KeyedChannel kc = (KeyedChannel)e.nextElement();
            int key = kc.getKey();
            if (!this.prototype.acceptKey(key)) continue;
            SohTableRow entry = this.prototype.createTableRow(key, kc.getName());
            entry.addThisObserver(this);
            this.rowTable.put(key, entry);
            this.rows.addElement(entry);
        }
        this.sohData.setRows(this.rows);
        this.selector.selectAllRows();
    }

    public void put(int key, SohBundle bundle) {
        SohTableRow entry = (SohTableRow)this.rowTable.get(key);
        if (entry == null) {
            return;
        }
        try {
            entry.process(bundle);
            this.sohData.entryUpdated(entry);
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    public void tick() {
        this.ticks = (this.ticks + 1) % 30;
        if (this.ticks == 0) {
            this.sohData.fireTableDataChanged();
        }
    }

    protected TableRow getEntry(int key) {
        return this.rowTable.get(key);
    }

    protected Enumeration getEntries() {
        return this.rowTable.elements();
    }

    public void applyColumnSettings(GradingThresholdTable gtt) {
        Enumeration keys = gtt.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            GradingThresholds gt = gtt.get(key);
            TableCellRenderer tcr = this.rtt.getRenderer(key);
            if (!(tcr instanceof GradedTableCellRenderer)) continue;
            ((GradedTableCellRenderer)tcr).setThresholds(gt);
        }
        this.getPrototype().applyThresholds(gtt);
        this.table.repaint();
    }

    public void validateColumnSettings(GradingThresholdTable gtt) {
        TableCellRenderer tcr;
        String key;
        Vector<String> invalid = new Vector<String>();
        Enumeration keys = gtt.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            tcr = this.rtt.getRenderer(key);
            if (tcr != null && tcr instanceof GradedTableCellRenderer) continue;
            invalid.addElement(key);
        }
        int inx = 0;
        while (inx < invalid.size()) {
            gtt.remove((String)invalid.elementAt(inx));
            ++inx;
        }
        keys = this.rtt.keys();
        while (keys.hasMoreElements()) {
            GradingThresholds gt;
            key = (String)keys.nextElement();
            tcr = this.rtt.getRenderer(key);
            if (!(tcr instanceof GradedTableCellRenderer) || (gt = gtt.get(key)) != null) continue;
            gtt.add(key, ((GradedTableCellRenderer)tcr).getThresholds());
        }
    }

    protected void setShowAllSelected(boolean show) {
        this.showAll = show;
    }

    protected boolean getShowAllSelected() {
        return this.showAll;
    }

    private SohViewSettings getViewSettings() {
        return this.prototype.getViewSettings();
    }

    public void updateSettings(NaqsViewSettings naqsSettings) {
        SohViewSettings stgs = naqsSettings.getViewSettings(this.getTitle());
        if (stgs == null) {
            stgs = this.getViewSettings();
            naqsSettings.addViewSettings(this.getTitle(), stgs);
        }
        GradingThresholdTable gtt = stgs.getColumnThresholds();
        Enumeration keys = this.rtt.keys();
        while (keys.hasMoreElements()) {
            GradingThresholds gt;
            String key = (String)keys.nextElement();
            TableCellRenderer tcr = this.rtt.getRenderer(key);
            if (!(tcr instanceof GradedTableCellRenderer) || (gt = gtt.get(key)) != null) continue;
            gtt.add(key, ((GradedTableCellRenderer)tcr).getThresholds());
        }
        Vector rows = this.selectedRows == null || this.showAll ? this.selector.getSelectedRows() : this.selectedRows;
        RowSelectorSettings newRowSettings = stgs.getSelectorSettings();
        newRowSettings.setRowLabels(rows);
        stgs.setShowAllSelected(this.getShowAllSelected());
    }

    public void applySettings(NaqsViewSettings naqsSettings) {
        Vector rows;
        SohViewSettings vSettings = naqsSettings.getViewSettings(this.getTitle());
        if (vSettings == null) {
            return;
        }
        GradingThresholdTable gtt = vSettings.getColumnThresholds();
        this.validateColumnSettings(gtt);
        this.applyColumnSettings(gtt);
        this.setShowAllSelected(vSettings.getShowAllSelected());
        if (this.showButton != null) {
            this.showButton.setSelected(!this.getShowAllSelected());
        }
        this.selectedRows = rows = vSettings.getSelectorSettings().getRowLabels();
        this.selector.setSelectedRows(rows);
        if (!this.getShowAllSelected()) {
            this.showActiveOnly(false);
        }
    }

    private boolean joinHistoryViewer(int viewerIndex, ArrayList nodes) {
        if (viewerIndex >= HistoryViewer.viewers.size()) {
            return false;
        }
        HistoryViewer viewer = (HistoryViewer)HistoryViewer.viewers.get(viewerIndex);
        viewer.addNodes(nodes);
        return true;
    }

    private boolean checkDataServer(ArrayList nodes) {
        if (nodes.size() == 0) {
            return false;
        }
        DoubleNode node = (DoubleNode)nodes.get(0);
        SohDataSource source = node.getDataSource();
        try {
            source.pingSource();
        }
        catch (IOException ioe) {
            String message = ioe.getMessage().indexOf("Connection refused") >= 0 ? "DataServer Unavailable; Error: Connection Refused" : "DataServer Unavailable; Error: " + ioe.getMessage();
            Log.report(this, 1, 3, message);
            ErrorDisplay.display(message, "DataServer Connection Failure");
            return false;
        }
        catch (IllegalArgumentException iae) {
            Log.report(this, 1, 3, "Failed to connect to DataServer; Error: Port Number: " + source.getPort() + " out of range");
            ErrorDisplay.display("Failed to connect to DataServer; Error: Port Number: " + source.getPort() + " out of range", "DataServer Connection Problem");
            return false;
        }
        return true;
    }

    protected void createHistoryViewer(int viewerIndex, ArrayList nodes) {
        if (!this.checkDataServer(nodes)) {
            return;
        }
        if (viewerIndex > 0 && this.joinHistoryViewer(viewerIndex - 1, nodes)) {
            return;
        }
        HistoryDurationDialog dlog = null;
        try {
            dlog = new HistoryDurationDialog(this.start, Math.ceil(System.currentTimeMillis() / 1000L) - this.start);
        }
        catch (Exception e) {
            ErrorDisplay.display("Unable to Show History Duration Dialog; Error: " + e.getMessage(), "DialogError");
            return;
        }
        if (dlog.getSuccess()) {
            double startTime = dlog.getStartTime();
            double endTime = startTime + dlog.getDuration();
            NaqsView.statusBar.push(0, "Creating History Viewer...");
            HistoryViewer hv = new HistoryViewer(nodes, startTime, endTime, HistoryViewer.viewers.size() + 1);
            if (!hv.success()) {
                JOptionPane.showMessageDialog(this, "Failed to create History Viewer.");
            }
            hv.setVisible(true);
            hv.toFront();
            NaqsView.statusBar.pop();
        }
    }

    protected void showAllSelected() {
        if (this.selectedRows != null) {
            this.selector.setSelectedRows(this.selectedRows);
        }
    }

    protected void showActiveOnly(boolean updateSelectedRows) {
        if (updateSelectedRows) {
            this.selectedRows = this.selector.getSelectedRows();
        }
        if (this.selectedRows.size() == 0) {
            return;
        }
        Vector<String> activeRows = new Vector<String>();
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            SohTableRow tableRow = (SohTableRow)iter.next();
            if (!tableRow.isActive() || !this.selectedRows.contains(tableRow.getName())) continue;
            activeRows.add(tableRow.getName());
        }
        this.selector.setSelectedRows(activeRows);
    }

    public void update(Observable o, Object arg) {
        if (!this.getShowAllSelected()) {
            this.showActiveOnly(false);
        }
    }

    private void updateRows() {
        Enumeration e = this.rows.elements();
        while (e.hasMoreElements()) {
            SohTableRow row = (SohTableRow)e.nextElement();
            row.updateRow(this.getPrototype());
        }
    }

    public void updatePrototype(SohTableRow row) {
        if (!(row instanceof CustomSohTableRow)) {
            return;
        }
        this.prototype = row;
        this.initializeTable();
        this.updateRows();
        this.pack();
    }

    public void updateProperties() {
        this.table.updateProperties(this.getPrototype());
        this.setTitle(this.getPrototype().getTableName());
        this.repaint();
    }

    class ColumnSettingsAction
    implements ActionListener {
        ColumnSettingsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            SohViewer.this.adjustColumnSettings();
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int col;
            int buttonNo = e.getButton();
            Object o = e.getSource();
            JTableHeader header = null;
            try {
                header = (JTableHeader)o;
            }
            catch (Exception exc) {
                return;
            }
            if (buttonNo == 3 && e.getClickCount() == 1 && SohViewer.this.prototype.hasPopup(col = SohViewer.this.table.columnAtPoint(e.getPoint()))) {
                JPopupMenu popUp = new JPopupMenu();
                popUp.add(new ResetColumnAction(col));
                popUp.addSeparator();
                ArrayList viewers = HistoryViewer.viewers;
                if (viewers.size() == 0) {
                    popUp.add(new HistoryAction("History", 0, col));
                } else {
                    JMenu historyPopup = new JMenu("History");
                    historyPopup.add(new HistoryAction("New History", 0, col));
                    int i = 0;
                    while (i < viewers.size()) {
                        HistoryViewer viewer = (HistoryViewer)viewers.get(i);
                        historyPopup.add(new HistoryAction(viewer.getTitle(), i + 1, col));
                        ++i;
                    }
                    popUp.add(historyPopup);
                }
                popUp.show(header, e.getX(), e.getY());
            }
        }
    }

    class HistoryAction
    extends AbstractAction {
        int viewerIndex;
        int colIndex;

        public HistoryAction(String name, int i, int col) {
            super(name);
            this.viewerIndex = 0;
            this.colIndex = 0;
            this.viewerIndex = i;
            this.colIndex = col;
        }

        public void actionPerformed(ActionEvent e) {
            DoubleNode node = null;
            ArrayList<DoubleNode> nodeList = new ArrayList<DoubleNode>();
            Vector selectedRows = SohViewer.this.selector.getSelectedRows();
            Iterator iter = selectedRows.iterator();
            block0: while (iter.hasNext()) {
                String sta = (String)iter.next();
                Enumeration enumeration = SohViewer.this.rowTable.elements();
                while (enumeration.hasMoreElements()) {
                    SohTableRow row = (SohTableRow)enumeration.nextElement();
                    if (!row.getName().equalsIgnoreCase(sta)) continue;
                    node = row.getDoubleNode(this.colIndex);
                    if (node == null) continue block0;
                    nodeList.add(node);
                    continue block0;
                }
            }
            if (nodeList.size() > 0) {
                SohViewer.this.createHistoryViewer(this.viewerIndex, nodeList);
            }
        }
    }

    class ResetAllAction
    implements ActionListener {
        ResetAllAction() {
        }

        public void actionPerformed(ActionEvent event) {
            SohViewer.this.resetAll();
        }
    }

    class ResetColumnAction
    extends AbstractAction {
        private int colIndex;

        public ResetColumnAction(int col) {
            super("Reset");
            this.colIndex = col;
        }

        public void actionPerformed(ActionEvent e) {
            Enumeration enumeration = SohViewer.this.rowTable.elements();
            while (enumeration.hasMoreElements()) {
                SohTableRow row = (SohTableRow)enumeration.nextElement();
                row.resetNode(this.colIndex);
            }
            SohViewer.this.getTable().repaint();
        }
    }

    class SelectStationAction
    implements ActionListener {
        SelectStationAction() {
        }

        public void actionPerformed(ActionEvent event) {
            SohViewer.this.selectStation();
        }
    }

    class ShowAllAction
    implements ActionListener {
        public ShowAllAction() {
            SohViewer.this.setShowAllSelected(true);
        }

        public void actionPerformed(ActionEvent event) {
            if (SohViewer.this.showButton == null) {
                return;
            }
            if (SohViewer.this.getShowAllSelected()) {
                SohViewer.this.showActiveOnly(true);
                SohViewer.this.setShowAllSelected(false);
            } else {
                SohViewer.this.setShowAllSelected(true);
                SohViewer.this.showAllSelected();
            }
        }
    }
}

