/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.uitools.table.TableSorter;
import ca.nanometrics.uitools.table.VectorTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SubscriptionDialog
extends CenteredDialog {
    private VectorTableModel tableModel = new VectorTableModel();
    protected Vector rows = new Vector();
    private JTable table;
    private TableSorter sorter;
    protected boolean okSelected = false;
    protected JButton selectButton;

    public SubscriptionDialog(JDialog parent) {
        super(parent, true);
        this.setTitle("Select Channels");
        this.initializeTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        mainPanel.add((Component)buttonPanel, "South");
        this.setContentPane(mainPanel);
        this.pack();
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.ipadx = 5;
        gbc.ipady = 5;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        buttonPanel.add((Component)new JLabel("     "), gbc);
        this.selectButton = new JButton(" Select All ");
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        buttonPanel.add((Component)this.selectButton, gbc);
        this.selectButton.addActionListener(new SelectAction());
        JButton okButton = new JButton("     OK     ");
        gbc.gridx = 3;
        gbc.gridwidth = 2;
        buttonPanel.add((Component)okButton, gbc);
        okButton.addActionListener(new okAction());
        JButton cancelButton = new JButton("   Cancel   ");
        gbc.gridx = 5;
        gbc.gridwidth = 2;
        buttonPanel.add((Component)cancelButton, gbc);
        cancelButton.addActionListener(new cancelAction());
        gbc.gridx = 7;
        gbc.gridwidth = 1;
        buttonPanel.add((Component)new JLabel(" "), gbc);
        return buttonPanel;
    }

    private void initializeTable() {
        SubscriptionTableRow prototype = new SubscriptionTableRow(1, "STN01.BHZ", false);
        this.tableModel.setPrototype(prototype);
        this.sorter = new TableSorter(this.tableModel);
        this.table = new JTable(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setRowSelectionAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
        int numColumns = this.table.getColumnCount();
        int totalWidth = 0;
        int col = 0;
        while (col < numColumns) {
            TableColumn column = this.table.getColumnModel().getColumn(col);
            int width = prototype.getPreferredWidth(col);
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width * 2);
            TableCellRenderer tcr = prototype.getColumnRenderer(col);
            if (tcr != null) {
                column.setCellRenderer(tcr);
            }
            ++col;
        }
        Dimension tableSize = new Dimension(totalWidth * 3 / 2, 200);
        this.table.setPreferredScrollableViewportSize(tableSize);
    }

    public void setChannels(VectorTableModel available, RowSelector selector) {
        this.rows.clear();
        Enumeration e = available.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof ChannelRow)) continue;
            ChannelRow crow = (ChannelRow)obj;
            String rowName = crow.getName();
            boolean selected = selector.isSelected(rowName);
            this.rows.add(new SubscriptionTableRow(crow.getKey(), rowName, selected));
        }
        this.tableModel.setRows(this.rows);
    }

    public Vector getSelectedChannels() {
        Vector<String> selectedRows = new Vector<String>(this.rows.size());
        Enumeration e = this.rows.elements();
        while (e.hasMoreElements()) {
            SubscriptionTableRow row = (SubscriptionTableRow)e.nextElement();
            if (!row.isSelected()) continue;
            selectedRows.add(row.getName());
        }
        return selectedRows;
    }

    public boolean isOkSelected() {
        return this.okSelected;
    }

    class SelectAction
    implements ActionListener {
        SelectAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Boolean val;
            SubscriptionDialog.this.okSelected = false;
            if (SubscriptionDialog.this.selectButton.getText().trim().equals("Select All")) {
                val = new Boolean(true);
                SubscriptionDialog.this.selectButton.setText("Deselect All");
            } else {
                val = new Boolean(false);
                SubscriptionDialog.this.selectButton.setText(" Select All ");
            }
            Iterator iter = SubscriptionDialog.this.rows.iterator();
            while (iter.hasNext()) {
                SubscriptionTableRow row = (SubscriptionTableRow)iter.next();
                row.setValueAt(val, 3);
            }
            SubscriptionDialog.this.repaint();
        }
    }

    class cancelAction
    implements ActionListener {
        cancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SubscriptionDialog.this.okSelected = false;
            SubscriptionDialog.this.closeWindow();
        }
    }

    class okAction
    implements ActionListener {
        okAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SubscriptionDialog.this.okSelected = true;
            SubscriptionDialog.this.closeWindow();
        }
    }
}

