/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ViewerStateTable
implements Serializable {
    private Hashtable table = new Hashtable();

    public ComponentState getComponentState(String key) {
        return (ComponentState)this.table.get(key);
    }

    public void addComponentState(String key, ComponentState state) {
        this.table.put(key, state);
    }

    public void addViewerState(BasicViewer viewer) {
        this.table.put(viewer.getTitle(), viewer.getComponentState());
    }

    public void addViewerState(NaqsView view) {
        this.table.put("NaqsView", view.getComponentState());
    }

    public void restoreViewerState(NaqsView view) {
        view.setComponentState(this.getComponentState("NaqsView"));
    }

    public void restoreViewerState(BasicViewer viewer) {
        viewer.setComponentState(this.getComponentState(viewer.getTitle()));
    }

    public boolean equals(ViewerStateTable other) {
        Enumeration keys = this.table.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ComponentState otherState = other.getComponentState(key);
            if (otherState == null) {
                return false;
            }
            ComponentState thisState = (ComponentState)this.table.get(key);
            if (thisState.equals(otherState)) continue;
            return false;
        }
        return true;
    }
}

