/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SatelliteChannelInfo;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class GpsSatelliteInformationBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 40;

    public GpsSatelliteInformationBundle() {
        super(40);
    }

    public GpsSatelliteInformationBundle(byte[] buffer, int index) {
        super(buffer, index, 40);
    }

    public GpsSatelliteInformationBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 40);
    }

    public GpsSatelliteInformationBundle(SatelliteChannelInfo[] satInfo) {
        super(40, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)((byte)(satInfo[0].channel & 7) | (byte)(satInfo[0].uSecFlag << 3));
        this.guts[6] = (byte)((byte)(satInfo[0].prn & 0x1F) | (satInfo[0].acquFlags & 7) << 5);
        this.guts[7] = (byte)(satInfo[0].elevation * 255.0f / 90.0f);
        this.guts[8] = (byte)(satInfo[0].azimuth * 255.0f / 360.0f);
        LittleEndian.writeShort(this.guts, 9, (short)satInfo[0].signalLevel);
        this.guts[11] = (byte)((byte)(satInfo[1].channel & 7) | (byte)(satInfo[1].uSecFlag << 3));
        this.guts[12] = (byte)((byte)satInfo[1].prn & 0x1F | (satInfo[1].acquFlags & 7) << 5);
        this.guts[13] = (byte)(satInfo[1].elevation * 255.0f / 90.0f);
        this.guts[14] = (byte)(satInfo[1].azimuth * 255.0f / 360.0f);
        LittleEndian.writeShort(this.guts, 15, (short)satInfo[1].signalLevel);
    }

    public SatelliteChannelInfo getSatInfo(int index) throws InvalidInputException {
        SatelliteChannelInfo satInfo = new SatelliteChannelInfo();
        if (index < 0 | index > 1) {
            throw new InvalidInputException("SatelliteChannelInfo index");
        }
        int base = index * 6 + 5;
        satInfo.channel = this.guts[base] & 7;
        satInfo.uSecFlag = this.guts[base] >> 3 & 7;
        satInfo.prn = this.guts[base + 1] & 0x1F;
        satInfo.acquFlags = this.guts[base + 1] >> 5 & 7;
        float val = this.guts[base + 2] & 0xFF;
        satInfo.elevation = val * 90.0f / 255.0f;
        val = this.guts[base + 3] & 0xFF;
        satInfo.azimuth = val * 360.0f / 255.0f;
        satInfo.signalLevel = LittleEndian.readShort(this.guts, base + 4);
        return satInfo;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new GpsSatelliteInformationBundle(bytes, index);
    }

    public String getCsvName() {
        return "gsi";
    }

    public String getCsvTitle() {
        return "RM4 GPS satellite information";
    }

    public String getCsvHeader() {
        return "Time(longsecs), Time(date-time),Channel,Millisecs,PRN,AcquisitionType,Elevation,Azimuth,SignalLevel";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format fd = new Format("%6d");
        Format ff = new Format("%10.3f");
        try {
            SatelliteChannelInfo sChanInfo = this.getSatInfo(0);
            sb.append("," + fd.form(sChanInfo.channel));
            sb.append("," + fd.form(sChanInfo.uSecFlag));
            sb.append("," + fd.form(sChanInfo.prn));
            sb.append("," + fd.form(sChanInfo.acquFlags));
            sb.append("," + ff.form(sChanInfo.elevation));
            sb.append("," + ff.form(sChanInfo.azimuth));
            sb.append("," + fd.form(sChanInfo.signalLevel));
            sChanInfo = this.getSatInfo(1);
            sb.append("\n" + this.getCsvDateString());
            sb.append("," + fd.form(sChanInfo.channel));
            sb.append("," + fd.form(sChanInfo.uSecFlag));
            sb.append("," + fd.form(sChanInfo.prn));
            sb.append("," + fd.form(sChanInfo.acquFlags));
            sb.append("," + ff.form(sChanInfo.elevation));
            sb.append("," + ff.form(sChanInfo.azimuth));
            sb.append("," + fd.form(sChanInfo.signalLevel));
        }
        catch (InvalidInputException e) {
            System.out.println("Invalid input in GpsSatelliteInformationBundle getCsvData()");
            sb = null;
        }
        return sb.toString();
    }
}

