/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class LibraOperationStateBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 56;
    static final int OFFSET_TO_STATE = 5;
    private static final int NUMBER_OF_COLUMNS = 3;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int STATE_COL = 2;

    public LibraOperationStateBundle() {
        super(56);
    }

    public LibraOperationStateBundle(byte[] buffer, int index) {
        super(buffer, index, 56);
    }

    public LibraOperationStateBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 56);
    }

    public SohBundle createBundle() {
        return new LibraOperationStateBundle();
    }

    public int getState() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LibraOperationStateBundle(bytes, index);
    }

    public String getCsvName() {
        return "los";
    }

    public String getCsvTitle() {
        return "VSat: Libra Operation State for Instrument: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format form = new Format("%8.8x");
        sb.append(",     0x" + form.form(this.getState()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getState());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "State";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 2: {
                thresholds[0] = -0.2;
                thresholds[1] = -0.1;
                thresholds[2] = 0.1;
                thresholds[3] = 0.2;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getName() {
        return "Libra Operation State";
    }
}

