/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class LogBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 12;
    public static final int OFFSET_TO_ERRCODE = 5;
    public static final int OFFSET_TO_ERRLVL = 7;
    public static final int OFFSET_TO_ERRPRMTS = 9;
    public static final int e4Short = 0;
    public static final int e2ShortLong = 1;
    public static final int e2ShortFloat = 2;
    public static final int e2ShortNil = 3;
    public static final int eLong2Short = 4;
    public static final int e2Long = 5;
    public static final int eLongFloat = 6;
    public static final int eLongNil = 7;
    public static final int eFloat2Short = 8;
    public static final int eFloatLong = 9;
    public static final int e2Float = 10;
    public static final int eFloatNil = 11;
    public static final int e8Char = 12;
    public static final int e8Byte = 13;
    public static final int eDouble = 14;
    public static final int eNil = 15;
    List errParam = new ArrayList();
    private static Properties properties = null;

    public LogBundle() {
        super(12);
    }

    public LogBundle(byte[] buffer, int index) {
        super(buffer, index, 12);
    }

    public LogBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 12);
    }

    public int getErrCode() {
        return LittleEndian.readUShort(this.guts, 5);
    }

    public int getErrNr() {
        return this.getErrCode() >> 0 & 0xFFF;
    }

    public int getDataFormat() {
        return this.getErrCode() >> 12 & 0xF;
    }

    public int getErrLevel() {
        return LittleEndian.readUShort(this.guts, 7);
    }

    public int getArea() {
        return this.getErrLevel() >> 0 & 0xFF;
    }

    public int getPrcsr() {
        return this.getErrLevel() >> 8 & 7;
    }

    public int getLevel() {
        return this.getErrLevel() >> 11 & 0x1F;
    }

    public String getLevelString() {
        switch (this.getLevel()) {
            case 16: {
                return "F";
            }
            case 8: {
                return "E";
            }
            case 4: {
                return "W";
            }
            case 2: {
                return "I";
            }
            case 1: {
                return "D";
            }
        }
        return "U";
    }

    public String getPrcsrString() {
        switch (this.getPrcsr()) {
            case 4: {
                return "D";
            }
            case 2: {
                return "T";
            }
            case 1: {
                return "A";
            }
        }
        return "U";
    }

    public String getAreaString() {
        switch (this.getArea()) {
            case 128: {
                return "1";
            }
            case 64: {
                return "2";
            }
            case 32: {
                return "3";
            }
            case 16: {
                return "4";
            }
            case 8: {
                return "5";
            }
            case 4: {
                return "6";
            }
            case 2: {
                return "7";
            }
            case 1: {
                return "8";
            }
            case 0: {
                return "U";
            }
        }
        return "M";
    }

    public void getErrParameters() {
        switch (this.getDataFormat()) {
            case 0: {
                int i = 0;
                while (i < 4) {
                    this.errParam.add(new Integer(LittleEndian.readUShort(this.guts, 9 + 2 * i)));
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < 2) {
                    this.errParam.add(new Integer(LittleEndian.readUShort(this.guts, 9 + 2 * i)));
                    ++i;
                }
                this.errParam.add(new Long(LittleEndian.readUInt(this.guts, 13)));
                break;
            }
            case 2: {
                int i = 0;
                while (i < 2) {
                    this.errParam.add(new Integer(LittleEndian.readUShort(this.guts, 9 + 2 * i)));
                    ++i;
                }
                this.errParam.add(new Float(LittleEndian.readFloat(this.guts, 13)));
                break;
            }
            case 3: {
                int i = 0;
                while (i < 2) {
                    this.errParam.add(new Integer(LittleEndian.readUShort(this.guts, 9 + 2 * i)));
                    ++i;
                }
                break;
            }
            case 4: {
                this.errParam.add(new Long(LittleEndian.readUInt(this.guts, 9)));
                int i = 2;
                while (i < 4) {
                    this.errParam.add(new Integer(LittleEndian.readUShort(this.guts, 9 + 2 * i)));
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < 2) {
                    this.errParam.add(new Long(LittleEndian.readUInt(this.guts, 9 + 4 * i)));
                    ++i;
                }
                break;
            }
            case 6: {
                this.errParam.add(new Long(LittleEndian.readUInt(this.guts, 9)));
                this.errParam.add(new Float(LittleEndian.readFloat(this.guts, 13)));
                break;
            }
            case 7: {
                this.errParam.add(new Long(LittleEndian.readUInt(this.guts, 9)));
                break;
            }
            case 8: {
                this.errParam.add(new Float(LittleEndian.readFloat(this.guts, 9)));
                int i = 2;
                while (i < 4) {
                    this.errParam.add(new Integer(LittleEndian.readUShort(this.guts, 9 + 2 * i)));
                    ++i;
                }
                break;
            }
            case 9: {
                this.errParam.add(new Float(LittleEndian.readFloat(this.guts, 9)));
                this.errParam.add(new Long(LittleEndian.readUInt(this.guts, 13)));
                break;
            }
            case 10: {
                int i = 0;
                while (i < 2) {
                    this.errParam.add(new Float(LittleEndian.readFloat(this.guts, 9 + 4 * i)));
                    ++i;
                }
                break;
            }
            case 11: {
                this.errParam.add(new Float(LittleEndian.readFloat(this.guts, 9)));
                break;
            }
            case 12: 
            case 13: {
                byte[] b1 = new byte[8];
                int i = 0;
                while (i < 8) {
                    b1[i] = this.guts[9 + i];
                    ++i;
                }
                String s = new String(b1);
                this.errParam.add(s.trim());
                break;
            }
            case 14: {
                this.errParam.add(new Double(LittleEndian.readDouble(this.guts, 9)));
                break;
            }
        }
    }

    public static void parseFile(Object source, String fileName) {
        properties = new Properties();
        try {
            InputStream input = source.getClass().getResourceAsStream(fileName);
            properties.load(input);
            input.close();
        }
        catch (Exception input) {
            // empty catch block
        }
        try {
            FileInputStream fis = new FileInputStream(fileName);
            properties.load(fis);
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LogBundle(bytes, index);
    }

    public String getCsvName() {
        return "log";
    }

    public String getCsvTitle() {
        return "Log file for Instrument";
    }

    public String getCsvHeader() {
        return "Time(longsecs),    Time(date-time), Level, Number, Message";
    }

    public String formatTheOutput(String sFormat) {
        ArrayList list = this.splitString(sFormat, "%");
        this.getErrParameters();
        if (list.size() > 1) {
            String oldString = (String)list.get(0);
            String newString = "";
            int i = 0;
            while (i < list.size() - 1) {
                newString = String.valueOf(oldString) + "%" + (String)list.get(i + 1);
                Format f = new Format(newString);
                oldString = newString = f.form(this.errParam.get(i));
                ++i;
            }
            return newString;
        }
        return sFormat;
    }

    private ArrayList splitString(String sFormat, String spltr) {
        ArrayList<String> list = new ArrayList<String>();
        String str = sFormat;
        String remainder = null;
        while (str.indexOf(spltr) >= 0) {
            remainder = str.substring(str.indexOf(spltr) + 1);
            str = str.substring(0, str.indexOf(spltr));
            list.add(str);
            str = remainder;
        }
        list.add(str);
        return list;
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%2s");
        sb.append("," + f.form(this.getLevelString()));
        f = new Format("%5d");
        sb.append("," + f.form(this.getErrNr()));
        if (properties == null) {
            LogBundle.parseFile(this, "sohreader.msg");
        }
        String format = null;
        if (properties != null) {
            format = properties.getProperty(Integer.toString(this.getErrNr()));
        }
        if (format != null) {
            sb.append(", " + this.formatTheOutput(format));
        } else {
            Format fmt = new Format("%x");
            sb.append(", Undefined Message: " + fmt.form(this.getErrCode()));
        }
        return sb.toString();
    }
}

