/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class NmxBusDeviceListBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 67;
    static final int OFFSET_TO_DEVICES = 5;
    static final int INVALID_DEVICE = 0;
    static final int MAX_DEVICES = 6;

    public NmxBusDeviceListBundle() {
        super(67);
    }

    public NmxBusDeviceListBundle(byte[] buffer, int index) {
        super(buffer, index, 67);
    }

    public NmxBusDeviceListBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 67);
    }

    public int getSlotId() {
        return 0;
    }

    private int getDeviceID(int ix) {
        return LittleEndian.readUShort(this.guts, 5 + 2 * ix);
    }

    private String getDeviceIDString(int ix) {
        return this.getSlotIdName(this.getDeviceID(ix));
    }

    public int getDeviceCount() {
        int count = 0;
        int ix = 0;
        while (ix < 6) {
            if (this.getDeviceID(ix) != 0) {
                ++count;
            }
            ++ix;
        }
        return count;
    }

    public int[] getDeviceList() {
        int[] deviceList = new int[6];
        int count = 0;
        int ix = 0;
        while (ix < 6) {
            int deviceID = this.getDeviceID(ix);
            if (deviceID != 0) {
                deviceList[count] = deviceID;
                ++count;
            }
            ++ix;
        }
        if (count < 6) {
            int[] tempList = deviceList;
            deviceList = new int[count];
            System.arraycopy(tempList, 0, deviceList, 0, count);
        }
        return deviceList;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new NmxBusDeviceListBundle(bytes, index);
    }

    public String getCsvName() {
        return "nbd";
    }

    public String getCsvTitle() {
        return "NMXbus Device List";
    }

    public String getCsvHeader() {
        return "Time(longsecs),Time(date-time), ID 1, ID 2, ID 3, ID 4, ID 5, ID 6";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append(", " + this.getDeviceIDString(0));
        sb.append(", " + this.getDeviceIDString(1));
        sb.append(", " + this.getDeviceIDString(2));
        sb.append(", " + this.getDeviceIDString(3));
        sb.append(", " + this.getDeviceIDString(4));
        sb.append(", " + this.getDeviceIDString(5));
        return sb.toString();
    }
}

