/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RM3SohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 27;
    static final int OFFSET_TO_BTRYVLTG = 5;
    static final int OFFSET_TO_EXTVLTG = 9;
    static final int OFFSET_TO_TEMP = 13;
    private static final Format f10p2 = new Format("%10.2f");
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int BATT_VOLTAGE_COL = 2;
    public static final int EXTERNAL_VOLTAGE_COL = 3;
    public static final int TEMPERATURE_COL = 4;

    public RM3SohBundle() {
        super(27);
    }

    public RM3SohBundle(byte[] buffer, int index) {
        super(buffer, index, 27);
    }

    public RM3SohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 27);
    }

    public RM3SohBundle(float btryVltg, float extVltg, float Temp) {
        super(27, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, btryVltg);
        LittleEndian.writeFloat(this.guts, 9, extVltg);
        LittleEndian.writeFloat(this.guts, 13, Temp);
    }

    public SohBundle createBundle() {
        return new RM3SohBundle();
    }

    public float getBateryVoltage() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getExtVoltage() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getTemp() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new RM3SohBundle(bytes, index);
    }

    public String getCsvName() {
        return "rsh";
    }

    public String getCsvTitle() {
        return "RM3 SOH for Instrument ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append("," + f10p2.form(this.getBateryVoltage()));
        sb.append("," + f10p2.form(this.getExtVoltage()));
        sb.append("," + f10p2.form(this.getTemp()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getBateryVoltage());
            }
            case 3: {
                return new Double(this.getExtVoltage());
            }
            case 4: {
                return new Double(this.getTemp());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "BatteryVoltage";
            }
            case 3: {
                return "ExternalVoltage";
            }
            case 4: {
                return "Temperature";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "RM-3 SOH";
    }
}

