/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RockwellGpsSatelliteBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 15;
    static final int MAX_CHANNELS = 5;
    static final int OFFSET_TO_STATUS = 5;
    static final int OFFSET_TO_CHANNELS = 7;
    static final int PRN_MASK = 31;
    static final int PRN_SHIFT = 0;
    static final int SNR_MASK = 63;
    static final int SNR_SHIFT = 8;
    static final int ACT_MASK = 3;
    static final int ACT_SHIFT = 14;
    static final int ALT_INFO_MASK = 7;
    static final int ALT_INFO_SHIFT = 0;
    static final int NAV_MODE_MASK = 1;
    static final int NAV_MODE_SHIFT = 3;
    static final int NUM_USED_MASK = 7;
    static final int NUM_USED_SHIFT = 4;
    static final int COLD_START_MASK = 1;
    static final int COLD_START_SHIFT = 7;
    static final int FIG_MERIT_MASK = 15;
    static final int FIG_MERIT_SHIFT = 8;
    static final int UTILITY_MASK = 7;
    static final int UTILITY_SHIFT = 12;
    static final int DGPS_USED_MASK = 1;
    static final int DGPS_USED_SHIFT = 15;
    private static final int NUMBER_OF_COLUMNS = 21;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int SOLN_STATE_COL = 2;
    public static final int FIG_MERIT_COL = 3;
    public static final int NSAT_FOR_SOLN_COL = 4;
    public static final int NSAT_TRACKED_COL = 5;
    public static final int ACT_1_COL = 6;
    public static final int ACT_2_COL = 7;
    public static final int ACT_3_COL = 8;
    public static final int ACT_4_COL = 9;
    public static final int ACT_5_COL = 10;
    public static final int SNR_1_COL = 11;
    public static final int SNR_2_COL = 12;
    public static final int SNR_3_COL = 13;
    public static final int SNR_4_COL = 14;
    public static final int SNR_5_COL = 15;
    public static final int PRN_1_COL = 16;
    public static final int PRN_2_COL = 17;
    public static final int PRN_3_COL = 18;
    public static final int PRN_4_COL = 19;
    public static final int PRN_5_COL = 20;

    public RockwellGpsSatelliteBundle() {
        super(15);
    }

    public RockwellGpsSatelliteBundle(byte[] buffer, int index) {
        super(buffer, index, 15);
    }

    public RockwellGpsSatelliteBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 15);
    }

    public SohBundle createBundle() {
        return new RockwellGpsSatelliteBundle();
    }

    public int getStatusBits() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public String getNavState() {
        int statusBits = this.getStatusBits();
        int navMode = statusBits >> 3 & 1;
        int altInfo = statusBits >> 0 & 7;
        if (navMode != 0) {
            if ((altInfo & 2) != 0) {
                return "2DNav";
            }
            return "3DNav";
        }
        if (this.getNumberOfSatellitesBeingTracked() > 0) {
            return "Tracking";
        }
        return "Searching";
    }

    public int getNavStateAsInt() {
        int statusBits = this.getStatusBits();
        int navMode = statusBits >> 3 & 1;
        int altInfo = statusBits >> 0 & 7;
        if (navMode != 0) {
            if ((altInfo & 2) != 0) {
                return 3;
            }
            return 4;
        }
        if ((statusBits >> 7 & 1) != 0) {
            return 1;
        }
        return 2;
    }

    public int getFigureOfMerit() {
        int statusBits = this.getStatusBits();
        return statusBits >> 8 & 0xF;
    }

    public int getChannelInfo(int channel) {
        if (channel >= 0 && channel < 5) {
            return LittleEndian.readShort(this.guts, 7 + 2 * channel);
        }
        return 0;
    }

    public int getSatellitePRN(int channel) {
        return this.getChannelInfo(channel) >> 0 & 0x1F;
    }

    public int getChannelSNR(int channel) {
        return this.getChannelInfo(channel) >> 8 & 0x3F;
    }

    public int getChannelActivity(int channel) {
        return this.getChannelInfo(channel) >> 14 & 3;
    }

    public int getMaxSNRatio() {
        int maxSNRatio = 0;
        int channel = 0;
        while (channel < 5) {
            int snr = this.getChannelSNR(channel);
            if (snr > maxSNRatio) {
                maxSNRatio = snr;
            }
            ++channel;
        }
        return maxSNRatio;
    }

    public int getNumberOfSatellitesBeingTracked() {
        int trackCount = 0;
        int channel = 0;
        while (channel < 5) {
            int activity = this.getChannelActivity(channel);
            if (activity >= 2) {
                ++trackCount;
            }
            ++channel;
        }
        return trackCount;
    }

    public int getNumSatellitesUsed() {
        int statusBits = this.getStatusBits();
        return statusBits >> 4 & 7;
    }

    public int getAutoSurveyModeNum() {
        return this.getStatusBits() >> 4 & 1;
    }

    public int getInsufficientVisSatellitesNum() {
        return this.getStatusBits() >> 3 & 1;
    }

    public int getEnginePoweredNum() {
        return this.getStatusBits() & 1;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new RockwellGpsSatelliteBundle(bytes, index);
    }

    public String getCsvName() {
        return "gst";
    }

    public String getCsvTitle() {
        return "Gps Channel SOH for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%2d");
        sb.append("," + f.form(this.getNavStateAsInt()));
        sb.append("," + f.form(this.getFigureOfMerit()));
        sb.append("," + f.form(this.getNumSatellitesUsed()));
        int numTracked = this.getNumberOfSatellitesBeingTracked();
        sb.append("," + f.form(numTracked));
        int i = 0;
        while (i < 5) {
            sb.append("," + f.form(this.getChannelActivity(i)));
            ++i;
        }
        f = new Format("%3d");
        i = 0;
        while (i < 5) {
            sb.append("," + f.form(this.getChannelSNR(i)));
            ++i;
        }
        i = 0;
        while (i < 5) {
            sb.append("," + f.form(this.getSatellitePRN(i)));
            ++i;
        }
        return sb.toString();
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
        }
        if (index < 21) {
            return "integer";
        }
        return "";
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getNavStateAsInt());
            }
            case 3: {
                return new Integer(this.getFigureOfMerit());
            }
            case 4: {
                return new Integer(this.getNumSatellitesUsed());
            }
            case 5: {
                return new Integer(this.getNumberOfSatellitesBeingTracked());
            }
            case 6: {
                return new Integer(this.getChannelActivity(0));
            }
            case 7: {
                return new Integer(this.getChannelActivity(1));
            }
            case 8: {
                return new Integer(this.getChannelActivity(2));
            }
            case 9: {
                return new Integer(this.getChannelActivity(3));
            }
            case 10: {
                return new Integer(this.getChannelActivity(4));
            }
            case 11: {
                return new Integer(this.getChannelSNR(0));
            }
            case 12: {
                return new Integer(this.getChannelSNR(1));
            }
            case 13: {
                return new Integer(this.getChannelSNR(2));
            }
            case 14: {
                return new Integer(this.getChannelSNR(3));
            }
            case 15: {
                return new Integer(this.getChannelSNR(4));
            }
            case 16: {
                return new Integer(this.getSatellitePRN(0));
            }
            case 17: {
                return new Integer(this.getSatellitePRN(1));
            }
            case 18: {
                return new Integer(this.getSatellitePRN(2));
            }
            case 19: {
                return new Integer(this.getSatellitePRN(3));
            }
            case 20: {
                return new Integer(this.getSatellitePRN(4));
            }
        }
        return null;
    }

    public int getPrecisionByIndex(int index) {
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "SolnState";
            }
            case 3: {
                return "FigMerit";
            }
            case 4: {
                return "NSatForSoln";
            }
            case 5: {
                return "NSatTracked";
            }
            case 6: {
                return "Act1";
            }
            case 7: {
                return "Act2";
            }
            case 8: {
                return "Act3";
            }
            case 9: {
                return "Act4";
            }
            case 10: {
                return "Act5";
            }
            case 11: {
                return "SNR1";
            }
            case 12: {
                return "SNR2";
            }
            case 13: {
                return "SNR3";
            }
            case 14: {
                return "SNR4";
            }
            case 15: {
                return "SNR5";
            }
            case 16: {
                return "PRN1";
            }
            case 17: {
                return "PRN2";
            }
            case 18: {
                return "PRN3";
            }
            case 19: {
                return "PRN4";
            }
            case 20: {
                return "PRN5";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 21;
    }

    public String getName() {
        return "GPS Satellite Status";
    }
}

