/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RxSlotErrorBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 47;
    static final int OFFSET_TO_SLOT = 5;
    static final int OFFSET_TO_BAD = 9;
    static final int OFFSET_TO_GOOD = 13;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TRANS_IP_COL = 2;
    public static final int BAD_PKTS_COL = 3;
    public static final int GOOD_PKTS_COL = 4;

    public RxSlotErrorBundle() {
        super(47);
    }

    public RxSlotErrorBundle(byte[] buffer, int index) {
        super(buffer, index, 47);
    }

    public RxSlotErrorBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 47);
    }

    public RxSlotErrorBundle(int txIp, int numberOfBadInThePastHour, int numberOfGoodInThePastHour) {
        super(47, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeInt(this.guts, 5, txIp);
        LittleEndian.writeShort(this.guts, 9, (short)numberOfBadInThePastHour);
        LittleEndian.writeInt(this.guts, 13, numberOfGoodInThePastHour);
    }

    public SohBundle createBundle() {
        return new RxSlotErrorBundle();
    }

    public int getSlotId() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public String getTxIp() {
        return this.getSlotIdName(this.getSlotId());
    }

    public int getNumOfRxdBadPackets() {
        return LittleEndian.readInt(this.guts, 9);
    }

    public int getNumOfRxdGoodPackets() {
        return LittleEndian.readInt(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new RxSlotErrorBundle(bytes, index);
    }

    public String getCsvName() {
        return "rse";
    }

    public String getCsvTitle() {
        return "VSat: Receiver Slot Errors for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%15s");
        sb.append("," + f.form(this.getTxIp()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getNumOfRxdBadPackets()));
        sb.append("," + f.form(this.getNumOfRxdGoodPackets()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getTxIp();
            }
            case 3: {
                return new Integer(this.getNumOfRxdBadPackets());
            }
            case 4: {
                return new Integer(this.getNumOfRxdGoodPackets());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "TransmitterIP";
            }
            case 3: {
                return "BadPackets";
            }
            case 4: {
                return "GoodPackets";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Receiver Slot Errors";
    }
}

