/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RxSlotStateBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 44;
    static final int OFFSET_TO_SLOT = 5;
    static final int OFFSET_TO_LEVEL = 9;
    static final int OFFSET_TO_COFFSET = 11;
    static final int OFFSET_TO_SOFFSET = 13;
    static final int OFFSET_TO_RXRB = 15;
    private static final int NUMBER_OF_COLUMNS = 7;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TRANS_IP_COL = 2;
    public static final int DQT_AGC_COL = 3;
    public static final int CARRIER_OFFSET_COL = 4;
    public static final int SYMBOL_OFFSET_COL = 5;
    public static final int DCL_AGC_COL = 6;

    public RxSlotStateBundle() {
        super(44);
    }

    public RxSlotStateBundle(byte[] buffer, int index) {
        super(buffer, index, 44);
    }

    public RxSlotStateBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 44);
    }

    public RxSlotStateBundle(int txIp, int carrierOffset, int carrierLevel, int symbolOffset, int RxRb_No) {
        super(44, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeInt(this.guts, 5, txIp);
        LittleEndian.writeShort(this.guts, 9, (short)carrierLevel);
        LittleEndian.writeShort(this.guts, 11, (short)carrierOffset);
        LittleEndian.writeShort(this.guts, 13, (short)symbolOffset);
        this.guts[15] = (byte)RxRb_No;
    }

    public SohBundle createBundle() {
        return new RxSlotStateBundle();
    }

    public int getSlotId() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public String getRxIp() {
        return this.getSlotIdName(this.getSlotId());
    }

    public float getCarrierLevel() {
        return (float)((double)LittleEndian.readShort(this.guts, 9) / 10.0);
    }

    public int getCarrierOffset() {
        return LittleEndian.readShort(this.guts, 11) * 10;
    }

    public int getSymbolOffset() {
        return LittleEndian.readShort(this.guts, 13);
    }

    public double getRxRb() {
        return (double)(this.guts[15] & 0xFF) / 10.0;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new RxSlotStateBundle(bytes, index);
    }

    public String getCsvName() {
        return "rss";
    }

    public String getCsvTitle() {
        return "VSat: Receiver Slot State for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%15s");
        sb.append("," + f.form(this.getRxIp()));
        f = new Format("%5.1f");
        sb.append("," + f.form(this.getCarrierLevel()));
        f = new Format("%9d");
        sb.append("," + f.form(this.getCarrierOffset()));
        sb.append("," + f.form(this.getSymbolOffset()));
        f = new Format("%5.1f");
        sb.append("," + f.form(this.getRxRb()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getRxIp();
            }
            case 3: {
                return new Double(this.getCarrierLevel());
            }
            case 4: {
                return new Integer(this.getCarrierOffset());
            }
            case 5: {
                return new Integer(this.getSymbolOffset());
            }
            case 6: {
                return new Double(this.getRxRb());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 1;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "TransmitterIP";
            }
            case 3: {
                return "DQT_AGC";
            }
            case 4: {
                return "CarrierOffset";
            }
            case 5: {
                return "SymbolOffset";
            }
            case 6: {
                return "DCL_AGC";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 3: 
            case 6: {
                thresholds[0] = 0.0;
                thresholds[1] = 0.5;
                thresholds[2] = 6.0;
                thresholds[3] = 10.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getName() {
        return "Receiver Slot SOH";
    }
}

