/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RxSlotTimeBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 46;
    static final int OFFSET_TO_SLOTNUM = 5;
    static final int OFFSET_TO_START = 6;
    static final int OFFSET_TO_END = 10;

    public RxSlotTimeBundle(byte[] buffer, int index) throws InvalidInputException {
        super(buffer, index, 46, "RxSlotTimeBundle");
    }

    public RxSlotTimeBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 46);
    }

    public RxSlotTimeBundle(int slotNum, int startTime, int endTime) {
        super(46, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)slotNum;
        LittleEndian.writeInt(this.guts, 6, startTime);
        LittleEndian.writeInt(this.guts, 10, endTime);
    }

    public int getSlotNum() {
        return this.guts[5];
    }

    public int getStartTime() {
        return LittleEndian.readInt(this.guts, 6);
    }

    public int getEndTime() {
        return LittleEndian.readInt(this.guts, 10);
    }
}

