/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class SerialPortMapBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 41;
    static final int OFFSET_TO_MINUTES = 7;
    static final int OFFSET_TO_HRD = 9;
    static final int OFFSET_TO_PORT = 6;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int INDEX_COL = 2;
    public static final int PORT_COL = 3;
    public static final int MINUTES_COL = 4;
    public static final int HRD_ID_COL = 5;

    public SohBundle createBundle() {
        return new SerialPortMapBundle();
    }

    public SerialPortMapBundle() {
        super(41);
    }

    public SerialPortMapBundle(byte[] buffer, int index) {
        super(buffer, index, 41);
    }

    public SerialPortMapBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 41);
    }

    public SerialPortMapBundle(int index, int port, int minutes, int hrdId) {
        super(41, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)index;
        this.guts[6] = (byte)port;
        LittleEndian.writeShort(this.guts, 7, (short)minutes);
        LittleEndian.writeShort(this.guts, 9, (short)hrdId);
    }

    public int getIndex() {
        return this.guts[5];
    }

    public int getPort() {
        return this.guts[6];
    }

    public void setPort(int port) {
        if (this.emptyBundle()) {
            return;
        }
        Integer p = new Integer(port);
        byte[] bytes = new byte[17];
        int index = 0;
        while (index < 17) {
            bytes[index] = index != 6 ? this.guts[index] : p.byteValue();
            ++index;
        }
        this.guts = bytes;
    }

    public boolean hasPort() {
        return true;
    }

    public int getMinutes() {
        return LittleEndian.readShort(this.guts, 7);
    }

    public int getHrdId() {
        return LittleEndian.readShort(this.guts, 9);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new SerialPortMapBundle(bytes, index);
    }

    public String getCsvName() {
        return "spm";
    }

    public String getCsvTitle() {
        return "RM4 serial port map for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%3d");
        sb.append("," + f.form(this.getIndex()));
        sb.append("," + f.form(this.getPort()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getMinutes()));
        sb.append("," + f.form(this.getHrdId()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getIndex());
            }
            case 3: {
                return new Integer(this.getPort());
            }
            case 4: {
                return new Integer(this.getMinutes());
            }
            case 5: {
                return new Integer(this.getHrdId());
            }
        }
        return null;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "Index";
            }
            case 3: {
                return "Port";
            }
            case 4: {
                return "MinutesSinceLast";
            }
            case 5: {
                return "HrdID";
            }
        }
        return "";
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        return 0;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "Serial Port Map";
    }
}

