/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class TridentPllStatusBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 68;
    static final int OFFSET_TO_STATE = 5;
    static final int OFFSET_TO_COUNTS = 7;
    static final int OFFSET_TO_TIME_ERROR = 9;
    static final int OFFSET_TO_TEMPERATURE = 13;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int CURRENT_STATE_COL = 2;
    public static final int DAC_COUNTS_COL = 3;
    public static final int TIME_ERROR_COL = 4;
    public static final int TEMPERATURE_COL = 5;
    public static final String[] states = new String[]{"INIT", "TIME", "ACQ0", "TRK1", "TRK2", "TRK3", "TRK4"};

    public TridentPllStatusBundle() {
        super(68);
    }

    public TridentPllStatusBundle(byte[] buffer, int index) {
        super(buffer, index, 68);
    }

    public TridentPllStatusBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 68);
    }

    public SohBundle createBundle() {
        return new TridentPllStatusBundle();
    }

    public double getTemperature() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public double getTimeError() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public int getDacCounts() {
        return LittleEndian.readUShort(this.guts, 7);
    }

    public int getState() {
        return LittleEndian.readUShort(this.guts, 5);
    }

    public String getStateString() {
        if (this.getState() < states.length) {
            return states[this.getState()];
        }
        return "Undefined";
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new TridentPllStatusBundle(bytes, index);
    }

    public String getCsvName() {
        return "tpl";
    }

    public String getCsvTitle() {
        return "Trident PLL Status: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%2d");
        sb.append("," + f.form(this.getState()));
        f = new Format("%5d");
        sb.append("," + f.form(this.getDacCounts()));
        f = new Format("%11.2f");
        sb.append("," + f.form(this.getTimeError()));
        sb.append("," + f.form(this.getTemperature()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getState());
            }
            case 3: {
                return new Integer(this.getDacCounts());
            }
            case 4: {
                return new Double(this.getTimeError());
            }
            case 5: {
                return new Double(this.getTemperature());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "Current State";
            }
            case 3: {
                return "DAC counts";
            }
            case 4: {
                return "Time Error(us)";
            }
            case 5: {
                return "Temperature(C)";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 3: {
                thresholds[0] = 1024.0;
                thresholds[1] = 1536.0;
                thresholds[2] = 2560.0;
                thresholds[3] = 3072.0;
                break;
            }
            case 4: {
                thresholds[0] = -100.0;
                thresholds[1] = -1.25;
                thresholds[2] = 1.25;
                thresholds[3] = 100.0;
                break;
            }
            case 5: {
                thresholds[0] = -10.0;
                thresholds[1] = -5.0;
                thresholds[2] = 50.0;
                thresholds[3] = 55.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "Trident PLL Status";
    }
}

