/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class VSatReceiverBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 51;
    static final int OFFSET_TO_IP = 5;
    static final int OFFSET_TO_RXFREQ = 9;
    private static final int NUMBER_OF_COLUMNS = 4;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TRANS_IP_COL = 2;
    public static final int RECEIVER_FREQ_COL = 3;

    public VSatReceiverBundle() {
        super(51);
    }

    public VSatReceiverBundle(byte[] buffer, int index) {
        super(buffer, index, 51);
    }

    public VSatReceiverBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 51);
    }

    public SohBundle createBundle() {
        return new VSatReceiverBundle();
    }

    public int getSlotId() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public String getTxIp() {
        return Instrument.getNameOf(this.getSlotId());
    }

    public double getRxFreq() {
        int val = LittleEndian.readInt(this.guts, 9);
        return (double)val / 10000.0;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new VSatReceiverBundle(bytes, index);
    }

    public String getCsvName() {
        return "rxb";
    }

    public String getCsvTitle() {
        return "VSat: Receiver for Instrument: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%15s");
        sb.append("," + f.form(this.getTxIp()));
        f = new Format("%14.4f");
        sb.append("," + f.form(this.getRxFreq()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getTxIp();
            }
            case 3: {
                return new Double(this.getRxFreq());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "TransmitterIP";
            }
            case 3: {
                return "ReceiverFreq(MHz)";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 3: {
                thresholds[0] = 0.0;
                thresholds[1] = 950.0;
                thresholds[2] = 1450.0;
                thresholds[3] = 2000.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getName() {
        return "Receiver SOH";
    }
}

