/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import ca.nanometrics.io.MappedRandomAccessFile;
import ca.nanometrics.io.RandomAccessIF;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class MultiMappedFile
implements RandomAccessIF {
    public static final String DEFAULT_FILE_PREFIX = "NmxVolume_";
    public static final int WRITE_BUFFER_SIZE = 16384;
    public static final int READ_BUFFER_SIZE = 131072;
    private ArrayList m_volumeFiles = null;
    private long m_curFilePtr = -1L;
    private long m_fileSize = 0L;
    private int m_curFileIdx = 0;
    private boolean m_isComplete;
    private byte[] m_buf = new byte[8];
    private WriteBuffer m_buffer;
    private ReadCache m_cache;

    public MultiMappedFile(String dir, long multiFileSize, long volumeSize, int writeBufferSize, int readBufferSize) throws IOException {
        File volumesDir = new File(dir);
        if (!volumesDir.exists()) {
            throw new FileNotFoundException("Directory for files does not exist: " + dir);
        }
        if (volumeSize > multiFileSize) {
            throw new IOException("The multiFileSize (" + multiFileSize + ") is less than the volume size (" + volumeSize + ")");
        }
        int numVolumes = this.calculateNumberOfVolumes(multiFileSize, volumeSize);
        this.m_volumeFiles = new ArrayList();
        long startOffset = 0L;
        long chainID = System.currentTimeMillis();
        StringBuffer volumeFileNameBuffer = new StringBuffer();
        volumeFileNameBuffer.append(dir);
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            volumeFileNameBuffer.append("/");
        }
        volumeFileNameBuffer.append(DEFAULT_FILE_PREFIX);
        int index = 0;
        while (index < numVolumes) {
            long size = volumeSize;
            if (index == numVolumes - 1) {
                size = multiFileSize - volumeSize * (long)(numVolumes - 1);
            }
            MappedRandomAccessFile vFile = new MappedRandomAccessFile(String.valueOf(volumeFileNameBuffer.toString()) + this.makeFixedString(index + 1), startOffset, size, index == numVolumes - 1, chainID);
            this.m_volumeFiles.add(vFile);
            startOffset += vFile.getDatalength();
            ++index;
        }
        this.m_fileSize = startOffset;
        this.m_isComplete = true;
        this.initBuffers(writeBufferSize, readBufferSize);
    }

    public int calculateNumberOfVolumes(long multiFileSize, long volumeSize) {
        int numberOfVolumes = (int)(multiFileSize / volumeSize);
        if (multiFileSize % volumeSize != 0L) {
            ++numberOfVolumes;
        }
        return numberOfVolumes;
    }

    private String makeFixedString(int i) {
        if (i < 10) {
            return "00" + Integer.toString(i);
        }
        if (i < 100) {
            return "0" + Integer.toString(i);
        }
        return Integer.toString(i);
    }

    public MultiMappedFile(long multiFileSize, long volumeSize) throws IOException {
        this("./", multiFileSize, volumeSize);
    }

    public MultiMappedFile(String dir, long multiFileSize, long volumeSize) throws IOException {
        this(dir, multiFileSize, volumeSize, 16384, 131072);
    }

    public MultiMappedFile(String[] files, int writeBufferSize, int readBufferSize) throws FileNotFoundException, IOException {
        this.m_volumeFiles = new ArrayList();
        int i = 0;
        while (i < files.length) {
            this.m_volumeFiles.add(new MappedRandomAccessFile(files[i]));
            ++i;
        }
        Collections.sort(this.m_volumeFiles);
        this.m_fileSize = 0L;
        i = 0;
        while (i < this.m_volumeFiles.size()) {
            this.m_fileSize += this.getVolume(i).getDatalength();
            ++i;
        }
        this.verify();
        this.initBuffers(writeBufferSize, readBufferSize);
    }

    public MultiMappedFile(String[] files) throws FileNotFoundException, IOException {
        this(files, 16384, 131072);
    }

    private void initBuffers(int writeBufferSize, int readBufferSize) throws IOException {
        this.m_curFilePtr = -1L;
        this.m_curFileIdx = 0;
        this.m_buffer = new WriteBuffer(writeBufferSize, this.getCurrentVolume().getDatalength());
        this.m_cache = new ReadCache(readBufferSize);
        this.seek(0L);
    }

    public boolean isComplete() {
        return this.m_isComplete;
    }

    public void delete() throws IOException {
        this.close();
        int i = 0;
        while (i < this.m_volumeFiles.size()) {
            File file = new File(this.getVolume(i).getName());
            file.delete();
            ++i;
        }
    }

    public void close() throws IOException {
        this.m_buffer.checkFlush();
        int i = 0;
        while (i < this.m_volumeFiles.size()) {
            this.getVolume(i).close();
            ++i;
        }
    }

    public void flush() throws IOException {
        this.m_buffer.checkFlush();
        int i = 0;
        while (i < this.m_volumeFiles.size()) {
            this.getVolume(i).flush();
            ++i;
        }
    }

    public long getPointer() {
        return this.m_curFilePtr + (long)this.m_buffer.m_offset + (long)this.m_cache.m_offset;
    }

    public long getSize() {
        return this.m_fileSize;
    }

    public void setLength(long length) throws IOException {
        throw new IOException("Not implemented yet " + length);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void seek(long position) throws IOException {
        if (position == this.getPointer()) {
            return;
        }
        this.m_buffer.checkFlush();
        if (this.m_cache.seek(position)) {
            return;
        }
        int first = 0;
        int last = this.m_volumeFiles.size();
        MappedRandomAccessFile vFile = this.getVolume(this.m_curFileIdx);
        if (position < vFile.getGlobalStartPtr()) {
            last = this.m_curFileIdx;
        } else {
            if (position < vFile.getGlobalEndPtr()) {
                vFile.seek(position);
                this.m_curFilePtr = position;
                this.m_buffer.setSize(vFile.getGlobalEndPtr() - this.m_curFilePtr);
                return;
            }
            first = this.m_curFileIdx;
        }
        while (first != last) {
            int mid = (first + last) / 2;
            vFile = this.getVolume(mid);
            if (position < vFile.getGlobalStartPtr()) {
                last = mid;
                continue;
            }
            if (position < vFile.getGlobalEndPtr()) {
                vFile.seek(position);
                this.m_curFilePtr = position;
                this.m_curFileIdx = mid;
                this.m_buffer.setSize(vFile.getGlobalEndPtr() - this.m_curFilePtr);
                return;
            }
            first = mid + 1;
        }
        throw new IOException("Seek to invalid position: " + Long.toString(position) + "(valid 0-" + this.getSize() + ")");
    }

    public int skipBytes(int n) throws IOException {
        this.m_buffer.checkFlush();
        if (!this.m_cache.skip(n)) {
            long filePtr = this.m_curFilePtr;
            this.changeFilePtr(n);
            this.checkFilePtr();
            int bytesSkipped = (int)(this.m_curFilePtr - filePtr);
            if (bytesSkipped > 0) {
                this.getVolume(this.m_curFileIdx).seek(this.m_curFilePtr);
                return bytesSkipped;
            }
            return 0;
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.m_cache.read(b, off, len);
        return len;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) == -1) {
            throw new EOFException();
        }
    }

    public int read() throws IOException {
        return this.m_cache.read();
    }

    public String readLine() throws IOException {
        throw new IOException("Not implemented");
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public boolean readBoolean() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException("readBoolean: Unexpected end of stream");
        }
        return b != 0;
    }

    public byte readByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException("readByte: Unexpected end of stream");
        }
        return (byte)b;
    }

    public int readUnsignedByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException("readUnsignedByte: Unexpected end of stream");
        }
        return b & 0xFF;
    }

    public short readShort() throws IOException {
        this.readFully(this.m_buf, 0, 2);
        return (short)(this.m_buf[0] << 8 | this.m_buf[1] & 0xFF);
    }

    public int readUnsignedShort() throws IOException {
        this.readFully(this.m_buf, 0, 2);
        return (this.m_buf[0] & 0xFF) << 8 | this.m_buf[1] & 0xFF;
    }

    public char readChar() throws IOException {
        this.readFully(this.m_buf, 0, 2);
        return (char)(this.m_buf[0] << 8 | this.m_buf[1] & 0xFF);
    }

    public int readInt() throws IOException {
        this.readFully(this.m_buf, 0, 4);
        return (this.m_buf[0] & 0xFF) << 24 | (this.m_buf[1] & 0xFF) << 16 | (this.m_buf[2] & 0xFF) << 8 | this.m_buf[3] & 0xFF;
    }

    public long readLong() throws IOException {
        this.readFully(this.m_buf, 0, 8);
        return (long)(this.m_buf[0] & 0xFF) << 56 | (long)(this.m_buf[1] & 0xFF) << 48 | (long)(this.m_buf[2] & 0xFF) << 40 | (long)(this.m_buf[3] & 0xFF) << 32 | (long)(this.m_buf[4] & 0xFF) << 24 | (long)(this.m_buf[5] & 0xFF) << 16 | (long)(this.m_buf[6] & 0xFF) << 8 | (long)(this.m_buf[7] & 0xFF);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readUTF() throws IOException {
        short len = this.readShort();
        byte[] buf = new byte[len];
        this.readFully(buf);
        return new String(buf, "UTF-8");
    }

    public void write(int b) throws IOException {
        this.m_buffer.add(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.m_buffer.add(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int b) throws IOException {
        this.write(b);
    }

    public void writeShort(int v) throws IOException {
        this.m_buf[0] = (byte)(v >>> 8 & 0xFF);
        this.m_buf[1] = (byte)(v & 0xFF);
        this.write(this.m_buf, 0, 2);
    }

    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public void writeInt(int v) throws IOException {
        this.m_buf[0] = (byte)(v >>> 24 & 0xFF);
        this.m_buf[1] = (byte)(v >>> 16 & 0xFF);
        this.m_buf[2] = (byte)(v >>> 8 & 0xFF);
        this.m_buf[3] = (byte)(v & 0xFF);
        this.write(this.m_buf, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.m_buf[0] = (byte)(v >>> 56 & 0xFFL);
        this.m_buf[1] = (byte)(v >>> 48 & 0xFFL);
        this.m_buf[2] = (byte)(v >>> 40 & 0xFFL);
        this.m_buf[3] = (byte)(v >>> 32 & 0xFFL);
        this.m_buf[4] = (byte)(v >>> 24 & 0xFFL);
        this.m_buf[5] = (byte)(v >>> 16 & 0xFFL);
        this.m_buf[6] = (byte)(v >>> 8 & 0xFFL);
        this.m_buf[7] = (byte)(v & 0xFFL);
        this.write(this.m_buf, 0, 8);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBytes(String str) throws IOException {
        this.write(str.getBytes());
    }

    public void writeChars(String str) throws IOException {
        int len = str.length();
        if (len == 0) {
            return;
        }
        byte[] b = new byte[len * 2];
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            b[i * 2] = (byte)(c >>> 8 & 0xFF);
            b[i * 2 + 1] = (byte)(c & 0xFF);
            ++i;
        }
        this.write(b, 0, b.length);
    }

    public void writeUTF(String str) throws IOException {
        byte[] buf = str.getBytes("UTF-8");
        this.writeShort((short)buf.length);
        this.write(buf);
    }

    public String[] getVolumeFileNames() {
        String[] names = new String[this.m_volumeFiles.size()];
        int i = 0;
        while (i < this.m_volumeFiles.size()) {
            names[i] = ((MappedRandomAccessFile)this.m_volumeFiles.get(i)).getName();
            ++i;
        }
        return names;
    }

    private void verify() {
        if (this.getVolume(0).getGlobalStartPtr() != 0L) {
            this.m_isComplete = false;
            return;
        }
        int i = 1;
        while (i < this.m_volumeFiles.size()) {
            if (this.getVolume(i).getGlobalStartPtr() != this.getVolume(i - 1).getGlobalEndPtr()) {
                this.m_isComplete = false;
                return;
            }
            ++i;
        }
        if (!this.getVolume(this.m_volumeFiles.size() - 1).isTheLastFile()) {
            this.m_isComplete = false;
        }
    }

    private MappedRandomAccessFile getVolume(int i) {
        return (MappedRandomAccessFile)this.m_volumeFiles.get(i);
    }

    private MappedRandomAccessFile getCurrentVolume() {
        return (MappedRandomAccessFile)this.m_volumeFiles.get(this.m_curFileIdx);
    }

    private void changeFilePtr(long inc) {
        this.m_curFilePtr += inc;
    }

    private void checkFilePtr() throws IOException {
        boolean doesSeek = false;
        while (this.m_curFilePtr >= this.getCurrentVolume().getGlobalEndPtr()) {
            if (this.m_curFileIdx >= this.m_volumeFiles.size() - 1) {
                throw new EOFException("index of of range.");
            }
            ++this.m_curFileIdx;
            doesSeek = true;
        }
        if (doesSeek) {
            this.getCurrentVolume().seek(this.m_curFilePtr);
        }
    }

    class ReadCache {
        private byte[] m_array;
        int m_offset = 0;
        int m_size = 0;

        public ReadCache(int maxSize) {
            this.m_array = new byte[maxSize];
        }

        public void setSize(long size) {
            this.m_size = size < (long)this.m_array.length ? (int)size : this.m_array.length;
        }

        public boolean isEmpty() {
            return this.m_offset == this.m_size;
        }

        public int read() throws IOException {
            this.checkFill();
            byte data = this.m_array[this.m_offset];
            ++this.m_offset;
            return data;
        }

        public void read(byte[] data, int offset, int length) throws IOException {
            while (length > 0) {
                this.checkFill();
                int available = this.m_size - this.m_offset;
                int copy = length < available ? length : available;
                System.arraycopy(this.m_array, this.m_offset, data, offset, copy);
                offset += copy;
                this.m_offset += copy;
                length -= copy;
            }
        }

        public boolean skip(int count) {
            if (this.m_offset + count < this.m_size) {
                this.m_offset += count;
                return true;
            }
            this.reset();
            return false;
        }

        public boolean seek(long pos) {
            if (pos >= MultiMappedFile.this.m_curFilePtr && pos < MultiMappedFile.this.m_curFilePtr + (long)this.m_size) {
                this.m_offset = (int)(pos - MultiMappedFile.this.m_curFilePtr);
                return true;
            }
            this.reset();
            return false;
        }

        public void reset() {
            MultiMappedFile.this.changeFilePtr(this.m_offset);
            this.m_offset = 0;
            this.m_size = 0;
        }

        public void checkFill() throws IOException {
            if (this.isEmpty()) {
                this.fill();
            }
        }

        public void fill() throws IOException {
            MultiMappedFile.this.m_buffer.checkFlush();
            this.reset();
            MultiMappedFile.this.checkFilePtr();
            this.setSize(MultiMappedFile.this.getCurrentVolume().getGlobalEndPtr() - MultiMappedFile.this.m_curFilePtr);
            MultiMappedFile.this.getCurrentVolume().readFully(this.m_array, 0, this.m_size);
            ((MultiMappedFile)MultiMappedFile.this).m_buffer.m_needSeek = true;
        }
    }

    class WriteBuffer {
        private byte[] m_array;
        int m_offset = 0;
        int m_size = 0;
        boolean m_needSeek = false;

        public WriteBuffer(int maxSize, long currentSize) {
            this.m_array = new byte[maxSize];
            this.setSize(currentSize);
        }

        public boolean isEmpty() {
            return this.m_offset == 0;
        }

        public void setSize(long size) {
            this.m_size = size < (long)this.m_array.length ? (int)size : this.m_array.length;
        }

        public void add(int aByte) throws IOException {
            if (this.m_size - this.m_offset > 0) {
                this.m_array[this.m_offset] = (byte)aByte;
                ++this.m_offset;
            }
            this.checkWrite();
        }

        public void add(byte[] data, int offset, int length) throws IOException {
            while (length > 0) {
                int available = this.m_size - this.m_offset;
                int copy = length < available ? length : available;
                System.arraycopy(data, offset, this.m_array, this.m_offset, copy);
                offset += copy;
                this.m_offset += copy;
                length -= copy;
                this.checkWrite();
            }
        }

        public void checkWrite() throws IOException {
            if (this.m_size == 0) {
                throw new IOException("Writing past end of file");
            }
            if (this.m_offset == this.m_size) {
                this.flush();
            }
        }

        public void checkFlush() throws IOException {
            if (!this.isEmpty()) {
                this.flush();
            }
        }

        public void flush() throws IOException {
            if (this.m_needSeek) {
                MultiMappedFile.this.m_cache.reset();
                MultiMappedFile.this.getCurrentVolume().seek(MultiMappedFile.this.m_curFilePtr);
                this.m_needSeek = false;
            }
            MultiMappedFile.this.checkFilePtr();
            MultiMappedFile.this.getCurrentVolume().write(this.m_array, 0, this.m_offset);
            MultiMappedFile.this.changeFilePtr(this.m_offset);
            this.m_offset = 0;
            if (MultiMappedFile.this.m_curFilePtr < MultiMappedFile.this.getSize()) {
                MultiMappedFile.this.checkFilePtr();
                this.setSize(MultiMappedFile.this.getCurrentVolume().getGlobalEndPtr() - MultiMappedFile.this.m_curFilePtr);
            } else {
                this.setSize(0L);
            }
        }
    }
}

